/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.PrescriptionEntryTypeFactory;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class MedicationRequestPrescriptionTransformer
implements IFhirTransformer<MedicationRequest, IPrescription> {
    public static final String EXTENSION_PRESCRIPTION_ENTRYTYPE_URL = "www.elexis.info/extensions/prescription/entrytype";
    @org.osgi.service.component.annotations.Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @org.osgi.service.component.annotations.Reference
    private IContextService contextService;
    private PrescriptionEntryTypeFactory entryTypeFactory = new PrescriptionEntryTypeFactory();

    @Override
    public Optional<MedicationRequest> getFhirObject(IPrescription localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        String remark;
        String disposalComment;
        LocalDateTime dateUntil;
        Coding coding;
        MedicationRequest fhirObject = new MedicationRequest();
        MedicationRequest.MedicationRequestStatus statusEnum = MedicationRequest.MedicationRequestStatus.ACTIVE;
        fhirObject.setId((IIdType)new IdDt("MedicationRequest", localObject.getId()));
        fhirObject.addIdentifier(this.getElexisObjectIdentifier((Identifiable)localObject));
        fhirObject.setSubject(this.getPatientReference(localObject.getPatient()));
        StringBuilder textBuilder = new StringBuilder();
        CodeableConcept medication = new CodeableConcept();
        String gtin = this.getArticleGtin(localObject);
        String atc = this.getArticleAtc(localObject);
        String articelLabel = this.getArticleLabel(localObject);
        if (gtin != null) {
            coding = medication.addCoding();
            coding.setSystem("urn:oid:1.3.160");
            coding.setCode(gtin);
        }
        if (atc != null) {
            coding = medication.addCoding();
            coding.setSystem("urn:oid:2.16.840.1.113883.6.73\u200e");
            coding.setCode(atc);
        }
        medication.setText(articelLabel);
        textBuilder.append(articelLabel);
        medication.setText(textBuilder.toString());
        fhirObject.setMedication((Type)medication);
        MedicationRequest.MedicationRequestDispenseRequestComponent dispenseRequest = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        Period dispensePeriod = new Period();
        LocalDateTime dateFrom = localObject.getDateFrom();
        if (dateFrom != null) {
            Date time = Date.from(dateFrom.atZone(ZoneId.systemDefault()).toInstant());
            dispensePeriod.setStart(time);
        }
        if ((dateUntil = localObject.getDateTo()) != null) {
            Date time = Date.from(dateUntil.atZone(ZoneId.systemDefault()).toInstant());
            dispensePeriod.setEnd(time);
            String reasonText = localObject.getStopReason();
            if (reasonText != null && !reasonText.isEmpty()) {
                Annotation note = fhirObject.addNote();
                note.setText("Stop: " + reasonText);
            }
        }
        dispenseRequest.setValidityPeriod(dispensePeriod);
        fhirObject.setDispenseRequest(dispenseRequest);
        if (dateUntil != null && (dateUntil.isBefore(LocalDateTime.now()) || dateUntil.isEqual(dateFrom))) {
            statusEnum = MedicationRequest.MedicationRequestStatus.COMPLETED;
        }
        String dose = localObject.getDosageInstruction();
        Dosage dosage = null;
        if (dose != null && !dose.isEmpty()) {
            textBuilder.append(", ").append(dose);
            if (dosage == null) {
                dosage = fhirObject.addDosageInstruction();
            }
            dosage.setText(dose);
        }
        if ((disposalComment = localObject.getDisposalComment()) != null && !disposalComment.isEmpty()) {
            textBuilder.append(", ").append(disposalComment);
            if (dosage == null) {
                dosage = fhirObject.addDosageInstruction();
            }
            CodeableConcept additional = dosage.addAdditionalInstruction();
            additional.setText(disposalComment);
        }
        if ((remark = localObject.getRemark()) != null && !remark.isEmpty()) {
            textBuilder.append(", ").append(remark);
            Annotation annotation = new Annotation();
            annotation.setText(remark);
            fhirObject.addNote(annotation);
        }
        fhirObject.setStatus(statusEnum);
        Narrative narrative = new Narrative();
        narrative.setDivAsString(textBuilder.toString());
        fhirObject.setText(narrative);
        Extension elexisEntryType = new Extension();
        elexisEntryType.setUrl(EXTENSION_PRESCRIPTION_ENTRYTYPE_URL);
        EntryType entryType = localObject.getEntryType();
        elexisEntryType.setValue((Type)new Enumeration((EnumFactory)this.entryTypeFactory, (Enum)entryType));
        fhirObject.addExtension(elexisEntryType);
        return Optional.of(fhirObject);
    }

    private Reference getPatientReference(IPatient patient) {
        Reference ref = new Reference();
        ref.setId(patient.getId());
        return ref;
    }

    @Override
    public Optional<IPrescription> getLocalObject(MedicationRequest fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.modelService.load(id, IPrescription.class);
        }
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return MedicationRequest.class.equals(fhirClazz) && IPrescription.class.equals(localClazz);
    }

    @Override
    public Optional<IPrescription> updateLocalObject(MedicationRequest fhirObject, IPrescription localObject) {
        Optional localFhirObject = this.getFhirObject(localObject);
        if (!fhirObject.equalsDeep((Base)localFhirObject.get())) {
            localObject.setDateTo(LocalDateTime.now());
            localObject.setStopReason("Ge\u00e4ndert durch FHIR Server");
            this.modelService.save((Identifiable)localObject);
            return this.createLocalObject(fhirObject);
        }
        return Optional.empty();
    }

    private String getArticleGtin(IPrescription localObject) {
        IArticle localArticle = localObject.getArticle();
        if (localArticle != null) {
            return localArticle.getGtin();
        }
        return null;
    }

    private String getArticleAtc(IPrescription localObject) {
        IArticle localArticle = localObject.getArticle();
        if (localArticle != null) {
            return localArticle.getAtcCode();
        }
        return null;
    }

    private String getArticleLabel(IPrescription localObject) {
        IArticle localArticle = localObject.getArticle();
        if (localArticle != null) {
            return localArticle.getLabel();
        }
        return "Unknown article";
    }

    @Override
    public Optional<IPrescription> createLocalObject(MedicationRequest fhirObject) {
        Optional item = Optional.empty();
        Optional<String> gtin = this.getMedicationRequestGtin(fhirObject);
        if (gtin.isPresent()) {
            IQuery query = this.modelService.getQuery(IArticle.class);
            query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__GTIN, IQuery.COMPARATOR.EQUALS, (Object)gtin.get());
            item = query.executeSingleResult();
        } else {
            LoggerFactory.getLogger(this.getClass()).error("MedicationOrder with no gtin");
        }
        Optional patient = this.modelService.load(fhirObject.getSubject().getId(), IPatient.class);
        if (item.isPresent() && patient.isPresent()) {
            IPrescription localObject = (IPrescription)new IPrescriptionBuilder(this.modelService, this.contextService, (IArticle)item.get(), (IPatient)patient.get(), this.getMedicationRequestDosage(fhirObject)).build();
            Optional<LocalDateTime> startDateTime = this.getMedicationRequestStartDateTime(fhirObject);
            startDateTime.ifPresent(date -> localObject.setDateFrom(date));
            Optional<LocalDateTime> endDateTime = this.getMedicationRequestEndDateTime(fhirObject);
            endDateTime.ifPresent(date -> localObject.setDateFrom(date));
            localObject.setDisposalComment(this.getMedicationRequestAdditionalInstructions(fhirObject));
            localObject.setRemark(this.getMedicationRequestRemark(fhirObject));
            Optional<EntryType> prescriptionType = this.getMedicationRequestPrescriptionType(fhirObject);
            prescriptionType.ifPresent(entryType -> localObject.setEntryType(entryType));
            this.modelService.save((Identifiable)localObject);
            return Optional.of(localObject);
        }
        return Optional.empty();
    }

    private Optional<EntryType> getMedicationRequestPrescriptionType(MedicationRequest fhirObject) {
        List extensionsEntryType = fhirObject.getExtensionsByUrl(EXTENSION_PRESCRIPTION_ENTRYTYPE_URL);
        for (Extension extension : extensionsEntryType) {
            try {
                EntryType entryType = EntryType.valueOf((String)((String)((CodeType)extension.getValue()).getValue()));
                return Optional.of(entryType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private Optional<LocalDateTime> getMedicationRequestEndDateTime(MedicationRequest fhirObject) {
        Period period;
        MedicationRequest.MedicationRequestDispenseRequestComponent dispenseRequest = fhirObject.getDispenseRequest();
        if (dispenseRequest != null && (period = dispenseRequest.getValidityPeriod()) != null && period.hasEnd()) {
            Date endDate = period.getEnd();
            return Optional.of(LocalDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault()));
        }
        return Optional.empty();
    }

    private Optional<LocalDateTime> getMedicationRequestStartDateTime(MedicationRequest fhirObject) {
        Period period;
        MedicationRequest.MedicationRequestDispenseRequestComponent dispenseRequest = fhirObject.getDispenseRequest();
        if (dispenseRequest != null && (period = dispenseRequest.getValidityPeriod()) != null && period.hasStart()) {
            Date startDate = period.getStart();
            return Optional.of(LocalDateTime.ofInstant(startDate.toInstant(), ZoneId.systemDefault()));
        }
        return Optional.empty();
    }

    private String getMedicationRequestRemark(MedicationRequest fhirObject) {
        List notes = fhirObject.getNote();
        StringBuilder sb = new StringBuilder();
        for (Annotation annotation : notes) {
            String text = annotation.getText();
            if (text == null) continue;
            if (sb.length() == 0) {
                sb.append(text);
                continue;
            }
            sb.append(", ").append(text);
        }
        return sb.toString();
    }

    private String getMedicationRequestAdditionalInstructions(MedicationRequest fhirObject) {
        List instructions = fhirObject.getDosageInstruction();
        StringBuilder sb = new StringBuilder();
        for (Dosage dosage : instructions) {
            List additionals = dosage.getAdditionalInstruction();
            for (CodeableConcept codeableConcept : additionals) {
                String text = codeableConcept.getText();
                if (text == null) continue;
                if (sb.length() == 0) {
                    sb.append(text);
                    continue;
                }
                sb.append(", ").append(text);
            }
        }
        return sb.toString();
    }

    private Optional<String> getMedicationRequestGtin(MedicationRequest fhirObject) {
        Type medication = fhirObject.getMedication();
        if (medication instanceof CodeableConcept) {
            List codings = ((CodeableConcept)medication).getCoding();
            for (Coding coding : codings) {
                String codeSystem = coding.getSystem();
                if (!"urn:oid:1.3.160".equals(codeSystem)) continue;
                return Optional.of(coding.getCode());
            }
        }
        return Optional.empty();
    }

    private String getMedicationRequestDosage(MedicationRequest fhirObject) {
        List instructions = fhirObject.getDosageInstruction();
        StringBuilder sb = new StringBuilder();
        for (Dosage dosage : instructions) {
            String text = dosage.getText();
            if (text == null) continue;
            if (sb.length() == 0) {
                sb.append(text);
                continue;
            }
            sb.append(", ").append(text);
        }
        return sb.toString();
    }
}

