/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.IModelService;
import ch.rgw.tools.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class ClaimVerrechnetTransformer
implements IFhirTransformer<Claim, List<IBilled>> {
    @org.osgi.service.component.annotations.Reference
    private IFindingsService findingsService;
    @org.osgi.service.component.annotations.Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @org.osgi.service.component.annotations.Reference
    private IBillingService billingService;
    @org.osgi.service.component.annotations.Reference
    private ICodeElementService codeElementService;

    @Override
    public Optional<Claim> getFhirObject(List<IBilled> localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        return Optional.empty();
    }

    @Override
    public Optional<List<IBilled>> getLocalObject(Claim fhirObject) {
        return Optional.empty();
    }

    @Override
    public Optional<List<IBilled>> updateLocalObject(Claim fhirObject, List<IBilled> localObject) {
        return Optional.empty();
    }

    @Override
    public Optional<List<IBilled>> createLocalObject(Claim fhirObject) {
        ClaimContext claimContext = new ClaimContext(fhirObject);
        if (claimContext.isValid()) {
            return Optional.of(claimContext.bill());
        }
        LoggerFactory.getLogger(ClaimVerrechnetTransformer.class).warn("Could not create claim for item [" + fhirObject.getItem() + "] diagnosis [" + fhirObject.getDiagnosis() + "] provider [" + fhirObject.getProvider() + "]");
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Claim.class.equals(fhirClazz) && List.class.equals(localClazz);
    }

    private class BillableContext {
        private Result<IBilled> lastStatus;
        private int amount;
        private IBillable billable;

        public BillableContext(IBillable billable, Integer amount) {
            this.billable = billable;
            this.amount = amount;
        }

        public int getAmount() {
            return this.amount;
        }

        public Result<IBilled> getLastStatus() {
            return this.lastStatus;
        }

        public List<IBilled> bill(ch.elexis.core.model.IEncounter behandlung, IMandator user, IMandator mandator) {
            ArrayList<IBilled> ret = new ArrayList<IBilled>();
            int i = 0;
            while (i < this.amount) {
                this.lastStatus = ClaimVerrechnetTransformer.this.billingService.bill(this.billable, behandlung, 1.0);
                if (!this.lastStatus.isOK()) {
                    return ret;
                }
                ret.add((IBilled)this.lastStatus.get());
                ++i;
            }
            return ret;
        }
    }

    private class ClaimContext {
        private Claim claim;
        private List<Claim.InsuranceComponent> coverages;
        private List<Claim.ItemComponent> items;
        private List<Claim.DiagnosisComponent> diagnosis;
        private Reference providerRef;

        public ClaimContext(Claim fhirObject) {
            this.claim = fhirObject;
            this.coverages = fhirObject.getInsurance();
            this.items = fhirObject.getItem();
            this.diagnosis = fhirObject.getDiagnosis();
            this.providerRef = fhirObject.getProvider();
        }

        public boolean isValid() {
            return this.coverages != null && !this.coverages.isEmpty() && this.items != null && !this.items.isEmpty() && this.diagnosis != null && !this.diagnosis.isEmpty() && this.providerRef != null && !this.providerRef.isEmpty();
        }

        public List<IBilled> bill() {
            ArrayList<IBilled> ret = new ArrayList<IBilled>();
            ICoverage coverage = this.getFall(this.coverages.get(0));
            List<IDiagnosis> diagnose = this.getDiagnose(this.diagnosis);
            Optional<ch.elexis.core.model.IEncounter> behandlung = this.getOrCreateBehandlung(this.claim, coverage, this.providerRef);
            if (behandlung.isPresent()) {
                ch.elexis.core.model.IEncounter cons = behandlung.get();
                Optional mandator = ClaimVerrechnetTransformer.this.modelService.load(this.providerRef.getReferenceElement().getIdPart(), IMandator.class);
                if (mandator.isPresent()) {
                    LockResponse lockResponse;
                    if (!cons.getCoverage().getId().equals(coverage.getId()) && (lockResponse = AbstractHelper.acquireLock((Identifiable)cons)).isOk()) {
                        cons.setCoverage(coverage);
                        AbstractHelper.releaseLock(lockResponse.getLockInfo());
                    }
                    for (IDiagnosis diag : diagnose) {
                        cons.addDiagnosis(diag);
                    }
                    List<BillableContext> billables = this.getBillableContexts(this.items, cons);
                    for (BillableContext billable : billables) {
                        List<IBilled> billed = billable.bill(cons, (IMandator)mandator.get(), (IMandator)mandator.get());
                        if (billed.size() < billable.getAmount()) {
                            Result<IBilled> status = billable.getLastStatus();
                            LoggerFactory.getLogger(ClaimVerrechnetTransformer.class).error("Could not bill all items of claim. " + status);
                        }
                        ret.addAll(billed);
                    }
                    ClaimVerrechnetTransformer.this.modelService.save((Identifiable)cons);
                }
            } else {
                LoggerFactory.getLogger(ClaimVerrechnetTransformer.class).error("Could not bill items, Behandlung not found.");
            }
            return ret;
        }

        private List<BillableContext> getBillableContexts(List<Claim.ItemComponent> items, ch.elexis.core.model.IEncounter cons) {
            ArrayList<BillableContext> ret = new ArrayList<BillableContext>();
            block0: for (Claim.ItemComponent itemComponent : items) {
                CodeableConcept serviceCoding = itemComponent.getProductOrService();
                if (serviceCoding == null) continue;
                for (Coding coding : serviceCoding.getCoding()) {
                    Optional<IBillable> billable = this.getBillable(coding.getSystem(), coding.getCode(), cons);
                    Optional<Integer> amount = this.getAmount(itemComponent);
                    if (!billable.isPresent() || !amount.isPresent()) continue;
                    ret.add(new BillableContext(billable.get(), amount.get()));
                    continue block0;
                }
            }
            return ret;
        }

        private Optional<Integer> getAmount(Claim.ItemComponent itemComponent) {
            Quantity quantity = itemComponent.getQuantity();
            if (quantity != null) {
                return Optional.of(quantity.getValue().intValue());
            }
            return Optional.empty();
        }

        private Optional<IBillable> getBillable(String system, String code, ch.elexis.core.model.IEncounter cons) {
            if (system.equals(CodingSystem.ELEXIS_TARMED_CODESYSTEM.getSystem())) {
                HashMap<ICodeElementService.ContextKeys, ch.elexis.core.model.IEncounter> context = new HashMap<ICodeElementService.ContextKeys, ch.elexis.core.model.IEncounter>();
                context.put(ICodeElementService.ContextKeys.CONSULTATION, cons);
                Optional tarmed = ClaimVerrechnetTransformer.this.codeElementService.loadFromString("Tarmed", code, context);
                if (tarmed.isPresent()) {
                    return tarmed.filter(IBillable.class::isInstance).map(IBillable.class::cast);
                }
            }
            LoggerFactory.getLogger(ClaimVerrechnetTransformer.class).warn("Could not find billable for system [" + system + "] code [" + code + "]");
            return Optional.empty();
        }

        private List<IDiagnosis> getDiagnose(List<Claim.DiagnosisComponent> diagnosis) {
            ArrayList<IDiagnosis> ret = new ArrayList<IDiagnosis>();
            for (Claim.DiagnosisComponent diagnosisComponent : diagnosis) {
                CodeableConcept diagnoseCoding;
                if (!diagnosisComponent.hasDiagnosisCodeableConcept() || (diagnoseCoding = (CodeableConcept)diagnosisComponent.getDiagnosis()) == null) continue;
                for (Coding coding : diagnoseCoding.getCoding()) {
                    IDiagnosisReference diag = (IDiagnosisReference)ClaimVerrechnetTransformer.this.modelService.create(IDiagnosisReference.class);
                    diag.setCode(coding.getCode());
                    diag.setText(coding.getDisplay() != null ? coding.getDisplay() : "MISSING");
                    if (CodingSystem.ELEXIS_DIAGNOSE_TESSINERCODE.getSystem().equals(coding.getSystem())) {
                        diag.setReferredClass("ch.elexis.data.TICode");
                    }
                    ret.add((IDiagnosis)diag);
                }
            }
            return ret;
        }

        private ICoverage getFall(Claim.InsuranceComponent insuranceComponent) {
            Reference reference = insuranceComponent.getCoverage();
            if (reference != null && !reference.isEmpty()) {
                Optional fallOpt = ClaimVerrechnetTransformer.this.modelService.load(reference.getReferenceElement().getIdPart(), ICoverage.class);
                return fallOpt.orElse(null);
            }
            return null;
        }

        private Optional<ch.elexis.core.model.IEncounter> getOrCreateBehandlung(Claim fhirObject, ICoverage fall, Reference providerRef) {
            if (fhirObject.getSupportingInfo() != null && !fhirObject.getSupportingInfo().isEmpty()) {
                List information = fhirObject.getSupportingInfo();
                for (Claim.SupportingInformationComponent specialConditionComponent : information) {
                    Optional<ch.elexis.core.model.IEncounter> found;
                    Type value = specialConditionComponent.getValue();
                    if (!(value instanceof StringType) || !((String)((StringType)value).getValue()).startsWith("Encounter/") || !(found = this.getBehandlungWithEncounterRef(new IdType((String)((StringType)value).getValue()))).isPresent()) continue;
                    return found;
                }
            }
            return Optional.empty();
        }

        private Optional<ch.elexis.core.model.IEncounter> getBehandlungWithEncounterRef(IdType encounterRef) {
            Optional encounter;
            if (encounterRef.getIdPart() != null && (encounter = ClaimVerrechnetTransformer.this.findingsService.findById(encounterRef.getIdPart(), IEncounter.class)).isPresent()) {
                return this.getBehandlungForEncounter((IEncounter)encounter.get());
            }
            return Optional.empty();
        }

        private Optional<ch.elexis.core.model.IEncounter> getBehandlungForEncounter(IEncounter encounter) {
            return ClaimVerrechnetTransformer.this.modelService.load(encounter.getConsultationId(), ch.elexis.core.model.IEncounter.class);
        }
    }
}

