/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TaskState implements Enumerator
{
    DRAFT(0, "DRAFT", "DRAFT"),
    QUEUED(5, "QUEUED", "QUEUED"),
    READY(10, "READY", "READY"),
    IN_PROGRESS(20, "IN_PROGRESS", "IN_PROGRESS"),
    CANCELLED(30, "CANCELLED", "CANCELLED"),
    ON_HOLD(40, "ON_HOLD", "ON_HOLD"),
    COMPLETED(50, "COMPLETED", "COMPLETED"),
    COMPLETED_WARN(55, "COMPLETED_WARN", "COMPLETED_WARN"),
    COMPLETED_MANUAL(58, "COMPLETED_MANUAL", "COMPLETED_MANUAL"),
    FAILED(90, "FAILED", "FAILED");

    public static final int DRAFT_VALUE = 0;
    public static final int QUEUED_VALUE = 5;
    public static final int READY_VALUE = 10;
    public static final int IN_PROGRESS_VALUE = 20;
    public static final int CANCELLED_VALUE = 30;
    public static final int ON_HOLD_VALUE = 40;
    public static final int COMPLETED_VALUE = 50;
    public static final int COMPLETED_WARN_VALUE = 55;
    public static final int COMPLETED_MANUAL_VALUE = 58;
    public static final int FAILED_VALUE = 90;
    private static final TaskState[] VALUES_ARRAY;
    public static final List<TaskState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TaskState[]{DRAFT, QUEUED, READY, IN_PROGRESS, CANCELLED, ON_HOLD, COMPLETED, COMPLETED_WARN, COMPLETED_MANUAL, FAILED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TaskState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TaskState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TaskState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TaskState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TaskState get(int value) {
        switch (value) {
            case 0: {
                return DRAFT;
            }
            case 5: {
                return QUEUED;
            }
            case 10: {
                return READY;
            }
            case 20: {
                return IN_PROGRESS;
            }
            case 30: {
                return CANCELLED;
            }
            case 40: {
                return ON_HOLD;
            }
            case 50: {
                return COMPLETED;
            }
            case 55: {
                return COMPLETED_WARN;
            }
            case 58: {
                return COMPLETED_MANUAL;
            }
            case 90: {
                return FAILED;
            }
        }
        return null;
    }

    private TaskState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

