/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.application.listeners;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.ui.UiDesk;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageEventListener
extends ElexisEventListenerImpl {
    private Logger log = LoggerFactory.getLogger((String)MessageEventListener.class.getName());

    public MessageEventListener() {
        super(null, MessageEvent.class, 1024, 1);
    }

    public void run(final ElexisEvent ev) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageEvent me = (MessageEvent)ev.getGenericObject();
                MessageEventListener.this.log.debug("MessageEvent [" + me.mt + "]  [" + me.title + "] [" + me.message + "]");
                switch (me.mt) {
                    case ERROR: {
                        MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)me.title, (String)me.message);
                        break;
                    }
                    case WARN: {
                        MessageDialog.openWarning((Shell)UiDesk.getTopShell(), (String)me.title, (String)me.message);
                        break;
                    }
                    default: {
                        MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)me.title, (String)me.message);
                    }
                }
            }
        });
    }
}

