/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.views.nattable;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.data.Patient;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class DynamicDataProvider
implements IDataProvider {
    private List<IFinding> currentFindings = new ArrayList<IFinding>();
    private List<ICoding> shownCodings;
    private List<LocalDate> shownDates;
    private HashMap<LocalDate, List<IFinding>[]> shownFindings = new HashMap();
    private boolean rowsAreDates;

    public DynamicDataProvider() {
        this.shownDates = new ArrayList<LocalDate>();
        this.shownCodings = new ArrayList<ICoding>();
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        List<IFinding>[] findings;
        if (this.rowsAreDates) {
            List<IFinding>[] findings2;
            if (columnIndex >= 0 && rowIndex >= 0 && rowIndex < this.shownDates.size() && (findings2 = this.shownFindings.get(this.shownDates.get(rowIndex))) != null && columnIndex < findings2.length && findings2[columnIndex] != null) {
                return findings2[columnIndex];
            }
        } else if (columnIndex >= 0 && rowIndex >= 0 && columnIndex < this.shownDates.size() && (findings = this.shownFindings.get(this.shownDates.get(columnIndex))) != null && rowIndex < findings.length && findings[rowIndex] != null) {
            return findings[rowIndex];
        }
        return null;
    }

    public int getRowCount() {
        if (this.rowsAreDates) {
            return this.shownDates.size();
        }
        return this.shownCodings.size();
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
    }

    public int getColumnCount() {
        if (this.rowsAreDates) {
            return this.shownCodings.size();
        }
        return this.shownFindings.size();
    }

    public void reload(Patient selectedPatient) {
        if (selectedPatient == null) {
            this.currentFindings.clear();
        } else {
            this.currentFindings = this.getFindings(selectedPatient);
        }
        this.updateShownFindings();
    }

    public List<IFinding> getFindings(Patient patient) {
        ArrayList<IFinding> ret = new ArrayList<IFinding>();
        if (patient != null && patient.exists()) {
            String patientId = patient.getId();
            ret.addAll(this.getObservations(patientId));
        }
        return ret;
    }

    private List<IObservation> getObservations(String patientId) {
        return FindingsServiceComponent.getService().getPatientsFindings(patientId, IObservation.class);
    }

    public void setShownCodings(List<ICoding> showCodings) {
        this.shownCodings = showCodings;
        this.updateShownFindings();
    }

    private void updateShownFindings() {
        this.shownFindings.clear();
        this.shownDates.clear();
        for (IFinding iFinding : this.currentFindings) {
            IObservation iObservation;
            int index;
            if (!(iFinding instanceof IObservation) || (index = this.getCodingIndex(iObservation = (IObservation)iFinding)) == -1) continue;
            LocalDate date = iObservation.getEffectiveTime().orElse(LocalDateTime.MIN).toLocalDate();
            List<IFinding>[] findings = this.shownFindings.get(date);
            if (findings == null) {
                findings = new List[this.shownCodings.size()];
                this.shownDates.add(date);
            }
            if (findings[index] == null) {
                findings[index] = new ArrayList<IFinding>();
            }
            findings[index].add((IFinding)iObservation);
            this.shownFindings.put(date, findings);
        }
        Collections.sort(this.shownDates);
        Collections.reverse(this.shownDates);
    }

    private int getCodingIndex(IObservation iObservation) {
        for (ICoding iCoding : iObservation.getCoding()) {
            int i = 0;
            while (i < this.shownCodings.size()) {
                if (this.shownCodings.get(i).getCode().equals(iCoding.getCode())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public List<LocalDate> getShownDates() {
        return this.shownDates;
    }

    public List<ICoding> getShownCodings() {
        return this.shownCodings;
    }

    public void setRowsAreDates(boolean value) {
        this.rowsAreDates = value;
    }

    public boolean isRowsAreDates() {
        return this.rowsAreDates;
    }
}

