/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.viewcontributions;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ui.composites.PersonalAnamnesisComposite;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.views.contribution.IViewContribution;
import ch.elexis.data.Patient;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PersonalAnamnesisViewContribution
implements IViewContribution {
    PersonalAnamnesisComposite anamnesisComposite;

    public void setUnlocked(boolean unlocked) {
    }

    public String getLocalizedTitle() {
        return "Pers\u00f6nliche Anamnese";
    }

    public boolean isAvailable() {
        return ConfigServiceHolder.getGlobal((String)"persanamnese/settings/useStructured", (boolean)false);
    }

    public Composite initComposite(Composite parent) {
        this.anamnesisComposite = new PersonalAnamnesisComposite(parent, 0);
        return this.anamnesisComposite;
    }

    public void setDetailObject(Object detailObject, Object additionalData) {
        List observations = null;
        if (this.anamnesisComposite != null) {
            if (FindingsServiceComponent.getService() != null && detailObject instanceof Patient) {
                observations = FindingsServiceComponent.getService().getPatientsFindings(((Patient)detailObject).getId(), IObservation.class);
                observations = observations.stream().filter(finding -> this.isPersonalAnamnesis((IFinding)finding)).collect(Collectors.toList());
            }
            if (observations != null && observations.size() >= 1) {
                if (observations.size() > 1) {
                    MessageDialog.openWarning((Shell)this.anamnesisComposite.getShell(), (String)"Pers\u00f6nliche Anamnese", (String)"Mehr als eine pers\u00f6nliche Anamnese gefunden.\n Nur die letzte pers\u00f6nliche Anamnese wird angezeigt.");
                }
                this.anamnesisComposite.setInput(Optional.of((IObservation)observations.get(0)));
            } else {
                this.anamnesisComposite.setInput(Optional.empty());
            }
        }
    }

    private boolean isPersonalAnamnesis(IFinding iFinding) {
        if (iFinding instanceof IObservation && ((IObservation)iFinding).getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
            for (ICoding code : ((IObservation)iFinding).getCoding()) {
                if (!IObservation.ObservationCode.ANAM_PERSONAL.isSame(code)) continue;
                return true;
            }
        }
        return false;
    }
}

