/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.converter;

import ch.elexis.core.model.InvoiceState;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public class InvoiceStateConverter
implements AttributeConverter<InvoiceState, String> {
    private Logger log = LoggerFactory.getLogger(InvoiceStateConverter.class);

    public String convertToDatabaseColumn(InvoiceState attribute) {
        if (attribute == null) {
            return Integer.toString(InvoiceState.UNKNOWN.numericValue());
        }
        return Integer.toString(attribute.getState());
    }

    public InvoiceState convertToEntityAttribute(String dbData) {
        if (StringUtils.isEmpty((CharSequence)dbData)) {
            return InvoiceState.UNKNOWN;
        }
        try {
            int value = Integer.parseInt(dbData.trim());
            return InvoiceState.fromState((int)value);
        }
        catch (NumberFormatException ex) {
            this.log.warn("Number format exception " + dbData, (Throwable)ex);
            return InvoiceState.UNKNOWN;
        }
    }
}

