/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.views.Messages;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class PatListeContentProvider
extends CommonViewerContentProvider
implements ILazyContentProvider {
    private static final int QUERY_LIMIT = 500;
    Object[] pats;
    boolean bValid = false;
    boolean bUpdating = false;
    String[] orderLabels;
    String[] orderFields;
    String firstOrder;
    ViewPart site;

    public PatListeContentProvider(CommonViewer cv, String[] fieldsToOrder, ViewPart s) {
        super(cv);
        this.site = s;
        this.updateFields(fieldsToOrder);
    }

    public void updateFields(String[] fieldsToOrder) {
        this.orderLabels = new String[fieldsToOrder.length];
        this.orderFields = new String[fieldsToOrder.length];
        int i = 0;
        while (i < fieldsToOrder.length) {
            String[] def = fieldsToOrder[i].split("=");
            this.orderFields[i] = def[0];
            this.orderLabels[i] = def.length > 1 ? def[1] : def[0];
            ++i;
        }
        this.firstOrder = this.orderFields[0];
    }

    protected IQuery<?> getBaseQuery() {
        IQuery ret = CoreModelServiceHolder.get().getQuery(IPatient.class);
        if (!this.ignoreLimit) {
            ret.limit(500);
        }
        return ret;
    }

    public void syncRefresh() {
        String[] actualOrder;
        IQuery<?> patientQuery = this.getBaseQuery();
        patientQuery.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)true);
        this.commonViewer.getConfigurer().getControlFieldProvider().setQuery(patientQuery);
        this.getQueryFilters().forEach(filter -> filter.apply(patientQuery));
        int idx = StringTool.getIndex((String[])this.orderFields, (String)this.firstOrder);
        if (idx == -1 || idx == 0) {
            actualOrder = this.orderFields;
        } else {
            actualOrder = new String[this.orderFields.length];
            int n = 0;
            int begin = idx;
            do {
                actualOrder[n++] = this.orderFields[idx++];
                if (idx < this.orderFields.length) continue;
                idx = 0;
            } while (idx != begin);
        }
        if (actualOrder != null && actualOrder.length > 0) {
            String[] stringArray = actualOrder;
            int n = actualOrder.length;
            int n2 = 0;
            while (n2 < n) {
                String order = stringArray[n2];
                patientQuery.orderBy(order, IQuery.ORDER.ASC);
                ++n2;
            }
        }
        List lPats = patientQuery.execute();
        if (!this.ignoreLimit) {
            this.commonViewer.setLimitReached(lPats.size() == 500, 500);
        }
        this.pats = lPats.toArray(new Object[lPats.size()]);
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TableViewer tv = (TableViewer)PatListeContentProvider.this.commonViewer.getViewerWidget();
                if (tv != null && tv.getControl() != null && !tv.getControl().isDisposed()) {
                    tv.setItemCount(PatListeContentProvider.this.pats.length);
                    PatListeContentProvider.this.bValid = true;
                    tv.refresh();
                }
                PatListeContentProvider.this.bUpdating = false;
            }
        });
    }

    public Object[] getElements(Object inputElement) {
        if (this.bValid || this.bUpdating) {
            return this.pats;
        }
        if (!CoreHub.acl.request(AccessControlDefaults.PATIENT_DISPLAY)) {
            return new Object[0];
        }
        Job job = new Job(Messages.PatListeContentProvider_LoadingPatients){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.PatListeContentProvider_LoadPatients, -1);
                PatListeContentProvider.this.syncRefresh();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setUser(false);
        this.bUpdating = true;
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.site.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)Images.IMG_AUSRUFEZ_ROT.getImage());
        return this.pats;
    }

    public void changed(HashMap<String, String> values) {
        super.setIgnoreLimit(false);
        this.bValid = false;
        this.getElements(null);
    }

    protected void setIgnoreLimit(boolean value) {
        super.setIgnoreLimit(value);
        if (value) {
            this.bValid = false;
            this.getElements(null);
        }
    }

    public void dispose() {
        this.stopListening();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void reorder(String field) {
        int idx = StringTool.getIndex((String[])this.orderFields, (String)field);
        if (idx > -1) {
            this.firstOrder = this.orderFields[idx];
            this.changed(null);
        }
    }

    public void selected() {
    }

    public void updateElement(int index) {
        if (!this.bValid) {
            this.getElements(this.commonViewer);
        }
        TableViewer tv = (TableViewer)this.commonViewer.getViewerWidget();
        if (this.pats.length > index) {
            tv.replace(this.pats[index], index);
        } else {
            Object elementAt = tv.getElementAt(index);
            if (elementAt != null) {
                tv.replace((Object)"-", index);
            }
        }
    }

    public void invalidate() {
        this.bValid = false;
    }

    void temporaryAddObject(Object newObject) {
        ArrayList<Object> temp = null;
        temp = this.pats != null ? new ArrayList<Object>(Arrays.asList(this.pats)) : new ArrayList<Object>();
        temp.add(newObject);
        this.pats = temp.toArray();
        ((TableViewer)this.commonViewer.getViewerWidget()).setItemCount(this.pats.length);
    }

    public void init() {
    }
}

