/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Messages;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillingSystem {
    private static Logger log = LoggerFactory.getLogger(BillingSystem.class);
    public static final String CFG_BILLINGLAW = "defaultBillingLaw";
    public static final String CFG_NOCOSTBEARER = "noCostBearer";
    public static final String KVG_NAME = Messages.Fall_KVG_Name;
    public static final String UVG_NAME = Messages.Fall_UVG_Name;
    public static final String MV_NAME = Messages.Fall_MV_Name;
    public static final String IV_NAME = Messages.Fall_IV_Name;
    private static final String KVG_REQUIREMENTS = Messages.Fall_KVGRequirements;
    public static final String UVG_REQUIREMENTS = Messages.Fall_UVGRequirements;
    public static final String CONST_TARMED_DRUCKER = Messages.Fall_TarmedPrinter;
    public static final String CONST_TARMED_LEISTUNG = Messages.Fall_TarmedLeistung;
    public static final String VVG_NAME = Messages.Fall_VVG_Name;
    public static final String PRIVATE_NAME = Messages.Fall_Private_Name;

    public static String getConfigurationValue(String billingSystemName, String attributeName, String defaultIfNotDefined) {
        String ret = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystemName + "/" + attributeName), (String)defaultIfNotDefined);
        return ret;
    }

    public static void setConfigurationValue(String billingSystemName, String attributeName, String attributeValue) {
        String key = "billing/systems/" + billingSystemName;
        ConfigServiceHolder.setGlobal((String)(String.valueOf(key) + "/" + attributeName), (String)attributeValue);
    }

    public static boolean isDisabled(String billingSystemName) {
        String ret = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystemName + "/disabled"), (String)"0");
        return !ret.equalsIgnoreCase("0");
    }

    public static String getUnused(String billingSystem) {
        String ret = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystem + "/unused"), null);
        return ret;
    }

    public static String getOptionals(String billingSystem) {
        String ret = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystem + "/fakultativ"), null);
        return ret;
    }

    public static String getRequirements(String billingSystem) {
        String ret = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystem + "/bedingungen"), null);
        return ret;
    }

    public static String[] getBillingSystemConstants(String billingSystem) {
        String bc = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystem + "/constants"), null);
        if (bc == null) {
            return new String[0];
        }
        return bc.split("#");
    }

    public static String getBillingSystemConstant(String billingSystem, String constant) {
        String[] c;
        String[] stringArray = c = BillingSystem.getBillingSystemConstants(billingSystem);
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            String bc = stringArray[n2];
            String[] val = bc.split("=");
            if (val[0].equalsIgnoreCase(constant)) {
                return val[1];
            }
            ++n2;
        }
        return "";
    }

    public static void addBillingSystemConstant(String billingSystem, String constant) {
        if (constant.indexOf(61) != -1) {
            String bc = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystem + "/constants"), null);
            bc = bc != null ? String.valueOf(bc) + "#" + constant : constant;
            ConfigServiceHolder.setGlobal((String)("billing/systems/" + billingSystem + "/constants"), (String)bc);
        }
    }

    public static void removeBillingSystemConstant(String billingSystem, String constant) {
        String key = "billing/systems/" + billingSystem + "/constants";
        String bc = ConfigServiceHolder.getGlobal((String)key, null);
        if (bc != null) {
            bc = bc.replaceAll(constant, "");
            bc = bc.replaceAll("##", "#");
            bc = bc.replaceFirst("#$", "");
            bc = bc.replaceFirst("^#", "");
            ConfigServiceHolder.setGlobal((String)("billing/systems/" + billingSystem + "/constants"), (String)bc);
        } else {
            log.error("[" + key + "] is null");
        }
    }

    public static boolean isCostBearerDisabled(String billingSystemName) {
        return Boolean.valueOf(BillingSystem.getConfigurationValue(billingSystemName, CFG_NOCOSTBEARER, Boolean.FALSE.toString()));
    }

    public static String[] getAbrechnungsSysteme() {
        List ret = ConfigServiceHolder.getSubNodes((String)"billing/systems");
        if (ret == null || ret.isEmpty()) {
            List<IConfigurationElement> list = Extensions.getExtensions("ch.elexis.core.data.RechnungsManager");
            for (IConfigurationElement ic : list) {
                if (!ic.getAttribute("name").startsWith("Tarmed")) continue;
                ConfigServiceHolder.setGlobal((String)"billing/systems/KVG/name", (String)KVG_NAME);
                ConfigServiceHolder.setGlobal((String)"billing/systems/KVG/leistungscodes", (String)CONST_TARMED_LEISTUNG);
                ConfigServiceHolder.setGlobal((String)"billing/systems/KVG/standardausgabe", (String)CONST_TARMED_DRUCKER);
                ConfigServiceHolder.setGlobal((String)"billing/systems/KVG/bedingungen", (String)KVG_REQUIREMENTS);
                BillingSystem.setConfigurationValue("KVG", CFG_BILLINGLAW, BillingLaw.KVG.name());
                ConfigServiceHolder.setGlobal((String)"billing/systems/UVG/name", (String)UVG_NAME);
                ConfigServiceHolder.setGlobal((String)"billing/systems/UVG/leistungscodes", (String)CONST_TARMED_LEISTUNG);
                ConfigServiceHolder.setGlobal((String)"billing/systems/UVG/standardausgabe", (String)CONST_TARMED_DRUCKER);
                ConfigServiceHolder.setGlobal((String)"billing/systems/UVG/bedingungen", (String)UVG_REQUIREMENTS);
                BillingSystem.setConfigurationValue("UVG", CFG_BILLINGLAW, BillingLaw.UVG.name());
                ConfigServiceHolder.setGlobal((String)"billing/systems/IV/name", (String)IV_NAME);
                ConfigServiceHolder.setGlobal((String)"billing/systems/IV/leistungscodes", (String)CONST_TARMED_LEISTUNG);
                ConfigServiceHolder.setGlobal((String)"billing/systems/IV/standardausgabe", (String)CONST_TARMED_DRUCKER);
                ConfigServiceHolder.setGlobal((String)"billing/systems/IV/bedingungen", (String)"Fallnummer:T");
                BillingSystem.setConfigurationValue("IV", CFG_BILLINGLAW, BillingLaw.IV.name());
                ConfigServiceHolder.setGlobal((String)"billing/systems/MV/name", (String)MV_NAME);
                ConfigServiceHolder.setGlobal((String)"billing/systems/MV/leistungscodes", (String)CONST_TARMED_LEISTUNG);
                ConfigServiceHolder.setGlobal((String)"billing/systems/MV/standardausgabe", (String)CONST_TARMED_DRUCKER);
                BillingSystem.setConfigurationValue("MV", CFG_BILLINGLAW, BillingLaw.MV.name());
                ConfigServiceHolder.setGlobal((String)"billing/systems/privat/name", (String)PRIVATE_NAME);
                ConfigServiceHolder.setGlobal((String)"billing/systems/privat/leistungscodes", (String)CONST_TARMED_LEISTUNG);
                ConfigServiceHolder.setGlobal((String)"billing/systems/privat/standardausgabe", (String)CONST_TARMED_DRUCKER);
                BillingSystem.setConfigurationValue("privat", CFG_BILLINGLAW, BillingLaw.VVG.name());
                BillingSystem.setConfigurationValue("privat", CFG_NOCOSTBEARER, "1");
                ConfigServiceHolder.setGlobal((String)"billing/systems/VVG/name", (String)VVG_NAME);
                ConfigServiceHolder.setGlobal((String)"billing/systems/VVG/leistungscodes", (String)CONST_TARMED_LEISTUNG);
                ConfigServiceHolder.setGlobal((String)"billing/systems/VVG/standardausgabe", (String)CONST_TARMED_DRUCKER);
                ConfigServiceHolder.setGlobal((String)"billing/systems/VVG/bedingungen", (String)KVG_REQUIREMENTS);
                BillingSystem.setConfigurationValue("VVG", CFG_BILLINGLAW, BillingLaw.VVG.name());
                PersistentObject.getConnection().exec("UPDATE VK_PREISE set typ='UVG' WHERE typ='ch.elexis.data.TarmedLeistungUVG'");
                PersistentObject.getConnection().exec("UPDATE VK_PREISE set typ='KVG' WHERE typ='ch.elexis.data.TarmedLeistungKVG'");
                PersistentObject.getConnection().exec("UPDATE VK_PREISE set typ='IV' WHERE typ='ch.elexis.data.TarmedLeistungIV'");
                PersistentObject.getConnection().exec("UPDATE VK_PREISE set typ='MV' WHERE typ='ch.elexis.data.TarmedLeistungMV'");
                BillingSystem.update();
                break;
            }
            ret = ConfigServiceHolder.getSubNodes((String)"billing/systems");
            if (ret.isEmpty()) {
                return new String[]{Messages.Fall_Undefined};
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static void update() {
        Query qbe = new Query(Fall.class);
        for (Fall fall : qbe.execute()) {
            if (fall.getInfoString("Kostentr\u00e4ger").equals("")) {
                fall.setInfoString("Kostentr\u00e4ger", PersistentObject.checkNull(fall.get("Kostentraeger")));
            }
            if (fall.getInfoString("Rechnungsempf\u00e4nger").equals("")) {
                fall.setInfoString("Rechnungsempf\u00e4nger", PersistentObject.checkNull(fall.get("GarantID")));
            }
            if (fall.getInfoString("Versicherungsnummer").equals("")) {
                fall.setInfoString("Versicherungsnummer", PersistentObject.checkNull(fall.get("VersNummer")));
            }
            if (fall.getInfoString("Fallnummer").equals("")) {
                fall.setInfoString("Fallnummer", PersistentObject.checkNull(fall.get("FallNummer")));
            }
            if (!fall.getInfoString("Unfallnummer").equals("")) continue;
            fall.setInfoString("Unfallnummer", PersistentObject.checkNull(fall.get("FallNummer")));
        }
    }

    public static void createAbrechnungssystem(String systemname, String codesystem, String ausgabe, String ... requirements) {
        String key = "billing/systems/" + systemname;
        ConfigServiceHolder.setGlobal((String)(String.valueOf(key) + "/name"), (String)systemname);
        ConfigServiceHolder.setGlobal((String)(String.valueOf(key) + "/leistungscodes"), (String)codesystem);
        ConfigServiceHolder.setGlobal((String)(String.valueOf(key) + "/standardausgabe"), (String)ausgabe);
        ConfigServiceHolder.setGlobal((String)(String.valueOf(key) + "/bedingungen"), (String)StringTool.join((String[])requirements, (String)";"));
    }

    public static void removeAbrechnungssystem(String systemName) {
        CoreHub.globalCfg.remove("billing/systems/" + systemName);
        CoreHub.globalCfg.flush();
    }

    public static String getCodeSystem(String billingSystem) {
        String ret = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystem + "/leistungscodes"), null);
        if (ret == null) {
            BillingSystem.getAbrechnungsSysteme();
            ret = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystem + "/leistungscodes"), (String)"?");
        }
        return ret;
    }

    public static String getDefaultPrintSystem(String billingSystem) {
        String ret = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystem + "/standardausgabe"), null);
        if (ret == null) {
            BillingSystem.getAbrechnungsSysteme();
            ret = ConfigServiceHolder.getGlobal((String)("billing/systems/" + billingSystem + "/standardausgabe"), (String)"?");
        }
        return ret;
    }

    public static String getRequirementsBySystem(String abrechnungsSystem) {
        String req = BillingSystem.getRequirements(abrechnungsSystem);
        return req == null ? "" : req;
    }

    public static void moveCostBearerFromExtinfoToDBRow(String billingSystem, String fieldName) {
        Query qre = new Query(Fall.class, "Gesetz", billingSystem);
        qre.clear(true);
        List qbe = qre.execute();
        for (Fall fall : qbe) {
            String contactId = (String)fall.getExtInfoStoredObjectByKey(fieldName);
            if (contactId == null) continue;
            log.info("Moving Fall [{}] ExtInfo key [{}] value [{}] to db table", new Object[]{fall.getId(), fieldName, contactId});
            Kontakt costBearer = Kontakt.load(contactId);
            if (costBearer.isAvailable()) {
                fall.setCostBearer(costBearer);
                fall.setExtInfoStoredObjectByKey(fieldName, null);
                continue;
            }
            log.warn("Fall [{}] could not load cost bearer [{}], skipping", (Object)fall.getId(), (Object)contactId);
        }
    }

    public static void removeExtInfoValueForAllFaelleOfBillingSystem(String billingSystem, List<String> fieldNames) {
        Query qre = new Query(Fall.class, "Gesetz", billingSystem);
        qre.clear(true);
        List qbe = qre.execute();
        for (Fall fall : qbe) {
            log.info("Removing Fall [{}] ExtInfo keys [{}]", (Object)fall.getId(), fieldNames);
            for (String fieldName : fieldNames) {
                fall.setExtInfoStoredObjectByKey(fieldName, null);
            }
        }
    }
}

