/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.VersionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUpdate {
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final String ADD = " ADD ";
    private static final String FILE_LOCATED = "FILE";
    static final String[] versions = new String[]{"1.3.0", "1.3.1", "1.3.2", "1.3.3", "1.3.4", "1.3.5", "1.3.6", "1.3.7", "1.3.8", "1.3.9", "1.3.10", "1.3.11", "1.3.12", "1.3.13", "1.4.0", "1.4.1", "1.4.2", "1.4.3", "1.4.4", "1.4.5", "1.4.6", "1.5.0", "1.6.0", "1.6.1", "1.6.2", "1.6.3", "1.6.4", "1.7.0", "1.7.1", "1.7.2", "1.8.0", "1.8.1", "1.8.2", "1.8.3", "1.8.4", "1.8.5", "1.8.6", "1.8.7", "1.8.8", "1.8.9", "1.8.10", "1.8.11", "1.8.12", "1.8.13", "1.8.14", "1.8.15", "1.8.16", "1.9.0", "3.0.0", "3.1.0", "3.2.0", "3.2.1", "3.2.2", "3.2.3", "3.2.4", "3.2.5", "3.2.6", "3.2.7", "3.4.0", "3.4.1", "3.4.2", "3.4.3", "3.5.0", "3.6.0", "3.6.1", "3.7.0"};
    static final String[] cmds = new String[]{"CREATE TABLE EIGENLEISTUNGEN(ID\t\t\tVARCHAR(25) primary key,Code\t\tVARCHAR(20),Bezeichnung VARCHAR(80),EK_PREIS\tCHAR(6),VK_PREIS\tCHAR(6),ZEIT\t\tCHAR(4)\t);", "ALTER TABLE PATIENT_ARTIKEL_JOINT DROP COLUMN PATIENTID;ALTER TABLE PATIENT_ARTIKEL_JOINT add ID VARCHAR(25);ALTER TABLE PATIENT_ARTIKEL_JOINT add PATIENTID VARCHAR(25);CREATE INDEX PAJ1 ON PATIENT_ARTIKEL_JOINT (PATIENTID);", "CREATE TABLE HEAP2(ID\t\t\tVARCHAR(50) primary key,Contents   BLOB);", "ALTER TABLE FAELLE ADD EXTINFO BLOB;ALTER TABLE LEISTUNGEN ADD SCALE CHAR(4) DEFAULT '100';ALTER TABLE LEISTUNGEN ADD DETAIL BLOB;", "ALTER TABLE LEISTUNGEN ADD VK_TP CHAR(6);ALTER TABLE LEISTUNGEN ADD VK_SCALE CHAR(6);ALTER TABLE KONTAKT ADD TITEL VARCHAR(20);", "ALTER TABLE FAELLE ADD Status VARCHAR(80);ALTER TABLE REZEPTE ADD RpZusatz VARCHAR(80);ALTER TABLE AUF ADD AUFZusatz VARCHAR(80)", "ALTER TABLE REZEPTE ADD BriefID VARCHAR(25);ALTER TABLE AUF ADD BriefID VARCHAR(25);", "ALTER TABLE ARTIKEL ADD Name_intern VARCHAR(80);", "ALTER TABLE PATIENT_ARTIKEL_JOINT ADD REZEPTID VARCHAR(25);ALTER TABLE PATIENT_ARTIKEL_JOINT ADD DATEFROM CHAR(8);ALTER TABLE PATIENT_ARTIKEL_JOINT ADD DATEUNTIL CHAR(8);ALTER TABLE PATIENT_ARTIKEL_JOINT ADD ANZAHL CHAR(3);CREATE INDEX PAJ2 ON PATIENT_ARTIKEL_JOINT(REZEPTID);", "ALTER TABLE REMINDERS ADD RESPONSIBLE VARCHAR(25);CREATE INDEX rem3 ON REMINDERS (RESPONSIBLE);ALTER TABLE TARMED ADD NICKNAME VARCHAR(25);", "ALTER TABLE RECHNUNGEN ADD STATUSDATUM CHAR(8);CREATE TABLE USERCONFIG(UserID\t\tVARCHAR(25) primary key,Param\t\tVARCHAR(80),Value\t\tBLOB);CREATE INDEX UCFG ON USERCONFIG(Param);", "ALTER TABLE USERCONFIG DROP Value;ALTER TABLE USERCONFIG ADD VALUE TEXT;", "DROP TABLE USERCONFIG;CREATE TABLE USERCONFIG(UserID\t\tVARCHAR(25),Param\t\tVARCHAR(80),Value\t\tTEXT);CREATE INDEX UCFG ON USERCONFIG(Param);CREATE INDEX UCFG2 ON USERCONFIG(UserID)", "S1", "ALTER TABLE BRIEFE DROP format;ALTER TABLE BRIEFE ADD MimeType VARCHAR(80);ALTER TABLE BRIEFE ADD Path TEXT;", "ALTER TABLE KONTO ADD RechnungsID VARCHAR(25);ALTER TABLE KONTO ADD ZahlungsID  VARCHAR(25);ALTER TABLE TARMED ADD GueltigVon CHAR(8);ALTER TABLE TARMED ADD GueltigBis CHAR(8);", "ALTER TABLE LABORWERTE ADD Flags VARCHAR(10);", "CREATE TABLE LABGROUPS( ID VARCHAR(25) primary key, name VARCHAR(30));CREATE TABLE LABGROUP_ITEM_JOINT(GroupID VARCHAR(25),ItemID VARCHAR(25), Comment TEXT );", "ALTER TABLE REMINDERS ADD OriginID VARCHAR(25);CREATE TABLE REMINDERS_RESPONSIBLE_LINK(ID\t\t\t\tVARCHAR(25) primary key,ReminderID\t\tVARCHAR(25),ResponsibleID\tVARCHAR(25));CREATE INDEX rrl1 on REMINDERS_RESPONSIBLE_LINK (ReminderID);CREATE INDEX rrl2 on REMINDERS_RESPONSIBLE_LINK (ResponsibleID);ALTER TABLE PATIENT_ARTIKEL_JOINT ADD ExtInfo BLOB;", "ALTER TABLE ARTIKEL ADD Klasse VARCHAR(80);", "ALTER TABLE LABORITEMS MODIFY titel VARCHAR(80);ALTER TABLE LABORITEMS MODIFY kuerzel VARCHAR(80);", "ALTER TABLE HEAP MODIFY ID VARCHAR(80);", "ALTER TABLE HEAP ADD datum CHAR(8);ALTER TABLE KONTAKT ADD deleted CHAR(1) default '0';ALTER TABLE KONTAKT_ADRESS_JOINT ADD deleted CHAR(1) default '0';ALTER TABLE FAELLE ADD deleted CHAR(1) default '0';ALTER TABLE BEHANDLUNGEN ADD deleted CHAR(1) default '0';ALTER TABLE LABORWERTE ADD deleted CHAR(1) default '0';ALTER TABLE ARTIKEL ADD deleted CHAR(1) default '0';ALTER TABLE PATIENT_ARTIKEL_JOINT ADD deleted CHAR(1) default '0';ALTER TABLE KONTO ADD deleted CHAR(1) default '0';ALTER TABLE LEISTUNGEN ADD deleted CHAR(1) default '0';ALTER TABLE LEISTUNGSBLOCK ADD deleted CHAR(1) default '0';ALTER TABLE DIAGNOSEN ADD deleted CHAR(1) default '0';ALTER TABLE BEHDL_DG_JOINT ADD deleted CHAR(1) default '0';ALTER TABLE BRIEFE ADD deleted CHAR(1) default '0';ALTER TABLE RECHNUNGEN ADD deleted CHAR(1) default '0';ALTER TABLE ZAHLUNGEN ADD deleted CHAR(1) default '0';ALTER TABLE REMINDERS ADD deleted CHAR(1) default '0';ALTER TABLE REMINDERS_RESPONSIBLE_LINK ADD deleted CHAR(1) default '0';ALTER TABLE BBS ADD deleted CHAR(1) default '0';ALTER TABLE LABORITEMS ADD deleted CHAR(1) default '0';ALTER TABLE LABGROUPS ADD deleted CHAR(1) default '0';ALTER TABLE REZEPTE ADD deleted CHAR(1) default '0';ALTER TABLE HEAP ADD deleted CHAR(1) default '0';ALTER TABLE AUF ADD deleted CHAR(1) default '0';ALTER TABLE EIGENLEISTUNGEN ADD deleted CHAR(1) default '0';ALTER TABLE HEAP2 ADD deleted CHAR(1) default '0';ALTER TABLE HEAP2 MODIFY ID VARCHAR(80);ALTER TABLE HEAP2 ADD datum CHAR(8);ALTER TABLE TARMED ADD deleted CHAR(1) default '0';ALTER TABLE LABORWERTE ADD Origin VARCHAR(30);INSERT INTO TARMED (ID,Nickname) VALUES ('Version','1.0.1');CREATE TABLE LOGS(ID\t\t\tVARCHAR(25) primary key,OID\t\tVARCHAR(80),datum\t\tCHAR(8),typ\t\tVARCHAR(20),userID\t\tVARCHAR(25),station\tVARCHAR(40),ExtInfo\t\tBLOB);", "CREATE TABLE XID(ID\t\t\tVARCHAR(25) primary key,deleted\tCHAR(1) default '0',type\t\tVARCHAR(80),object\t\tVARCHAR(25),domain\t\tVARCHAR(255),domain_id\tVARCHAR(255),quality\tCHAR(1) default '0');CREATE INDEX XIDIDX1 on XID(domain);CREATE INDEX XIDIDX2 on XID(domain_id);CREATE INDEX XIDIDX3 on XID(object);", "ALTER TABLE AUF ADD DatumAUZ CHAR(8);ALTER TABLE ARTIKEL ADD LastUpdate CHAR(8);", "ALTER TABLE ARTIKEL ADD EAN VARCHAR(15);", "ALTER TABLE HEAP ADD lastupdate CHAR(14);ALTER TABLE HEAP2 ADD lastupdate CHAR(14)", "CREATE TABLE ETIKETTEN(ID          VARCHAR(25) primary key,Image       VARCHAR(25),deleted     CHAR(1) default '0',importance\t integer,Name        VARCHAR(40),foreground  CHAR(6),background  CHAR(6));CREATE INDEX ETIKETTE1 on ETIKETTEN(Name);CREATE TABLE ETIKETTEN_OBJECT_LINK(\tobj\t\t\tVARCHAR(25),\tetikette\tVARCHAR(25));CREATE INDEX ETIKETTE2 on ETIKETTEN_OBJECT_LINK(obj);CREATE INDEX ETIKETTE3 on ETIKETTEN_OBJECT_LINK(etikette);CREATE TABLE DBIMAGE (ID\t\t\t\tVARCHAR(25) primary key,deleted\t\tCHAR(1) default '0',Datum\t\t\tCHAR(8),Title \t\t\tVARCHAR(80),Bild\t\t\tBLOB);CREATE INDEX DBIMAGE1 on DBIMAGE(Title);", "ALTER TABLE LABORITEMS MODIFY Einheit VARCHAR(20);ALTER TABLE ETIKETTEN MODIFY importance VARCHAR(7);", "ALTER TABLE LEISTUNGEN ADD SCALE2 CHAR(4);ALTER TABLE ETIKETTEN ADD classes VARCHAR(255);ALTER TABLE LABORWERTE ADD zeit CHAR(6);", "DROP TABLE PATIENT_GARANT_JOINT;DROP TABLE PLZ;ALTER TABLE KONTAKT ADD lastupdate BIGINT;ALTER TABLE KONTAKT_ADRESS_JOINT ADD lastupdate BIGINT;ALTER TABLE FAELLE ADD lastupdate BIGINT;ALTER TABLE BEHANDLUNGEN ADD lastupdate BIGINT;ALTER TABLE ARTIKEL DROP lastupdate;ALTER TABLE ARTIKEL ADD lastupdate BIGINT;ALTER TABLE PATIENT_ARTIKEL_JOINT ADD lastupdate BIGINT;ALTER TABLE KONTO ADD lastupdate BIGINT;ALTER TABLE LEISTUNGEN ADD lastupdate BIGINT;ALTER TABLE LEISTUNGSBLOCK ADD lastupdate BIGINT;ALTER TABLE EK_PREISE ADD lastupdate BIGINT;ALTER TABLE VK_PREISE ADD lastupdate BIGINT;ALTER TABLE DIAGNOSEN ADD lastupdate BIGINT;ALTER TABLE BEHDL_DG_JOINT ADD lastupdate BIGINT;ALTER TABLE CONFIG ADD lastupdate BIGINT;ALTER TABLE BRIEFE ADD lastupdate BIGINT;ALTER TABLE RECHNUNGEN ADD lastupdate BIGINT;ALTER TABLE ZAHLUNGEN ADD lastupdate BIGINT;ALTER TABLE REMINDERS ADD lastupdate BIGINT;ALTER TABLE REMINDERS_RESPONSIBLE_LINK ADD lastupdate BIGINT;ALTER TABLE BBS ADD lastupdate BIGINT;ALTER TABLE LABORITEMS ADD lastupdate BIGINT;ALTER TABLE LABORWERTE ADD lastupdate BIGINT;ALTER TABLE LABGROUPS ADD lastupdate BIGINT;ALTER TABLE LABGROUP_ITEM_JOINT ADD lastupdate BIGINT;ALTER TABLE REZEPTE ADD lastupdate BIGINT;ALTER TABLE HEAP DROP lastupdate;ALTER TABLE HEAP ADD lastupdate BIGINT;ALTER TABLE HEAP2 DROP lastupdate;ALTER TABLE HEAP2 ADD lastupdate BIGINT;ALTER TABLE AUF ADD lastupdate BIGINT;ALTER TABLE EIGENLEISTUNGEN ADD lastupdate BIGINT;ALTER TABLE LOGS ADD lastupdate BIGINT;ALTER TABLE USERCONFIG ADD lastupdate BIGINT;ALTER TABLE XID ADD lastupdate BIGINT;ALTER TABLE ETIKETTEN ADD lastupdate BIGINT;ALTER TABLE ETIKETTEN_OBJECT_LINK ADD lastupdate BIGINT;ALTER TABLE DBIMAGE ADD lastupdate BIGINT;CREATE TABLE ARTIKEL_DETAILS(ARTICLE_ID      VARCHAR(25),notes           TEXT,image           BLOB);", "ALTER TABLE AUF MODIFY Grund VARCHAR(50);ALTER TABLE LABORITEMS ADD billingcode VARCHAR(20);", "ALTER TABLE PATIENT_ARTIKEL_JOINT ADD Artikel VARCHAR(80);", "ALTER TABLE LOGS ADD deleted CHAR(1) default '0';", "ALTER TABLE KONTAKT MODIFY EMail VARCHAR(80);", "ALTER TABLE ARTIKEL ADD ValidFrom CHAR(8);ALTER TABLE ARTIKEL ADD ValidTo   CHAR(8);CREATE TABLE OUTPUT_LOG(ID\t\t\t\tVARCHAR(25) primary key,lastupdate\t\tBIGINT,deleted        CHAR(1) default '0',ObjectID\t\tVARCHAR(25),ObjectType\t\tVARCHAR(80),Datum\t\t\tCHAR(8),Outputter\t\tVARCHAR(80),ExtInfo\t\tBLOB);create INDEX bal_i1 ON OUTPUT_LOG (ObjectID);ALTER TABLE DBIMAGE ADD Prefix VARCHAR(80);", "CREATE TABLE ETIKETTEN_OBJCLASS_LINK(objclass VARCHAR(80),sticker VARCHAR(25));CREATE INDEX eol1 on ETIKETTEN_OBJCLASS_LINK(objclass);", "ALTER TABLE LOGS MODIFY station VARCHAR(40);", "ALTER TABLE KONTAKT_ADRESS_JOINT MODIFY Bezug VARCHAR(80);", "ALTER TABLE LABORITEMS ADD EXPORT VARCHAR(100);", "DELETE FROM LABORITEMS where length(RefFrauOrTx) > 256;ALTER TABLE LABORITEMS MODIFY RefFrauOrTx VARCHAR(256);ALTER TABLE LABORITEMS MODIFY RefMann     VARCHAR(256);", "ALTER TABLE KONTAKT MODIFY Bezeichnung1 VARCHAR(255);ALTER TABLE KONTAKT MODIFY Bezeichnung2 VARCHAR(255);ALTER TABLE KONTAKT MODIFY Bezeichnung3 VARCHAR(255);ALTER TABLE KONTAKT MODIFY Strasse VARCHAR(255);ALTER TABLE KONTAKT MODIFY Ort VARCHAR(255);ALTER TABLE KONTAKT MODIFY Email VARCHAR(255);ALTER TABLE KONTAKT MODIFY Website VARCHAR(255);ALTER TABLE KONTAKT MODIFY Titel VARCHAR(255);ALTER TABLE KONTAKT ADD TitelSuffix VARCHAR(255);ALTER TABLE PATIENT_ARTIKEL_JOINT MODIFY Dosis VARCHAR(255);ALTER TABLE PATIENT_ARTIKEL_JOINT MODIFY Bemerkung VARCHAR(255);", "ALTER TABLE VK_PREISE MODIFY MULTIPLIKATOR VARCHAR(8);ALTER TABLE EK_PREISE MODIFY MULTIPLIKATOR VARCHAR(8);", "ALTER TABLE LEISTUNGEN MODIFY VK_TP VARCHAR(8);ALTER TABLE LEISTUNGEN MODIFY VK_SCALE VARCHAR(8);", "ALTER TABLE LOGS MODIFY OID VARCHAR(255);ALTER TABLE LOGS MODIFY station VARCHAR(255);", "ALTER TABLE ARTIKEL ADD ATC_code VARCHAR(255);", "ALTER TABLE LEISTUNGEN ADD userID VARCHAR(25);", "ALTER TABLE LABORITEMS ADD loinccode VARCHAR(128);ALTER TABLE LABORITEMS ADD visible VARCHAR(1);ALTER TABLE LABORITEMS MODIFY billingcode VARCHAR(128);ALTER TABLE LABORITEMS ADD digits VARCHAR(16);ALTER TABLE LABORITEMS ADD formula VARCHAR(255);ALTER TABLE LABORWERTE MODIFY resultat VARCHAR(255);ALTER TABLE LABORWERTE ADD ExtInfo BLOB;ALTER TABLE LABORWERTE ADD unit VARCHAR(255);ALTER TABLE LABORWERTE ADD analysetime VARCHAR(24);ALTER TABLE LABORWERTE ADD observationtime VARCHAR(24);ALTER TABLE LABORWERTE ADD transmissiontime VARCHAR(24);ALTER TABLE LABORWERTE ADD refmale VARCHAR(255);ALTER TABLE LABORWERTE ADD reffemale VARCHAR(255);ALTER TABLE LABORWERTE ADD OriginID VARCHAR(25);", "ALTER TABLE KONTAKT_ADRESS_JOINT ADD myRType CHAR(4);ALTER TABLE KONTAKT_ADRESS_JOINT ADD otherRType CHAR(4);ALTER TABLE PATIENT_ARTIKEL_JOINT MODIFY Artikel VARCHAR(255);", "ALTER TABLE PATIENT_ARTIKEL_JOINT ADD prescType CHAR(2);ALTER TABLE PATIENT_ARTIKEL_JOINT ADD sortOrder CHAR(3);ALTER TABLE PATIENT_ARTIKEL_JOINT ADD prescDate CHAR(8);ALTER TABLE PATIENT_ARTIKEL_JOINT ADD prescriptor VARCHAR(25);ALTER TABLE LEISTUNGSBLOCK ADD Macro VARCHAR(30);CREATE INDEX block3 on LEISTUNGSBLOCK(Macro);", "ALTER TABLE PATIENT_ARTIKEL_JOINT MODIFY DateFrom CHAR(24);ALTER TABLE PATIENT_ARTIKEL_JOINT MODIFY DateUntil CHAR(24);ALTER TABLE BRIEFE MODIFY Betreff VARCHAR(255);ALTER TABLE BRIEFE ADD note VARCHAR(255);ALTER TABLE BRIEFE MODIFY Datum CHAR(24);ALTER TABLE BRIEFE MODIFY modifiziert CHAR(24);", "ALTER TABLE BRIEFE MODIFY note TEXT;", "ALTER TABLE REMINDERS ADD priority CHAR(1);ALTER TABLE REMINDERS ADD actionType CHAR(2);ALTER TABLE REMINDERS ADD subject VARCHAR(160);", "ALTER TABLE KONTO ADD account VARCHAR(255);", "FILE", "FILE", "FILE", "FILE", "FILE", "FILE", "FILE", "ALTER TABLE LABORWERTE ADD pathodesc VARCHAR(128);", "FILE", "FILE", "FILE", "FILE"};
    protected static Logger log = LoggerFactory.getLogger(DBUpdate.class);
    static VersionInfo vi;

    public static boolean doUpdate() {
        String dbv = ConfigServiceHolder.getGlobal((String)"dbversion", null);
        if (dbv == null) {
            log.error("Kann keine Version lesen");
            ElexisStatus es = new ElexisStatus(2, "ch.elexis.core.data", 2, "Fataler Fehler bei Datenbank-Update: Kann keine Versionsinformation lesen. Abbruch", 1);
            ElexisEventDispatcher.fireElexisStatusEvent(es);
            System.exit(0);
        } else {
            vi = new VersionInfo(dbv);
        }
        ArrayList<String> sqlStrings = new ArrayList<String>();
        int i = 0;
        while (i < versions.length) {
            if (vi.isOlder(versions[i])) {
                String[] cmd = cmds[i].split(";");
                int cmdIdx = 0;
                while (cmdIdx < cmd.length) {
                    if (FILE_LOCATED.equals(cmd[cmdIdx])) {
                        String dbscript = DBUpdate.readDBScriptForVersionFromFile(versions[i], PersistentObject.getConnection().DBFlavor);
                        if (dbscript == null) {
                            return false;
                        }
                        sqlStrings.add(dbscript);
                    } else {
                        sqlStrings.add(cmd[cmdIdx]);
                    }
                    ++cmdIdx;
                }
            }
            ++i;
        }
        log.info("Start DBUpdate from Version " + dbv + " to Version " + versions[versions.length - 1]);
        boolean success = CoreOperationAdvisorHolder.get().performDatabaseUpdate(sqlStrings.toArray(new String[0]), "ch.elexis.core.data");
        if (success) {
            ConfigServiceHolder.setGlobal((String)"dbversion", (String)"3.7.0");
            ConfigServiceHolder.setGlobal((String)"ElexisVersion", (String)CoreHub.Version);
            log.info("DBUpdate from Version " + dbv + " to Version " + versions[versions.length - 1] + " successful.");
        } else {
            log.error("DBUpdate from Version " + dbv + " to Version " + versions[versions.length - 1] + " failed.");
            System.out.println("DBUpdate from Version " + dbv + " to Version " + versions[versions.length - 1] + " failed.");
        }
        return success;
    }

    public static String readDBScriptForVersionFromFile(String version, String dBFlavor) {
        String resourceName = "/rsc/dbScripts/" + version.replaceAll("\\.", "_");
        URL resource = DBUpdate.class.getResource(String.valueOf(resourceName) + "_" + dBFlavor + ".sql");
        resourceName = resource != null ? String.valueOf(resourceName) + "_" + dBFlavor + ".sql" : String.valueOf(resourceName) + ".sql";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream inputStream = DBUpdate.class.getResourceAsStream(resourceName);){
                return new BufferedReader(new InputStreamReader(inputStream)).lines().filter(s -> !s.startsWith("#")).collect(Collectors.joining("\n"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Error reading input file [{}] for version [{}]." + resourceName, (Object)version);
            return null;
        }
    }
}

