/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.wizards;

import ch.elexis.core.common.DBConnection;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.wizards.DBConnectWizard;
import ch.elexis.core.ui.wizards.DBConnectWizardPage;
import ch.elexis.core.ui.wizards.Messages;
import ch.elexis.core.ui.wizards.TestDBConnectionGroup;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.xml.bind.JAXBException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DBConnectSelectionConnectionWizardPage
extends DBConnectWizardPage {
    private Label lblConnection;
    private Label lblUser;
    private Label lblDriver;
    private Label lblTyp;
    private ComboViewer cViewerConns;
    private Button btnDelStoredConn;
    private Button btnCopyStoredConn;

    public DBConnectSelectionConnectionWizardPage(String dBConnectWizard_typeOfDB) {
        super(Messages.DBConnectFirstPage_Connection);
        this.setTitle(Messages.DBConnectFirstPage_Connection);
        this.setMessage(Messages.DBConnectSelectionConnectionWizardPage_this_message);
    }

    @Override
    public void createControl(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)area);
        Group grpStatCurrentConnection = new Group(area, 0);
        grpStatCurrentConnection.setLayout((Layout)new GridLayout(2, true));
        grpStatCurrentConnection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpStatCurrentConnection.setText(Messages.DBConnectWizardPage_grpStatCurrentConnection_text);
        this.createEntityArea(grpStatCurrentConnection);
        Composite cmpExistConnSelector = new Composite(area, 2048);
        cmpExistConnSelector.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        cmpExistConnSelector.setLayout((Layout)new GridLayout(3, false));
        Label lblGespeicherteVerbindungen = new Label(cmpExistConnSelector, 0);
        lblGespeicherteVerbindungen.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        lblGespeicherteVerbindungen.setText(Messages.DBConnectWizardPage_lblGespeicherteVerbindungen_text);
        this.cViewerConns = new ComboViewer(cmpExistConnSelector, 8);
        Combo combo = this.cViewerConns.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cViewerConns.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cViewerConns.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                DBConnection dbc = (DBConnection)element;
                if (dbc.username != null && dbc.connectionString != null) {
                    return String.valueOf(dbc.username) + "@" + dbc.connectionString;
                }
                return "Neue Verbindung erstellen";
            }
        });
        this.cViewerConns.setInput(this.getDBConnectWizard().getStoredConnectionList());
        this.btnDelStoredConn = new Button(cmpExistConnSelector, 0x800000);
        this.btnDelStoredConn.setImage(Images.IMG_DELETE.getImage());
        this.btnDelStoredConn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstElement;
                IStructuredSelection selection = (IStructuredSelection)DBConnectSelectionConnectionWizardPage.this.cViewerConns.getSelection();
                if (selection.size() > 0 && (firstElement = selection.getFirstElement()) != null) {
                    DBConnectSelectionConnectionWizardPage.this.getDBConnectWizard().removeConnection((DBConnection)firstElement);
                    DBConnectSelectionConnectionWizardPage.this.cViewerConns.setInput(DBConnectSelectionConnectionWizardPage.this.getDBConnectWizard().getStoredConnectionList());
                    DBConnectSelectionConnectionWizardPage.this.setCurrentSelection();
                }
            }
        });
        this.btnCopyStoredConn = new Button(cmpExistConnSelector, 0x800000);
        this.btnCopyStoredConn.setImage(Images.IMG_COPY.getImage());
        this.btnCopyStoredConn.setToolTipText("Verbindungsdaten in Zwischenablage kopieren");
        this.btnCopyStoredConn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstElement;
                IStructuredSelection selection = (IStructuredSelection)DBConnectSelectionConnectionWizardPage.this.cViewerConns.getSelection();
                if (selection.size() > 0 && (firstElement = selection.getFirstElement()) != null) {
                    DBConnection dbc = (DBConnection)firstElement;
                    Clipboard cb = new Clipboard(UiDesk.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    try {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                            dbc.marshall((OutputStream)bos);
                            cb.setContents(new Object[]{bos.toString()}, new Transfer[]{textTransfer});
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | JAXBException e1) {
                        MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)"Error", (String)e1.getMessage());
                    }
                }
            }
        });
        this.cViewerConns.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() > 0 && (firstElement = selection.getFirstElement()) != null) {
                    DBConnection targetedConnection = (DBConnection)firstElement;
                    DBConnectSelectionConnectionWizardPage.this.getDBConnectWizard().setTargetedConnection(targetedConnection);
                    DBConnectSelectionConnectionWizardPage.this.btnDelStoredConn.setEnabled(!targetedConnection.equals(DBConnectSelectionConnectionWizardPage.this.getDBConnectWizard().getCurrentConnection()));
                }
            }
        });
        this.setCurrentSelection();
        Label lblOderAufDer = new Label(cmpExistConnSelector, 0);
        lblOderAufDer.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        lblOderAufDer.setText(Messages.DBConnectSelectionConnectionWizardPage_lblOderAufDer_text);
        this.tdbg = new TestDBConnectionGroup(area, 0, this.getDBConnectWizard());
        this.tdbg.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void setCurrentSelection() {
        if (this.getDBConnectWizard().getCurrentConnection() == null) {
            return;
        }
        this.cViewerConns.setSelection((ISelection)new StructuredSelection((Object)this.getDBConnectWizard().getCurrentConnection()));
    }

    private void createEntityArea(Group grpEntity) {
        String driver = "";
        String user = "";
        String typ = "";
        String connection = "";
        Composite typArea = new Composite((Composite)grpEntity, 0);
        typArea.setLayout((Layout)new GridLayout(2, false));
        Label lTyp = new Label(typArea, 0);
        lTyp.setImage(Images.IMG_TABLE.getImage());
        this.lblTyp = new Label(typArea, 0);
        Composite driverArea = new Composite((Composite)grpEntity, 0);
        driverArea.setLayout((Layout)new GridLayout(2, false));
        Label lDriver = new Label(driverArea, 0);
        lDriver.setImage(Images.IMG_GEAR.getImage());
        this.lblDriver = new Label(driverArea, 0);
        Composite userArea = new Composite((Composite)grpEntity, 0);
        userArea.setLayout((Layout)new GridLayout(2, false));
        Label lUser = new Label(userArea, 0);
        lUser.setImage(Images.IMG_USER_SILHOUETTE.getImage());
        this.lblUser = new Label(userArea, 0);
        Composite connArea = new Composite((Composite)grpEntity, 0);
        connArea.setLayout((Layout)new GridLayout(2, false));
        Label lConnection = new Label(connArea, 0);
        lConnection.setImage(Images.IMG_NODE.getImage());
        this.lblConnection = new Label(connArea, 0);
        Hashtable<Object, Object> conn = this.readRunningEntityInfos();
        if (conn != null) {
            driver = PersistentObject.checkNull((Object)conn.get("driver"));
            connection = PersistentObject.checkNull((Object)conn.get("connectionstring"));
            user = PersistentObject.checkNull((Object)conn.get("user"));
            typ = PersistentObject.checkNull((Object)conn.get("typ"));
        }
        this.lblTyp.setText(typ);
        this.lblDriver.setText(driver);
        this.lblUser.setText(user);
        this.lblConnection.setText(connection);
    }

    private Hashtable<Object, Object> readRunningEntityInfos() {
        Hashtable conn = null;
        String cnt = CoreHub.localCfg.get("verbindung/folded_string", null);
        if (cnt != null) {
            conn = PersistentObject.fold((byte[])StringTool.dePrintable((String)cnt));
            return conn;
        }
        return null;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
    }

    private DBConnectWizard getDBConnectWizard() {
        return (DBConnectWizard)this.getWizard();
    }
}

