/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IOutputter;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.text.EditLocalDocumentUtil;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.OutputLog;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class RezeptBlatt
extends ViewPart
implements ITextPlugin.ICallback,
IActivationListener,
IOutputter {
    public static final String ID = "ch.elexis.RezeptBlatt";
    TextContainer text;
    Brief actBrief;
    private boolean addressSelection = false;

    public void dispose() {
        if (this.actBrief != null) {
            LocalLockServiceHolder.get().releaseLock((Object)this.actBrief);
        }
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        super.dispose();
    }

    private void updateTextLock() {
        if (this.actBrief != null) {
            LockResponse result = LocalLockServiceHolder.get().acquireLock((Object)this.actBrief);
            if (result.isOk()) {
                this.text.getPlugin().setParameter(null);
            } else {
                LockResponseHelper.showInfo(result, this.actBrief, null);
                this.text.getPlugin().setParameter(ITextPlugin.Parameter.READ_ONLY);
            }
        }
    }

    public void loadRezeptFromDatabase(Rezept rp, Brief brief) {
        if (this.actBrief != null) {
            LocalLockServiceHolder.get().releaseLock((Object)this.actBrief);
        }
        this.actBrief = brief;
        this.updateTextLock();
        this.text.open(brief);
        rp.setBrief(this.actBrief);
        EditLocalDocumentUtil.startEditLocalDocument((IViewPart)this, brief);
    }

    public void createPartControl(Composite parent) {
        this.text = new TextContainer(this.getViewSite());
        this.text.getPlugin().createContainer(parent, this);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
    }

    public void setFocus() {
    }

    public boolean createList(Rezept rp, String template, String replace) {
        if (this.actBrief != null) {
            LocalLockServiceHolder.get().releaseLock((Object)this.actBrief);
        }
        Kontakt adressat = this.addressSelection ? null : (Kontakt)ElexisEventDispatcher.getSelected(Patient.class);
        this.actBrief = this.text.createFromTemplateName(this.text.getAktuelleKons(), template, "Rezept", adressat, String.valueOf(template) + " " + rp.getDate());
        this.updateTextLock();
        List lines = rp.getLines();
        String[][] fields = new String[lines.size()][];
        int[] wt = new int[]{10, 70, 20};
        if (replace.equals(Messages.RezeptBlatt_4)) {
            fields = this.createRezeptListFields(lines);
        }
        rp.setBrief(this.actBrief);
        if (!this.insertTable(replace, fields, wt, "Rezept")) {
            replace = Messages.RezeptBlatt_4_Extended;
            fields = this.createExtendedTakingListFields(lines);
            wt = new int[]{5, 45, 10, 10, 15, 15};
            this.insertTable(replace, fields, wt, "Rezept");
        }
        this.text.saveBrief(this.actBrief, "Rezept");
        EditLocalDocumentUtil.startEditLocalDocument((IViewPart)this, this.actBrief);
        return true;
    }

    private boolean insertTable(String replace, String[][] fields, int[] wt, String typ) {
        if (this.text.getPlugin().insertTable(replace, 0, fields, wt)) {
            if (this.text.getPlugin().isDirectOutput()) {
                this.text.getPlugin().print(null, null, true);
                this.getSite().getPage().hideView((IViewPart)this);
            }
            return true;
        }
        return false;
    }

    public boolean createList(Prescription[] prescriptions, String template, String replace) {
        if (this.actBrief != null) {
            LocalLockServiceHolder.get().releaseLock((Object)this.actBrief);
        }
        TimeTool now = new TimeTool();
        this.actBrief = this.text.createFromTemplateName(this.text.getAktuelleKons(), template, "Allg.", (Kontakt)((Patient)ElexisEventDispatcher.getSelected(Patient.class)), String.valueOf(template) + " " + now.toString(4));
        this.updateTextLock();
        List<Prescription> lines = Arrays.asList(prescriptions);
        String[][] fields = new String[lines.size()][];
        int[] wt = new int[]{10, 70, 20};
        if (replace.equals(Messages.RezeptBlatt_4)) {
            fields = this.createRezeptListFields(lines);
        } else if (replace.equals(Messages.RezeptBlatt_6)) {
            fields = this.createTakingListFields(lines);
        }
        if (!this.insertTable(replace, fields, wt, "Allg.")) {
            if (replace.equals(Messages.RezeptBlatt_4)) {
                replace = Messages.RezeptBlatt_4_Extended;
                fields = this.createExtendedTakingListFields(lines);
                wt = new int[]{5, 45, 10, 10, 15, 15};
                this.insertTable(replace, fields, wt, "Rezept");
            } else if (replace.equals(Messages.RezeptBlatt_6)) {
                replace = Messages.RezeptBlatt_6_Extended;
                fields = this.createExtendedTakingListFields(lines);
                wt = new int[]{5, 45, 10, 10, 15, 15};
                this.insertTable(replace, fields, wt, "Allg.");
            }
        }
        this.text.saveBrief(this.actBrief, "Allg.");
        EditLocalDocumentUtil.startEditLocalDocument((IViewPart)this, this.actBrief);
        return true;
    }

    public String[][] createRezeptListFields(List<Prescription> lines) {
        String[][] fields = new String[lines.size()][];
        int i = 0;
        while (i < fields.length) {
            Prescription p = lines.get(i);
            fields[i] = new String[3];
            fields[i][0] = p.get(Messages.RezeptBlatt_number);
            String bem = p.getBemerkung();
            fields[i][1] = StringTool.isNothing((Object)bem) ? p.getSimpleLabel() : String.valueOf(p.getSimpleLabel()) + "\t\r" + bem;
            fields[i][2] = p.getDosis();
            ++i;
        }
        return fields;
    }

    public String[][] createTakingListFields(List<Prescription> lines) {
        String[][] fields = new String[lines.size()][];
        int i = 0;
        while (i < fields.length) {
            Prescription p = lines.get(i);
            fields[i] = new String[3];
            fields[i][0] = p.get(Messages.RezeptBlatt_number);
            String bem = p.getBemerkung();
            String patInfo = p.getDisposalComment();
            fields[i][1] = StringTool.isNothing((Object)bem) ? p.getSimpleLabel() : (patInfo == null || patInfo.isEmpty() ? String.valueOf(p.getSimpleLabel()) + "\t\r" + bem : String.valueOf(p.getSimpleLabel()) + "\t\r" + bem + "\r" + patInfo);
            fields[i][2] = p.getDosis();
            ++i;
        }
        return fields;
    }

    public String[][] createExtendedTakingListFields(List<Prescription> lines) {
        String[][] fields = new String[lines.size() + 1][];
        fields[0] = new String[6];
        fields[0][0] = "";
        fields[0][1] = "Medikament";
        fields[0][2] = "Einnahme";
        fields[0][3] = "Von bis und mit";
        fields[0][4] = "Anwendungsinstruktion";
        fields[0][5] = "Anwendungsgrund";
        int i = 1;
        while (i < fields.length) {
            Prescription p = lines.get(i - 1);
            fields[i] = new String[6];
            fields[i][0] = p.getEntryType() != null && p.getEntryType() != EntryType.RECIPE && p.getEntryType() != EntryType.UNKNOWN ? p.getEntryType().name().substring(0, 1) : "";
            fields[i][1] = StringUtils.defaultString((String)p.getSimpleLabel());
            fields[i][2] = StringUtils.defaultString((String)p.getDosis());
            fields[i][3] = StringUtils.defaultString((String)p.getBeginDate());
            fields[i][4] = StringUtils.defaultString((String)p.getBemerkung());
            fields[i][5] = StringUtils.defaultString((String)p.getDisposalComment());
            ++i;
        }
        return fields;
    }

    public boolean createRezept(Rezept rp) {
        boolean ret = this.createList(rp, "Rezept", Messages.RezeptBlatt_4);
        if (ret) {
            new OutputLog((PersistentObject)rp, (IOutputter)this);
            return true;
        }
        return false;
    }

    public boolean createEinnahmeliste(Patient pat, Prescription[] pres) {
        return this.createList(pres, "Einnahmeliste", Messages.RezeptBlatt_6);
    }

    @Override
    public void save() {
        if (this.actBrief != null) {
            this.actBrief.save(this.text.getPlugin().storeToByteArray(), this.text.getPlugin().getMimeType());
        }
    }

    @Override
    public boolean saveAs() {
        return false;
    }

    @Override
    public void activation(boolean mode) {
        if (!mode) {
            this.save();
        }
    }

    @Override
    public void visible(boolean mode) {
    }

    public String getOutputterDescription() {
        return "Druckerausgabe erstellt";
    }

    public String getOutputterID() {
        return ID;
    }

    public Image getSymbol() {
        return Images.IMG_PRINTER.getImage();
    }

    public boolean isAddressSelection() {
        return this.addressSelection;
    }

    public void setAddressSelection(boolean value) {
        this.addressSelection = value;
    }
}

