/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.dialogs.AssignStickerDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.locks.LockedAction;
import ch.elexis.core.ui.locks.LockedRestrictedAction;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.CoverageComparator;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.DiagnosenDisplay;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.VerrechnungsDisplay;
import ch.elexis.core.ui.views.controls.StickerComposite;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsDetailView
extends ViewPart
implements IUnlockable {
    public static final String ID = "ch.elexis.Konsdetail";
    private static final String NO_CONS_SELECTED = Messages.KonsDetailView_NoConsSelected;
    public static final String CFG_VERTRELATION = "vertrelation";
    public static final String CFG_HORIZRELATION = "horizrelation";
    private Logger log = LoggerFactory.getLogger(KonsDetailView.class);
    Hashtable<String, IKonsExtension> hXrefs;
    EnhancedTextField text;
    private Label lBeh;
    Hyperlink hlMandant;
    ComboViewer comboViewerFall;
    private IEncounter actEncounter;
    FormToolkit tk;
    Form form;
    IPatient actPat;
    Color defaultBackground;
    private DiagnosenDisplay diagnosesDisplay;
    private VerrechnungsDisplay billedDisplay;
    private Action versionBackAction;
    private LockedAction<IEncounter> saveAction;
    private RestrictedAction purgeAction;
    Action versionFwdAction;
    Action assignStickerAction;
    Action versionDisplayAction;
    int displayedVersion;
    Font emFont;
    Composite cDesc;
    StickerComposite stickerComposite;
    private int[] sashWeights = null;
    private SashForm sash;
    private int[] diagAndChargeSashWeights = null;
    private SashForm diagAndChargeSash;
    private ComboFallSelectionListener comboFallSelectionListener;
    private boolean created = false;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this){

        @Override
        public void partActivated(IWorkbenchPartReference partRef) {
            if (this.isMatchingPart(partRef) && KonsDetailView.this.actEncounter != null && !KonsDetailView.this.text.isDirty()) {
                KonsDetailView.this.setKonsText(KonsDetailView.this.actEncounter, KonsDetailView.this.actEncounter.getVersionedEntry().getHeadVersion());
            }
        }

        @Override
        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (this.isMatchingPart(partRef) && KonsDetailView.this.actEncounter != null && KonsDetailView.this.text.isDirty()) {
                EncounterServiceHolder.get().updateVersionedEntry(KonsDetailView.this.actEncounter, KonsDetailView.this.text.getContentsAsXML(), KonsDetailView.this.getVersionRemark());
                KonsDetailView.this.text.setDirty(false);
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)KonsDetailView.this.actEncounter);
            }
        }

        @Override
        public void partVisible(IWorkbenchPartReference partRef) {
            if (this.isMatchingPart(partRef)) {
                KonsDetailView.this.adaptMenus();
            }
        }
    };

    @Optional
    @Inject
    void udpatePatient(@UIEventTopic(value="info/elexis/model/update") IPatient patient) {
        if (patient != null && patient.equals(this.actPat) && this.created) {
            this.actPat = null;
            this.setPatient(patient);
        }
    }

    @Inject
    void reloadPatient(@Optional @UIEventTopic(value="info/elexis/model/reload") IPatient patient) {
        if (patient != null && patient.equals(this.actPat) && this.created) {
            this.actPat = null;
            this.setPatient(patient);
        }
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        if (this.created) {
            Display.getDefault().asyncExec(() -> {
                this.actPat = null;
                this.setPatient(patient);
            });
        }
    }

    @Inject
    void changedMandator(@Optional @UIEventTopic(value="info/elexis/user/changed") IUser mandator) {
        if (this.created) {
            Display.getDefault().asyncExec(() -> this.adaptMenus());
        }
    }

    @Inject
    void reloadCoverage(@Optional @UIEventTopic(value="info/elexis/model/reload") ICoverage coverage) {
        if (this.created) {
            this.updateFallCombo();
        }
    }

    @Inject
    void updateCoverage(@Optional @UIEventTopic(value="info/elexis/model/update") ICoverage coverage) {
        if (this.created) {
            this.updateFallCombo();
        }
    }

    @Inject
    void lockPreRelease(@Optional @UIEventTopic(value="info/elexis/locking/prerelease") IEncounter encounter) {
        if (this.created && Objects.equals(encounter, this.actEncounter)) {
            this.save();
        }
    }

    @Inject
    void selectedEncounter(@Optional IEncounter encounter) {
        if (this.created) {
            Display.getDefault().asyncExec(() -> {
                if (encounter != null) {
                    IEncounter deselectedKons = this.actEncounter;
                    this.setKons(encounter);
                    this.releaseAndRefreshLock(deselectedKons);
                    this.setKons(encounter);
                } else {
                    IEncounter deselectedKons = this.actEncounter;
                    this.setKons(null);
                    this.releaseAndRefreshLock(deselectedKons);
                }
            });
        }
    }

    @Optional
    @Inject
    void udpateEncounter(@UIEventTopic(value="info/elexis/model/update") IEncounter encounter) {
        if (this.created && encounter != null && encounter.equals(this.actEncounter)) {
            this.setKons(encounter);
        }
    }

    @Inject
    void lockedEncounter(@Optional @UIEventTopic(value="info/elexis/locking/aquired") IEncounter encounter) {
        if (this.created && encounter != null && Objects.equals(encounter, this.actEncounter)) {
            IEncounter db_encounter = (IEncounter)CoreModelServiceHolder.get().load(encounter.getId(), IEncounter.class, false, true).get();
            long db_lastupdate = db_encounter.getLastupdate();
            if (db_lastupdate > this.actEncounter.getLastupdate()) {
                CoreOperationAdvisorHolder.get().openInformation("Konsultation wurde aktualisiert", "Die Konsultation wurde zwischenzeitlich aktualisiert.\nAktuelle Version wird geladen.");
                this.text.setDirty(false);
                LocalLockServiceHolder.get().releaseLock((Object)encounter);
                this.setKons(encounter);
            } else {
                this.setUnlocked(true);
                this.refreshContributionItemState();
            }
        }
    }

    @Inject
    void unlockedEncounter(@Optional @UIEventTopic(value="info/elexis/locking/released") IEncounter encounter) {
        if (this.created && Objects.equals(encounter, this.actEncounter)) {
            this.setUnlocked(false);
            this.refreshContributionItemState();
        }
    }

    private void releaseAndRefreshLock(Object object) {
        if (object != null && LocalLockServiceHolder.get().isLockedLocal(object)) {
            LocalLockServiceHolder.get().releaseLock(object);
        }
        this.refreshContributionItemState();
    }

    private void refreshContributionItemState() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements("ch.elexis.core.ui.command.ToggleCurrentKonsultationLockCommand", null);
    }

    public void saveState(IMemento memento) {
        int[] w = this.sash.getWeights();
        memento.putString(CFG_VERTRELATION, String.valueOf(Integer.toString(w[0])) + "," + Integer.toString(w[1]));
        w = this.diagAndChargeSash.getWeights();
        memento.putString(CFG_HORIZRELATION, String.valueOf(Integer.toString(w[0])) + "," + Integer.toString(w[1]));
        super.saveState(memento);
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        IContributionItem[] items;
        boolean hlMandantEnabled = this.actEncounter != null && BillingServiceHolder.get().isEditable(this.actEncounter).isOK() && CoreHub.acl.request(AccessControlDefaults.KONS_REASSIGN) && unlocked;
        this.hlMandant.setEnabled(hlMandantEnabled);
        boolean cbFallEnabled = this.actEncounter != null && BillingServiceHolder.get().isEditable(this.actEncounter).isOK() && unlocked;
        this.comboViewerFall.getCombo().setEnabled(cbFallEnabled);
        this.text.setEditable(unlocked);
        IToolBarManager mgr = ((IViewSite)this.getSite()).getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = items = mgr.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            iContributionItem.update();
            ++n2;
        }
    }

    public void createPartControl(Composite p) {
        int[] nArray;
        int[] nArray2;
        this.setTitleImage(Images.IMG_VIEW_CONSULTATION_DETAIL.getImage());
        this.sash = new SashForm(p, 512);
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm((Composite)this.sash);
        this.form.getBody().setLayout((Layout)new GridLayout(1, true));
        this.form.setText(NO_CONS_SELECTED);
        this.stickerComposite = StickerComposite.createWrappedStickerComposite(this.form.getBody(), this.tk);
        this.cDesc = new Composite(this.form.getBody(), 0);
        this.cDesc.setLayout((Layout)new RowLayout(256));
        this.cDesc.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.lBeh = this.tk.createLabel(this.cDesc, NO_CONS_SELECTED);
        this.emFont = UiDesk.getFont("Helvetica", 11, 1);
        this.lBeh.setFont(this.emFont);
        this.defaultBackground = p.getBackground();
        this.hlMandant = this.tk.createHyperlink(this.cDesc, "--", 0);
        this.hlMandant.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IMandator mandator;
                Mandant currentMandant = ElexisEventDispatcher.getSelectedMandator();
                KontaktSelektor ksl = new KontaktSelektor(KonsDetailView.this.getSite().getShell(), Mandant.class, Messages.KonsDetailView_SelectMandatorCaption, Messages.KonsDetailView_SelectMandatorBody, new String[]{"Kuerzel", "Bezeichnung1", "Bezeichnung2"});
                if (ksl.open() == 0 && (mandator = (IMandator)CoreModelServiceHolder.get().load(((Mandant)ksl.getSelection()).getId(), IMandator.class).orElse(null)) != null) {
                    EncounterServiceHolder.get().transferToMandator(KonsDetailView.this.actEncounter, mandator, false);
                }
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)currentMandant);
            }
        });
        this.hlMandant.setBackground(p.getBackground());
        this.comboViewerFall = new ComboViewer(this.form.getBody(), 4);
        this.comboViewerFall.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewerFall.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ICoverage)element).getLabel();
            }
        });
        this.comboFallSelectionListener = new ComboFallSelectionListener();
        this.comboViewerFall.addSelectionChangedListener((ISelectionChangedListener)this.comboFallSelectionListener);
        GridData gdFall = new GridData(768);
        this.comboViewerFall.getCombo().setLayoutData((Object)gdFall);
        this.text = new EnhancedTextField(this.form.getBody());
        this.hXrefs = new Hashtable();
        List xrefs = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension"), (String)"KonsExtension", (boolean)false);
        for (IKonsExtension x : xrefs) {
            String provider = x.connect(this.text);
            this.hXrefs.put(provider, x);
        }
        this.text.setXrefHandlers(this.hXrefs);
        List makros = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension"), (String)"KonsMakro", (boolean)false);
        this.text.setExternalMakros(makros);
        GridData gd = new GridData(1808);
        this.text.setLayoutData(gd);
        this.tk.adapt((Composite)this.text);
        this.diagAndChargeSash = new SashForm((Composite)this.sash, 256);
        Composite botleft = this.tk.createComposite((Composite)this.diagAndChargeSash);
        botleft.setLayout((Layout)new GridLayout(1, false));
        Composite botright = this.tk.createComposite((Composite)this.diagAndChargeSash);
        botright.setLayout((Layout)new GridLayout(1, false));
        this.diagnosesDisplay = new DiagnosenDisplay(this.getSite().getPage(), botleft, 0);
        CoreUiUtil.injectServices(this.diagnosesDisplay);
        this.diagnosesDisplay.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.billedDisplay = new VerrechnungsDisplay(this.getSite().getPage(), botright, 0);
        CoreUiUtil.injectServices(this.billedDisplay);
        this.billedDisplay.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.getSite().registerContextMenu("ch.elexis.Konsdetail.VerrechnungsDisplay", this.billedDisplay.getMenuManager(), (ISelectionProvider)this.billedDisplay.getViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.billedDisplay.getViewer());
        if (this.diagAndChargeSashWeights == null) {
            int[] nArray3 = new int[2];
            nArray3[0] = 40;
            nArray2 = nArray3;
            nArray3[1] = 60;
        } else {
            nArray2 = this.diagAndChargeSashWeights;
        }
        this.diagAndChargeSash.setWeights(nArray2);
        this.makeActions();
        IViewSite viewSite = this.getViewSite();
        ViewMenus menu = new ViewMenus(viewSite);
        menu.createMenu(new IAction[]{this.versionDisplayAction, this.versionFwdAction, this.versionBackAction, GlobalActions.delKonsAction, GlobalActions.redateAction, this.assignStickerAction, this.purgeAction});
        if (this.sashWeights == null) {
            int[] nArray4 = new int[2];
            nArray4[0] = 80;
            nArray = nArray4;
            nArray4[1] = 20;
        } else {
            nArray = this.sashWeights;
        }
        this.sash.setWeights(nArray);
        menu.createToolbar(new IAction[]{this.saveAction});
        this.text.connectGlobalActions(viewSite);
        this.adaptMenus();
        this.created = true;
        ContextServiceHolder.get().getTyped(IEncounter.class).ifPresent(e -> this.selectedEncounter((IEncounter)e));
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento == null) {
            this.sashWeights = new int[]{80, 20};
            this.diagAndChargeSashWeights = new int[]{40, 60};
        } else {
            String state = memento.getString(CFG_VERTRELATION);
            if (state == null) {
                state = "80,20";
            }
            String[] sw = state.split(",");
            this.sashWeights = new int[]{Integer.parseInt(sw[0]), Integer.parseInt(sw[1])};
            state = memento.getString(CFG_HORIZRELATION);
            if (state == null) {
                state = "40,60";
            }
            sw = state.split(",");
            this.diagAndChargeSashWeights = new int[]{Integer.parseInt(sw[0]), Integer.parseInt(sw[1])};
        }
        super.init(site, memento);
    }

    public void dispose() {
        this.created = false;
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        if (this.text != null) {
            this.text.disconnectGlobalActions(this.getViewSite());
        }
        super.dispose();
    }

    private synchronized void setPatient(IPatient pat) {
        LoggerFactory.getLogger(this.getClass()).info("[KONS PAT] " + (pat != null ? pat.getId() : "null"));
        if (pat != null && this.actPat != null && pat.getId().equals(this.actPat.getId()) && !this.form.getText().equals(Messages.KonsDetailView_NoConsSelected)) {
            return;
        }
        this.actPat = pat;
        if (pat != null) {
            this.form.setText(String.valueOf(pat.getLabel()) + " " + "(" + pat.getAgeInYears() + ")");
            this.stickerComposite.setPatient(pat);
            this.updateFallCombo();
        }
        this.form.layout();
    }

    private void updateFallCombo() {
        IPatient pat = ContextServiceHolder.get().getRootContext().getTyped(IPatient.class).orElse(null);
        if (pat != null && this.comboViewerFall != null) {
            List coverages = pat.getCoverages();
            Collections.sort(coverages, new CoverageComparator());
            this.comboViewerFall.setInput((Object)coverages);
            if (this.actEncounter != null) {
                this.comboFallSelectionListener.ignoreSelectionEventOnce();
                this.comboViewerFall.setSelection((ISelection)new StructuredSelection((Object)this.actEncounter.getCoverage()));
            }
        }
    }

    public void setFocus() {
        this.text.setFocus();
    }

    private synchronized void setKons(IEncounter encounter) {
        LoggerFactory.getLogger(this.getClass()).info("[KONS] " + (encounter != null ? encounter.getId() : "null"));
        if (this.actEncounter != null && this.text.isDirty()) {
            EncounterServiceHolder.get().updateVersionedEntry(this.actEncounter, this.text.getContentsAsXML(), this.getVersionRemark());
            this.text.setDirty(false);
        }
        if (encounter != null) {
            ICoverage coverage = encounter.getCoverage();
            this.setPatient(coverage.getPatient());
            this.setKonsText(encounter, encounter.getVersionedEntry().getHeadVersion());
            this.comboFallSelectionListener.ignoreSelectionEventOnce();
            this.comboViewerFall.setSelection((ISelection)new StructuredSelection((Object)coverage));
            this.comboViewerFall.getCombo().setEnabled(coverage.isOpen());
            IMandator mandator = encounter.getMandator();
            String encounterDate = TimeUtil.formatSafe((LocalDate)encounter.getDate());
            this.lBeh.setText(String.valueOf(encounterDate) + " (" + new TimeTool(encounter.getDate()).getDurationToNowString() + ")");
            StringBuilder sb = new StringBuilder();
            if (mandator == null) {
                sb.append(Messages.KonsDetailView_NotYours);
                this.hlMandant.setBackground(this.hlMandant.getParent().getBackground());
            } else {
                IContact biller = mandator.getBiller();
                if (biller.getId().equals(mandator.getId())) {
                    sb.append("(").append(mandator.getLabel()).append(")");
                } else {
                    sb.append("(").append(mandator.getLabel()).append("/").append(biller.getLabel()).append(")");
                }
                this.hlMandant.setBackground(UiMandant.getColorForMandator(Mandant.load((String)mandator.getId())));
            }
            this.hlMandant.setText(sb.toString());
            boolean hlMandantEnabled = BillingServiceHolder.get().isEditable(encounter).isOK() && CoreHub.acl.request(AccessControlDefaults.KONS_REASSIGN);
            this.hlMandant.setEnabled(hlMandantEnabled);
            this.diagnosesDisplay.setEncounter(encounter);
            this.billedDisplay.setEncounter(encounter);
            this.billedDisplay.setEnabled(true);
            this.diagnosesDisplay.setEnabled(true);
            if (BillingServiceHolder.get().isEditable(encounter).isOK()) {
                this.text.setEnabled(true);
                this.text.setToolTipText("");
                this.lBeh.setForeground(UiDesk.getColor("schwarz"));
                this.lBeh.setBackground(this.defaultBackground);
            } else {
                this.text.setToolTipText("Konsultation geschlossen oder nicht von Ihnen");
                this.lBeh.setForeground(UiDesk.getColor("grau60"));
                this.lBeh.setBackground(UiDesk.getColor("grau20"));
            }
            if (encounter.getDate().isEqual(LocalDate.now())) {
                this.text.setTextBackground(UiDesk.getColor("weiss"));
            } else {
                this.text.setTextBackground(UiDesk.getColorFromRGB("FAFAFA"));
            }
        } else {
            this.form.setText(NO_CONS_SELECTED);
            this.lBeh.setText("-");
            this.hlMandant.setText("--");
            this.hlMandant.setEnabled(false);
            this.hlMandant.setBackground(this.hlMandant.getParent().getBackground());
            this.diagnosesDisplay.clear();
            this.billedDisplay.clear();
            this.text.setText("");
            this.text.setEnabled(false);
            this.billedDisplay.setEnabled(false);
            this.diagnosesDisplay.setEnabled(false);
        }
        this.actEncounter = encounter;
        this.cDesc.layout();
        if (this.actEncounter == null) {
            this.setUnlocked(false);
        } else {
            this.setUnlocked(LocalLockServiceHolder.get().isLockedLocal((Object)this.actEncounter));
        }
    }

    private String getVersionRemark() {
        String remark = "edit";
        java.util.Optional activeUser = ContextServiceHolder.get().getRootContext().getTyped(IUser.class);
        if (activeUser.isPresent()) {
            remark = ((IUser)activeUser.get()).getLabel();
        }
        return remark;
    }

    void setKonsText(IEncounter encounter, int version) {
        String ntext = "";
        if (version >= 0 && version <= encounter.getVersionedEntry().getHeadVersion()) {
            VersionedResource vr = encounter.getVersionedEntry();
            VersionedResource.ResourceItem entry = vr.getVersion(version);
            ntext = entry.data;
            StringBuilder sb = new StringBuilder();
            sb.append("rev. ").append(version).append(Messages.KonsDetailView_of).append(new TimeTool(entry.timestamp).toString(0)).append(" (").append(entry.remark).append(")");
            this.versionDisplayAction.setText(sb.toString());
        } else {
            this.versionDisplayAction.setText("");
        }
        this.text.setText(ntext);
        this.text.setKons(encounter);
        this.displayedVersion = version;
        this.versionBackAction.setEnabled(version != 0);
        this.versionFwdAction.setEnabled(version != encounter.getVersionedEntry().getHeadVersion());
    }

    private void makeActions() {
        this.versionDisplayAction = new Action(){
            private String versionText;

            public String getText() {
                return this.versionText;
            }

            public void setText(String text) {
                this.versionText = text;
            }

            public boolean isEnabled() {
                return false;
            }
        };
        this.purgeAction = new LockedRestrictedAction<IEncounter>(AccessControlDefaults.AC_PURGE, Messages.KonsDetailView_PurgeOldEntries){

            @Override
            public IEncounter getTargetedObject() {
                return KonsDetailView.this.actEncounter;
            }

            @Override
            public void doRun(IEncounter element) {
                element.getVersionedEntry().purge();
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)Konsultation.load((String)element.getId()));
            }
        };
        this.versionBackAction = new Action(Messages.KonsDetailView_PreviousEntry){

            public void run() {
                if (KonsDetailView.this.actEncounter == null) {
                    return;
                }
                if (MessageDialog.openConfirm((Shell)KonsDetailView.this.getViewSite().getShell(), (String)Messages.KonsDetailView_ReplaceKonsTextCaption, (String)Messages.KonsDetailView_ReplaceKonsTextBody)) {
                    KonsDetailView.this.setKonsText(KonsDetailView.this.actEncounter, KonsDetailView.this.displayedVersion - 1);
                    KonsDetailView.this.text.setDirty(true);
                }
            }
        };
        this.versionFwdAction = new Action(Messages.KonsDetailView_nextEntry){

            public void run() {
                if (KonsDetailView.this.actEncounter == null) {
                    return;
                }
                if (MessageDialog.openConfirm((Shell)KonsDetailView.this.getViewSite().getShell(), (String)Messages.KonsDetailView_ReplaceKonsTextCaption, (String)Messages.KonsDetailView_ReplaceKonsTextBody2)) {
                    KonsDetailView.this.setKonsText(KonsDetailView.this.actEncounter, KonsDetailView.this.displayedVersion + 1);
                    KonsDetailView.this.text.setDirty(true);
                }
            }
        };
        this.saveAction = new LockedAction<IEncounter>(Messages.KonsDetailView_SaveEntry){
            {
                this.setImageDescriptor(Images.IMG_DISK.getImageDescriptor());
                this.setToolTipText(Messages.KonsDetailView_SaveExplicit);
            }

            @Override
            public IEncounter getTargetedObject() {
                return KonsDetailView.this.actEncounter;
            }

            @Override
            public void doRun(IEncounter element) {
                KonsDetailView.this.save();
            }
        };
        this.versionFwdAction.setImageDescriptor(Images.IMG_NEXT.getImageDescriptor());
        this.versionBackAction.setImageDescriptor(Images.IMG_PREVIOUS.getImageDescriptor());
        this.purgeAction.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
        this.assignStickerAction = new Action("Sticker..."){
            {
                this.setToolTipText("Der Konsultation einer Sticker zuweisen");
            }

            public void run() {
                if (KonsDetailView.this.actEncounter != null) {
                    AssignStickerDialog asd = new AssignStickerDialog(KonsDetailView.this.getViewSite().getShell(), (Identifiable)KonsDetailView.this.actEncounter);
                    asd.open();
                }
            }
        };
    }

    public void save() {
        if (this.actEncounter != null) {
            if (this.text.isDirty()) {
                EncounterServiceHolder.get().updateVersionedEntry(this.actEncounter, this.text.getContentsAsXML(), this.getVersionRemark());
                this.text.setDirty(false);
            }
            this.setKons(this.actEncounter);
        } else {
            this.log.warn("Save() actKons == null");
        }
    }

    public void adaptMenus() {
        this.billedDisplay.adaptMenus();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    private class ComboFallSelectionListener
    implements ISelectionChangedListener {
        private boolean ignoreEventSelectionChanged;

        private ComboFallSelectionListener() {
        }

        public void ignoreSelectionEventOnce() {
            this.ignoreEventSelectionChanged = true;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (!this.ignoreEventSelectionChanged && (selection = event.getSelection()) instanceof StructuredSelection && !selection.isEmpty()) {
                ICoverage changeToCoverage = (ICoverage)((StructuredSelection)selection).getFirstElement();
                ICoverage actCoverage = null;
                String fallLabel = "Current Case NOT found!!";
                if (KonsDetailView.this.actEncounter != null) {
                    actCoverage = KonsDetailView.this.actEncounter.getCoverage();
                    fallLabel = actCoverage.getLabel();
                }
                if (!changeToCoverage.equals(actCoverage)) {
                    if (!changeToCoverage.isOpen()) {
                        SWTHelper.alert(Messages.KonsDetailView_CaseClosedCaption, Messages.KonsDetailView_CaseClosedBody);
                    } else {
                        MessageDialog msd = new MessageDialog(KonsDetailView.this.getViewSite().getShell(), Messages.KonsDetailView_ChangeCaseCaption, Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize), MessageFormat.format(Messages.KonsDetailView_ConfirmChangeConsToCase, fallLabel, changeToCoverage.getLabel()), 3, new String[]{Messages.KonsDetailView_Yes, Messages.KonsDetailView_No}, 0);
                        if (msd.open() == 0) {
                            Result transferResult = EncounterServiceHolder.get().transferToCoverage(KonsDetailView.this.actEncounter, changeToCoverage, false);
                            if (!transferResult.isOK()) {
                                SWTHelper.alert("Error", transferResult.toString());
                            }
                        } else {
                            this.ignoreSelectionEventOnce();
                            KonsDetailView.this.comboViewerFall.setSelection((ISelection)new StructuredSelection((Object)actCoverage));
                        }
                    }
                }
            }
            this.ignoreEventSelectionChanged = false;
        }
    }
}

