/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.data.UiSticker;
import ch.elexis.core.ui.dialogs.ImageChooser;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Sticker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Stickers
extends PreferencePage
implements IWorkbenchPreferencePage {
    Combo combo;
    Canvas cImage;
    Canvas cFore;
    Canvas cBack;
    Sticker act;
    List<Sticker> lEtiketten;
    Button bNew;
    Button bRemove;
    Spinner spWert;
    HashMap<String, Button> classesCheck = new HashMap();

    void setSticker(Sticker et) {
        this.act = et;
        if (et == null) {
            this.cImage.setBackground(UiDesk.getColor("weiss"));
            this.cFore.setBackground(UiDesk.getColor("schwarz"));
            this.cBack.setBackground(UiDesk.getColor("hellgrau"));
            this.spWert.setSelection(0);
        } else {
            UiSticker uist = new UiSticker(et);
            this.cFore.setBackground(uist.getForeground());
            this.cBack.setBackground(uist.getBackground());
            this.spWert.setSelection(this.act.getWert());
            List classes = et.getClassesForSticker();
            for (Map.Entry<String, Button> e : this.classesCheck.entrySet()) {
                e.getValue().setSelection(false);
            }
            for (String st : classes) {
                Button b = this.classesCheck.get(st);
                if (b == null) continue;
                b.setSelection(true);
            }
        }
        this.cImage.redraw();
        this.cFore.redraw();
        this.cBack.redraw();
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.combo = new Combo(ret, 64);
        this.combo.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = Stickers.this.combo.getSelectionIndex();
                if (i > -1) {
                    Stickers.this.setSticker(Stickers.this.lEtiketten.get(i));
                    Stickers.this.bRemove.setEnabled(true);
                }
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (Stickers.this.combo.getText().length() == 0) {
                    Stickers.this.bNew.setEnabled(false);
                } else {
                    Stickers.this.bNew.setEnabled(true);
                }
            }
        });
        for (Sticker et : this.lEtiketten) {
            if (!et.isVisible()) continue;
            this.combo.add(et.getLabel());
        }
        Composite bottom = new Composite(ret, 0);
        bottom.setLayout((Layout)new GridLayout(3, false));
        this.bNew = new Button(bottom, 8);
        this.bNew.setText(Messages.Stickers_NewSticker);
        this.bNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = Stickers.this.combo.getText();
                Sticker n = new Sticker(name, null, null);
                Stickers.this.lEtiketten.add(n);
                Stickers.this.combo.add(n.getLabel());
            }
        });
        this.bRemove = new Button(bottom, 8);
        this.bRemove.setText(Messages.Stickers_DeleteSticker);
        this.bRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = Stickers.this.combo.getSelectionIndex();
                if (idx > -1) {
                    Stickers.this.combo.remove(idx);
                    Sticker eti = Stickers.this.lEtiketten.get(idx);
                    Stickers.this.lEtiketten.remove(idx);
                    eti.delete();
                }
            }
        });
        Group bottomRight = new Group(bottom, 0);
        bottomRight.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 5, true));
        bottomRight.setLayout((Layout)new RowLayout(512));
        bottomRight.setText(Messages.Stickers_useFor);
        this.addAssociateButton(Messages.Stickers_patient, Patient.class, (Composite)bottomRight);
        this.addAssociateButton(Messages.Stickers_consultation, Konsultation.class, (Composite)bottomRight);
        this.addAssociateButton(Messages.Stickers_case, Fall.class, (Composite)bottomRight);
        this.addAssociateButton(Messages.Stickers_document, Brief.class, (Composite)bottomRight);
        bottom.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.cImage = new Canvas(bottom, 2048);
        this.cImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image img;
                GC gc = e.gc;
                if (Stickers.this.act != null && (img = new UiSticker(Stickers.this.act).getImage()) != null) {
                    gc.drawImage(img, 0, 0);
                    return;
                }
                gc.setForeground(UiDesk.getColor("grau20"));
                gc.fillRectangle(0, 0, 32, 32);
            }
        });
        GridData gdImage = new GridData(32, 32);
        this.cImage.setLayoutData((Object)gdImage);
        Button bNewImage = new Button(bottom, 8);
        bNewImage.setText(Messages.Stickers_Image);
        bNewImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageChooser imc;
                if (Stickers.this.act != null && (imc = new ImageChooser(Stickers.this.getShell())).open() == 0) {
                    new UiSticker(Stickers.this.act).setImage(imc.getSelection());
                    Stickers.this.setSticker(Stickers.this.act);
                }
            }
        });
        this.cFore = new Canvas(bottom, 2048);
        GridData gdFore = new GridData(32, 16);
        this.cFore.setLayoutData((Object)gdFore);
        Button bFore = new Button(bottom, 8);
        bFore.setText(Messages.Stickers_TextColor);
        bFore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Stickers.this.act != null) {
                    ColorDialog cd = new ColorDialog(Stickers.this.getShell(), 0);
                    RGB rgb = cd.open();
                    if (rgb != null) {
                        Stickers.this.act.setForeground(UiDesk.createColor(rgb));
                    }
                    Stickers.this.setSticker(Stickers.this.act);
                }
            }
        });
        this.cBack = new Canvas(bottom, 2048);
        GridData gdBack = GridDataFactory.copyData((GridData)gdFore);
        this.cBack.setLayoutData((Object)gdBack);
        Button bBack = new Button(bottom, 8);
        bBack.setText(Messages.Stickers_BackgroundColor);
        bBack.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Stickers.this.act != null) {
                    ColorDialog cd = new ColorDialog(Stickers.this.getShell(), 0);
                    RGB rgb = cd.open();
                    if (rgb != null) {
                        Stickers.this.act.setBackground(UiDesk.createColor(rgb));
                    }
                    Stickers.this.setSticker(Stickers.this.act);
                }
            }
        });
        this.spWert = new Spinner(bottom, 0);
        this.spWert.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (Stickers.this.act != null) {
                    Stickers.this.act.setWert(Stickers.this.spWert.getSelection());
                }
            }
        });
        new Label(bottom, 0).setText(Messages.Stickers_ValueOfSticker);
        this.bNew.setEnabled(false);
        this.bRemove.setEnabled(false);
        return ret;
    }

    public void init(IWorkbench workbench) {
        Query qbe = new Query(Sticker.class);
        this.lEtiketten = qbe.execute();
        if (this.lEtiketten == null) {
            this.lEtiketten = new LinkedList<Sticker>();
        }
    }

    private void addAssociateButton(String label, final Class<?> clazz, Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = Stickers.this.combo.getSelectionIndex();
                if (i > -1) {
                    Sticker sticker = Stickers.this.lEtiketten.get(i);
                    if (button.getSelection()) {
                        sticker.setClassForSticker(clazz);
                    } else {
                        sticker.removeClassForSticker(clazz);
                    }
                }
            }
        });
        this.classesCheck.put(clazz.getName(), button);
    }
}

