/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.StringTool;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

public class Money
extends Number
implements Comparable<Money> {
    private static final String formatPattern = "#,##0.00";
    private static final DecimalFormatSymbols symbols = new DecimalFormatSymbols();
    private static final long serialVersionUID = 7466555366749958L;
    private static Locale locale = Locale.getDefault();
    private int cents;
    private double frac;

    public Money() {
        this.cents = 0;
    }

    public Money(Money money) {
        this.cents = money.cents;
        this.frac = money.frac;
    }

    public Money(int cent) {
        this.cents = cent;
    }

    public Money(double amount) {
        this.cents = (int)Math.round(amount * 100.0);
    }

    public Money(String val) throws ParseException {
        this.addAmount(Money.checkInput(val).doubleValue());
    }

    public static Number checkInput(String rawValue) throws ParseException {
        Double num;
        if (StringTool.isNothing(rawValue)) {
            num = new Double(0.0);
        } else {
            String val = rawValue.trim();
            num = Money.parse(val);
        }
        return num;
    }

    private static Double parse(String raw) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator('\'');
        DecimalFormat format = new DecimalFormat(formatPattern, symbols);
        Number ret = format.parse(raw, parsePosition);
        if (ret != null && parsePosition.getIndex() == raw.length()) {
            return ret.doubleValue();
        }
        parsePosition = new ParsePosition(0);
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator('\u2019');
        format = new DecimalFormat(formatPattern, symbols);
        ret = format.parse(raw, parsePosition);
        if (ret != null && parsePosition.getIndex() == raw.length()) {
            return ret.doubleValue();
        }
        parsePosition = new ParsePosition(0);
        symbols.setDecimalSeparator(',');
        symbols.setGroupingSeparator('.');
        format = new DecimalFormat(formatPattern, symbols);
        ret = format.parse(raw, parsePosition);
        if (ret != null && parsePosition.getIndex() == raw.length()) {
            return ret.doubleValue();
        }
        throw new ParseException(raw, 1);
    }

    public void addCent(String cents) {
        String cleanValue = cents != null ? cents.trim() : "0";
        this.cents += Integer.parseInt(cleanValue);
    }

    public void addCent(int cents) {
        this.cents += cents;
    }

    public void addAmount(double amount) {
        this.cents = (int)((long)this.cents + Math.round(amount * 100.0));
    }

    public void addAmount(String amount) throws ParseException {
        this.addAmount(Money.checkInput(amount).doubleValue());
    }

    public Money addMoney(Money money) {
        this.cents += money.cents;
        this.frac += money.frac;
        if (Math.abs(this.frac) >= 1.0) {
            this.cents = (int)((double)this.cents + Math.signum(this.frac));
            this.frac -= Math.signum(this.frac);
        }
        return this;
    }

    public Money subtractMoney(Money money) {
        this.cents -= money.cents;
        this.frac -= money.frac;
        if (this.frac < 0.0) {
            this.frac += 1.0;
            --this.cents;
        }
        return this;
    }

    public int getCents() {
        return this.cents;
    }

    public double getAmount() {
        return (double)this.cents / 100.0;
    }

    public String getCentsAsString() {
        return Integer.toString(this.getCents());
    }

    public String getAmountAsString() {
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        String frm = nf.format(this.getAmount());
        return frm;
    }

    public Money roundTo5() {
        this.frac = this.cents;
        double sum = (double)this.cents / 100.0;
        this.cents = (int)(5L * Math.round(sum * 20.0));
        this.frac -= (double)this.cents;
        return this;
    }

    public double getFrac() {
        return this.frac;
    }

    public String getFracAsString() {
        return Double.toString(this.frac);
    }

    public Money multiply(double factor) {
        this.cents = (int)Math.round((double)this.cents * factor);
        return this;
    }

    public Money negate() {
        return this.multiply(-1.0);
    }

    public boolean isZero() {
        return this.cents == 0;
    }

    public boolean isMoreThan(Money other) {
        return this.cents > other.cents;
    }

    public boolean isNegative() {
        if (this.cents < 0) {
            return true;
        }
        if (this.cents == 0) {
            return this.frac < 0.0;
        }
        return false;
    }

    public boolean isNeglectable() {
        return Math.abs(this.cents) < 3;
    }

    public String toString() {
        return this.getAmountAsString();
    }

    public static void setLocale(Locale locale) {
        Money.locale = locale;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Money)) {
            return false;
        }
        Money other = (Money)obj;
        return this.cents == other.cents;
    }

    public int hashCode() {
        return this.cents;
    }

    @Override
    public int compareTo(Money other) {
        return this.cents - other.getCents();
    }

    @Override
    public double doubleValue() {
        return this.getAmount();
    }

    @Override
    public float floatValue() {
        return new Float(this.getAmount()).floatValue();
    }

    @Override
    public int intValue() {
        return this.getCents();
    }

    @Override
    public long longValue() {
        return this.getCents();
    }

    public static char getSeparator() {
        double d = 0.5;
        String ds = NumberFormat.getCurrencyInstance().format(d);
        return ds.charAt(1);
    }
}

