/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entitymanager;

import ch.elexis.core.jpa.entitymanager.ui.IDatabaseUpdateUi;
import ch.elexis.core.jpa.liquibase.LiquibaseDBInitializer;
import ch.elexis.core.jpa.liquibase.LiquibaseDBScriptExecutor;
import ch.elexis.core.jpa.liquibase.LiquibaseDBUpdater;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.utils.CoreUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"id=default"})
public class ElexisEntityManger
implements IElexisEntityManager {
    private static Logger logger = LoggerFactory.getLogger(ElexisEntityManger.class);
    private EntityManagerFactoryBuilder factoryBuilder;
    private EntityManagerFactory factory;
    private DataSource dataSource;
    private final ThreadLocal<EntityManager> threadLocal = new ThreadLocal();
    private final Map<Thread, EntityManager> threadManagerMap = new ConcurrentHashMap<Thread, EntityManager>();
    private ScheduledExecutorService entityManagerCollector = Executors.newSingleThreadScheduledExecutor();
    private boolean updateSuccess;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private IDatabaseUpdateUi updateProgress;

    @Activate
    public void activate() {
        this.updateSuccess = false;
        this.entityManagerCollector.scheduleAtFixedRate(new EntityManagerCollector(), 2L, 2L, TimeUnit.SECONDS);
    }

    @Deactivate
    public void deactivate() {
        this.entityManagerCollector.shutdown();
    }

    @Reference(service=DataSource.class, unbind="unbindDataSource", target="(id=default)")
    protected synchronized void bindDataSource(DataSource dataSource) {
        logger.debug("Binding " + dataSource.getClass().getName());
        this.dataSource = dataSource;
    }

    protected synchronized void unbindDataSource(DataSource dataSource) {
        logger.debug("Unbinding " + dataSource.getClass().getName());
        if (this.factory != null) {
            this.factory.close();
            this.factory = null;
        }
        this.dataSource = null;
    }

    @Reference(service=EntityManagerFactoryBuilder.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, target="(osgi.unit.name=elexis)")
    protected synchronized void bind(EntityManagerFactoryBuilder factoryBuilder) {
        logger.debug("Binding " + factoryBuilder.getClass().getName());
        this.factoryBuilder = factoryBuilder;
    }

    private void dbInitAndUpdate() {
        LiquibaseDBInitializer initializer = new LiquibaseDBInitializer(this.dataSource);
        initializer.init();
        LiquibaseDBUpdater updater = new LiquibaseDBUpdater(this.dataSource);
        this.updateSuccess = updater.update();
    }

    public synchronized EntityManager getEntityManager(boolean managed) {
        if (this.factory == null) {
            if (this.factoryBuilder != null) {
                if (this.updateProgress != null) {
                    try {
                        this.updateProgress.executeWithProgress(() -> this.dbInitAndUpdate());
                    }
                    catch (Exception e) {
                        logger.warn("Exeption executing database update with ui", (Throwable)e);
                    }
                } else {
                    this.dbInitAndUpdate();
                }
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("eclipselink.ddl-generation", "none");
                props.put("gemini.jpa.providerConnectedDataSource", this.dataSource);
                props.put("javax.persistence.nonJtaDataSource", this.dataSource);
                props.put("eclipselink.persistence-context.reference-mode", "WEAK");
                this.factory = this.factoryBuilder.createEntityManagerFactory(props);
            } else {
                throw new IllegalStateException("No EntityManagerFactoryBuilder available");
            }
        }
        if (this.factory != null) {
            if (managed) {
                EntityManager em = this.threadLocal.get();
                if (em == null || !em.isOpen()) {
                    em = this.createManagedEntityManager();
                } else {
                    em.clear();
                }
                return em;
            }
            return this.factory.createEntityManager();
        }
        throw new IllegalStateException("No EntityManagerFactory available");
    }

    public boolean isUpdateSuccess() {
        return this.updateSuccess;
    }

    private EntityManager createManagedEntityManager() {
        logger.debug("Creating new EntityManager for Thread [" + Thread.currentThread() + "]");
        EntityManager em = this.factory.createEntityManager();
        this.threadLocal.set(em);
        this.threadManagerMap.put(Thread.currentThread(), em);
        return em;
    }

    public synchronized void closeEntityManager(Object em) {
        if (this.threadLocal.get() == em) {
            this.threadLocal.set(null);
            this.threadManagerMap.remove(Thread.currentThread());
        }
        ((EntityManager)em).close();
    }

    public void clearCache() {
        this.factory.getCache().evictAll();
    }

    public boolean executeSQLScript(String changeId, String sqlScript) {
        if (CoreUtil.isTestMode() || Boolean.valueOf(System.getProperty("forceExecuteSqlScript")).booleanValue()) {
            LiquibaseDBScriptExecutor executor = new LiquibaseDBScriptExecutor(this.dataSource);
            return executor.execute(changeId, sqlScript);
        }
        logger.warn("Did not execute script [" + changeId + "] as system not started in mode " + "elexis.test.mode");
        return false;
    }

    private class EntityManagerCollector
    implements Runnable {
        private EntityManagerCollector() {
        }

        @Override
        public void run() {
            if (ElexisEntityManger.this.threadManagerMap != null && !ElexisEntityManger.this.threadManagerMap.isEmpty()) {
                Thread[] threadArray = ElexisEntityManger.this.threadManagerMap.keySet().toArray(new Thread[0]);
                int n = threadArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    if (!thread.isAlive()) {
                        logger.debug("Closing EntityManager of non active thread [" + thread.getName() + "]");
                        EntityManager em = ElexisEntityManger.this.threadManagerMap.get(thread);
                        if (em != null) {
                            em.close();
                        }
                        ElexisEntityManger.this.threadManagerMap.remove(thread);
                    }
                    ++n2;
                }
            }
        }
    }
}

