/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IAddress;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.IRelatedContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.format.PostalAddress;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.elexis.core.types.Country;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Contact
extends AbstractIdDeleteModelAdapter<Kontakt>
implements IdentifiableWithXid,
IContact {
    public Contact(Kontakt entity) {
        super((EntityWithId)entity);
    }

    public boolean isMandator() {
        return ((Kontakt)this.getEntity()).isMandator();
    }

    public void setMandator(boolean value) {
        ((Kontakt)this.getEntityMarkDirty()).setMandator(value);
    }

    public boolean isUser() {
        return ((Kontakt)this.getEntity()).isUser();
    }

    public void setUser(boolean value) {
        ((Kontakt)this.getEntityMarkDirty()).setUser(value);
    }

    public boolean isPerson() {
        return ((Kontakt)this.getEntity()).isPerson();
    }

    public void setPerson(boolean value) {
        ((Kontakt)this.getEntityMarkDirty()).setPerson(value);
    }

    public boolean isPatient() {
        return ((Kontakt)this.getEntity()).isPatient();
    }

    public void setPatient(boolean value) {
        ((Kontakt)this.getEntityMarkDirty()).setPatient(value);
    }

    public boolean isLaboratory() {
        return ((Kontakt)this.getEntity()).isLaboratory();
    }

    public void setLaboratory(boolean value) {
        ((Kontakt)this.getEntityMarkDirty()).setLaboratory(value);
    }

    public boolean isOrganization() {
        return ((Kontakt)this.getEntity()).isOrganisation();
    }

    public void setOrganization(boolean value) {
        ((Kontakt)this.getEntityMarkDirty()).setOrganisation(value);
    }

    public boolean isDeceased() {
        return ((Kontakt)this.getEntity()).isDeceased();
    }

    public void setDeceased(boolean value) {
        ((Kontakt)this.getEntityMarkDirty()).setDeceased(value);
    }

    public String getDescription1() {
        return ((Kontakt)this.getEntity()).getDescription1();
    }

    public void setDescription1(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setDescription1(value);
    }

    public String getDescription2() {
        return ((Kontakt)this.getEntity()).getDescription2();
    }

    public void setDescription2(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setDescription2(value);
    }

    public String getDescription3() {
        return ((Kontakt)this.getEntity()).getDescription3();
    }

    public void setDescription3(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setDescription3(value);
    }

    public String getCode() {
        return ((Kontakt)this.getEntity()).getCode();
    }

    public void setCode(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setCode(value);
    }

    public Country getCountry() {
        return ((Kontakt)this.getEntity()).getCountry();
    }

    public void setCountry(Country value) {
        ((Kontakt)this.getEntityMarkDirty()).setCountry(value);
    }

    public String getZip() {
        return ((Kontakt)this.getEntity()).getZip();
    }

    public void setZip(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setZip(value);
    }

    public String getCity() {
        return ((Kontakt)this.getEntity()).getCity();
    }

    public void setCity(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setCity(value);
    }

    public String getStreet() {
        return ((Kontakt)this.getEntity()).getStreet();
    }

    public void setStreet(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setStreet(value);
    }

    public String getPhone1() {
        return ((Kontakt)this.getEntity()).getPhone1();
    }

    public void setPhone1(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setPhone1(value);
    }

    public String getPhone2() {
        return ((Kontakt)this.getEntity()).getPhone2();
    }

    public void setPhone2(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setPhone2(value);
    }

    public String getFax() {
        return ((Kontakt)this.getEntity()).getFax();
    }

    public void setFax(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setFax(value);
    }

    public String getEmail() {
        return ((Kontakt)this.getEntity()).getEmail();
    }

    public void setEmail(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setEmail(value);
    }

    public String getEmail2() {
        return ((Kontakt)this.getEntity()).getEmail2();
    }

    public void setEmail2(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setEmail2(value);
    }

    public String getWebsite() {
        return ((Kontakt)this.getEntity()).getWebsite();
    }

    public void setWebsite(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setWebsite(value);
    }

    public String getMobile() {
        return ((Kontakt)this.getEntity()).getMobile();
    }

    public void setMobile(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setMobile(value);
    }

    public String getComment() {
        return ((Kontakt)this.getEntity()).getComment();
    }

    public void setComment(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setComment(value);
    }

    public String getGroup() {
        return ((Kontakt)this.getEntity()).getGruppe();
    }

    public void setGroup(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setGruppe(value);
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDescription1()).append(" ").append(StringUtils.defaultString((String)this.getDescription2()));
        if (!StringUtils.isBlank((CharSequence)this.getDescription3())) {
            sb.append("(").append(this.getDescription3()).append(")");
        }
        sb.append(", ").append(StringUtils.defaultString((String)this.getStreet())).append(", ").append(StringUtils.defaultString((String)this.getZip())).append(" ").append(StringUtils.defaultString((String)this.getCity()));
        return sb.toString();
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public List<IAddress> getAddress() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        ArrayList addresses = new ArrayList(((Kontakt)this.getEntity()).getAddresses());
        return addresses.parallelStream().filter(f -> !f.isDeleted()).map(f -> ModelUtil.getAdapter((EntityWithId)f, IAddress.class, true)).collect(Collectors.toList());
    }

    public String getPostalAddress() {
        if (((Kontakt)this.getEntity()).getAnschrift() == null) {
            this.setPostalAddress(PostalAddress.of((IContact)this).getWrittenAddress(true, true));
        }
        return ((Kontakt)this.getEntity()).getAnschrift();
    }

    public void setPostalAddress(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setAnschrift(value);
    }

    public IImage getImage() {
        return CoreModelServiceHolder.get().load(this.getId(), IImage.class).orElse(null);
    }

    public void setImage(IImage value) {
        IImage image = this.getImage();
        if (value == null) {
            if (image != null) {
                CoreModelServiceHolder.get().remove((Identifiable)image);
            }
            return;
        }
        if (image == null) {
            image = (IImage)CoreModelServiceHolder.get().create(IImage.class);
            image.setId(this.getId());
            image.setTitle("ContactImage");
        }
        image.setDate(value.getDate());
        image.setPrefix("ch.elexis.data.Kontakt");
        image.setImage(value.getImage());
        image.setMimeType(value.getMimeType());
        CoreModelServiceHolder.get().save((Identifiable)image);
    }

    public List<IRelatedContact> getRelatedContacts() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        ArrayList relatedContacts = new ArrayList(((Kontakt)this.getEntity()).getRelatedContacts());
        return relatedContacts.parallelStream().filter(f -> !f.isDeleted()).map(f -> ModelUtil.getAdapter((EntityWithId)f, IRelatedContact.class, true)).collect(Collectors.toList());
    }
}

