/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.eigendiagnosen.model.service;

import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ModelUtil {
    private static IModelService diagnosisModelService;

    @Reference(target="(service.model.name=ch.elexis.core.eigendiagnosen.model)")
    public void setModelService(IModelService modelService) {
        diagnosisModelService = modelService;
    }

    public static <T> Optional<T> loadDiagnosis(String id, Class<T> clazz) {
        if (id != null) {
            return diagnosisModelService.load(id, clazz);
        }
        return Optional.empty();
    }

    public static Optional<IDiagnosisTree> loadDiagnosisWithCode(String code) {
        INamedQuery query = diagnosisModelService.getNamedQuery(IDiagnosisTree.class, new String[]{"code"});
        List found = query.executeWithParameters(query.getParameterMap(new Object[]{"code", code}));
        if (!found.isEmpty()) {
            return Optional.of((IDiagnosisTree)found.get(0));
        }
        return Optional.empty();
    }

    public static List<IDiagnosisTree> loadDiagnosisWithParent(String parentCode) {
        INamedQuery query = diagnosisModelService.getNamedQuery(IDiagnosisTree.class, new String[]{"parent"});
        return query.executeWithParameters(query.getParameterMap(new Object[]{"parent", parentCode}));
    }
}

