/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dbcheck.contributions.dialogs.RenameAccountingSysFieldDialog;
import ch.elexis.core.ui.dbcheck.contributions.dialogs.SelectValueAccountingSysFieldDialog;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Fall;
import ch.elexis.data.Query;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class RenameAccountingSystemField
extends ExternalMaintenance {
    private static final String DESCRIPTION = "Feld aus Abrechnungssystem umbenennen [3341]";
    private static final String REQUIRED = "/bedingungen";
    private static final String OPTIONAL = "/fakultativ";
    private static final String SEPARATOR = ":";
    private String accountingSystem;
    private String currFieldName;
    private String newFieldName;
    int proceedAsBefore = -1;
    boolean useLegacyValue = true;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        if (this.openRenameAccountingSysFieldDialog()) {
            StringBuilder output = new StringBuilder();
            String beginTask = "Feld '" + this.currFieldName + "' aus Abrechnungssystem [" + this.accountingSystem + "] in '" + this.newFieldName + "' umbenennen";
            pm.beginTask(beginTask, 3);
            output.append(String.valueOf(beginTask) + "\n\n");
            pm.subTask("Lade F\u00e4lle des betroffenen Abrechnungssystem ...");
            Query qbe = new Query(Fall.class);
            qbe.add("billing", "=", this.accountingSystem);
            qbe.addToken("DatumBis is NULL OR DatumBis = ''");
            List fallList = qbe.execute();
            pm.worked(1);
            if (fallList.isEmpty()) {
                output.append("Keine relevanten F\u00e4lle gefunden\n");
            }
            pm.subTask("Feldbezeichnung in einzelnen F\u00e4llen wird aktualisiert ...");
            for (Fall fall : fallList) {
                String currField = fall.getInfoString(this.currFieldName);
                String newField = fall.getInfoString(this.newFieldName);
                if (currField.isEmpty()) continue;
                if (newField.isEmpty()) {
                    fall.setInfoString(this.newFieldName, currField);
                } else if (!currField.equals(newField)) {
                    if (this.proceedAsBefore == -1 || this.proceedAsBefore == 1) {
                        this.openSelectValueAccountingSysFieldDialog(fall, currField, newField);
                    }
                    if (this.useLegacyValue) {
                        fall.setInfoString(this.newFieldName, currField);
                    }
                }
                fall.clearInfoString(this.currFieldName);
            }
            pm.worked(1);
            output.append("Feldbezeichnungen f\u00fcr " + fallList.size() + " F\u00e4lle aktualisiert\n");
            pm.subTask("Globale Einstellungen werden aktualisiert... ");
            String key = "billing/systems/" + this.accountingSystem;
            String updatedConfig = this.updateFieldConfiguration(key, this.currFieldName, this.newFieldName);
            pm.worked(1);
            output.append("Globale Einstellung '" + updatedConfig + "' wurden aktualisiert!\n\n");
            output.append("Umbenennung abgeschlossen!");
            pm.done();
            return output.toString();
        }
        return "Feld aus Abrechnungssystem umbenennen [3341] abgebrochen";
    }

    private void openSelectValueAccountingSysFieldDialog(final Fall fall, final String currField, final String newField) {
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                SelectValueAccountingSysFieldDialog replaceWhichDialog = new SelectValueAccountingSysFieldDialog(UiDesk.getTopShell(), fall.getPatient(), RenameAccountingSystemField.this.accountingSystem, RenameAccountingSystemField.this.currFieldName, currField, RenameAccountingSystemField.this.newFieldName, newField);
                replaceWhichDialog.open();
                RenameAccountingSystemField.this.proceedAsBefore = replaceWhichDialog.rememberProceedure() ? 0 : 1;
                RenameAccountingSystemField.this.useLegacyValue = replaceWhichDialog.useLegacyValue();
            }
        });
    }

    private boolean openRenameAccountingSysFieldDialog() {
        this.accountingSystem = "";
        this.currFieldName = "";
        this.newFieldName = "";
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                RenameAccountingSysFieldDialog rasfDialog = new RenameAccountingSysFieldDialog(display.getActiveShell());
                if (rasfDialog.open() == 0) {
                    RenameAccountingSystemField.this.accountingSystem = rasfDialog.getAccountingSystem();
                    RenameAccountingSystemField.this.currFieldName = rasfDialog.getPresentFieldName();
                    RenameAccountingSystemField.this.newFieldName = rasfDialog.getNewFieldName();
                }
            }
        });
        return !this.accountingSystem.isEmpty() && !this.currFieldName.isEmpty() && !this.newFieldName.isEmpty();
    }

    private String updateFieldConfiguration(String key, String currName, String newName) {
        String configKey = String.valueOf(key) + REQUIRED;
        String config = ConfigServiceHolder.getGlobal((String)configKey, null);
        if (config == null || !config.contains(String.valueOf(currName) + SEPARATOR)) {
            configKey = String.valueOf(key) + OPTIONAL;
            config = ConfigServiceHolder.getGlobal((String)configKey, null);
        }
        String updatedConfig = config.replace(String.valueOf(currName) + SEPARATOR, String.valueOf(newName) + SEPARATOR);
        ConfigServiceHolder.setGlobal((String)configKey, (String)updatedConfig);
        return configKey;
    }

    @Override
    public String getMaintenanceDescription() {
        return DESCRIPTION;
    }
}

