/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.agenda.Area;
import ch.elexis.core.model.agenda.AreaType;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IModelService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Schedule;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class ScheduleStringTransformer
implements IFhirTransformer<Schedule, String> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IAppointmentService appointmentService;

    @Override
    public Optional<Schedule> getFhirObject(String localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Schedule schedule = this.getSchedules().get(localObject);
        return Optional.ofNullable(schedule);
    }

    @Override
    public Optional<String> getLocalObject(Schedule fhirObject) {
        if (this.getSchedules().containsKey(fhirObject.getId())) {
            return Optional.of(this.getSchedules().get(fhirObject.getId()).getId());
        }
        return Optional.empty();
    }

    private Map<String, Schedule> getSchedules() {
        HashMap<String, Schedule> schedules = new HashMap<String, Schedule>();
        List areas = this.appointmentService.getAreas();
        for (Area area : areas) {
            org.hl7.fhir.r4.model.Reference actor;
            Schedule schedule = new Schedule();
            String areaId = DigestUtils.md5Hex((String)area.getName());
            schedule.setId((IIdType)new IdDt(Schedule.class.getSimpleName(), areaId));
            Identifier identifier = new Identifier();
            identifier.setSystem(CodingSystem.ELEXIS_AGENDA_AREA_ID.getSystem());
            identifier.setValue(area.getName());
            schedule.addIdentifier(identifier);
            schedule.setActive(true);
            AreaType type = area.getType();
            if (Objects.equals(AreaType.CONTACT, type)) {
                Optional assignedContact = this.appointmentService.resolveAreaAssignedContact(area.getContactId());
                if (assignedContact.isPresent()) {
                    actor = new org.hl7.fhir.r4.model.Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), ((IContact)assignedContact.get()).getId()));
                } else {
                    LoggerFactory.getLogger(this.getClass()).warn("Could not resolve contact [{}]", (Object)area.getContactId());
                    actor = null;
                }
            } else {
                actor = new org.hl7.fhir.r4.model.Reference((IIdType)new IdDt(Location.class.getSimpleName(), "mainLocation"));
            }
            schedule.getActor().add(actor);
            CodeableConcept areaType = new CodeableConcept();
            areaType.addCoding(new Coding(CodingSystem.ELEXIS_AGENDA_AREA_TYPE.getSystem(), type.toString(), ""));
            schedule.setServiceCategory(Collections.singletonList(areaType));
            schedule.getServiceCategory();
            schedule.setComment(area.getName());
            schedules.put(areaId, schedule);
        }
        return schedules;
    }

    @Override
    public Optional<String> updateLocalObject(Schedule fhirObject, String localObject) {
        return Optional.empty();
    }

    @Override
    public Optional<String> createLocalObject(Schedule fhirObject) {
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Schedule.class.equals(fhirClazz) && String.class.equals(localClazz);
    }
}

