/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.IFamilyMemberHistory;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FindingsContentHelper;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class FamilyMemberHistoryIFamilyMemberHistoryTransformer
implements IFhirTransformer<FamilyMemberHistory, IFamilyMemberHistory> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IFindingsService findingsService;
    private FindingsContentHelper contentHelper;

    @Activate
    public void activate() {
        this.contentHelper = new FindingsContentHelper();
    }

    @Override
    public Optional<FamilyMemberHistory> getFhirObject(IFamilyMemberHistory localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional<IBaseResource> resource = this.contentHelper.getResource((IFinding)localObject);
        if (resource.isPresent()) {
            return Optional.of((FamilyMemberHistory)resource.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IFamilyMemberHistory> getLocalObject(FamilyMemberHistory fhirObject) {
        Optional existing;
        if (fhirObject != null && fhirObject.getId() != null && (existing = this.findingsService.findById(fhirObject.getId(), IFamilyMemberHistory.class)).isPresent()) {
            return Optional.of((IFamilyMemberHistory)existing.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IFamilyMemberHistory> updateLocalObject(FamilyMemberHistory fhirObject, IFamilyMemberHistory localObject) {
        return Optional.empty();
    }

    @Override
    public Optional<IFamilyMemberHistory> createLocalObject(FamilyMemberHistory fhirObject) {
        IFamilyMemberHistory IFamilyMemberHistory2 = (IFamilyMemberHistory)this.findingsService.create(IFamilyMemberHistory.class);
        this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)IFamilyMemberHistory2);
        if (fhirObject.getPatient() != null && fhirObject.getPatient().hasReference()) {
            String id = fhirObject.getPatient().getReferenceElement().getIdPart();
            Optional patient = this.modelService.load(id, IPatient.class);
            patient.ifPresent(k -> IFamilyMemberHistory2.setPatientId(id));
        }
        this.findingsService.saveFinding((IFinding)IFamilyMemberHistory2);
        return Optional.of(IFamilyMemberHistory2);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return FamilyMemberHistory.class.equals(fhirClazz) && IFamilyMemberHistory.class.equals(localClazz);
    }
}

