/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.findings.util.fhir.transformer.helper.FindingsContentHelper;
import ch.elexis.core.findings.util.fhir.transformer.helper.IEncounterHelper;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.Encounter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class EncounterIEncounterTransformer
implements IFhirTransformer<Encounter, IEncounter> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService codeModelService;
    @Reference(target="(service.model.name=ch.elexis.core.findings.model)")
    private IModelService findingsModelService;
    @Reference
    private IFindingsService findingsService;
    private FindingsContentHelper contentHelper;
    private IEncounterHelper encounterHelper;

    @Activate
    public void activate() {
        this.contentHelper = new FindingsContentHelper();
        this.encounterHelper = new IEncounterHelper(this.codeModelService, this.findingsModelService);
    }

    @Override
    public Optional<Encounter> getFhirObject(IEncounter localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional<IBaseResource> resource = this.contentHelper.getResource((IFinding)localObject);
        if (resource.isPresent()) {
            return Optional.of((Encounter)resource.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IEncounter> getLocalObject(Encounter fhirObject) {
        Optional existing;
        if (fhirObject != null && fhirObject.getId() != null && (existing = this.findingsService.findById(fhirObject.getId(), IEncounter.class)).isPresent()) {
            return Optional.of((IEncounter)existing.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IEncounter> updateLocalObject(Encounter fhirObject, IEncounter localObject) {
        return Optional.empty();
    }

    @Override
    public Optional<IEncounter> createLocalObject(Encounter fhirObject) {
        Optional performerKontakt = this.codeModelService.load(this.encounterHelper.getMandatorId(fhirObject).get(), IMandator.class);
        Optional patientKontakt = this.codeModelService.load(this.encounterHelper.getPatientId(fhirObject).get(), IPatient.class);
        if (performerKontakt.isPresent() && patientKontakt.isPresent()) {
            IEncounter iEncounter = (IEncounter)this.findingsService.create(IEncounter.class);
            this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)iEncounter);
            patientKontakt.ifPresent(k -> iEncounter.setPatientId(k.getId()));
            performerKontakt.ifPresent(k -> iEncounter.setMandatorId(k.getId()));
            Optional<ch.elexis.core.model.IEncounter> behandlung = this.encounterHelper.createIEncounter(iEncounter);
            behandlung.ifPresent(cons -> {
                iEncounter.setConsultationId(cons.getId());
                AbstractHelper.acquireAndReleaseLock((Identifiable)cons);
            });
            this.findingsService.saveFinding((IFinding)iEncounter);
            return Optional.of(iEncounter);
        }
        LoggerFactory.getLogger(EncounterIEncounterTransformer.class).warn("Could not create encounter for mandator [" + performerKontakt + "] patient [" + patientKontakt + "]");
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Encounter.class.equals(fhirClazz) && IEncounter.class.equals(localClazz);
    }
}

