/*
 * Decompiled with CFR 0.152.
 */
package ooo.connector;

import ag.ion.noa4e.internal.ui.preferences.LocalOfficeApplicationPreferencesPage;
import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import ooo.connector.server.OOoServer;

public class BootstrapConnector {
    private OOoServer oooServer;
    private String oooConnectionString;

    public BootstrapConnector(String oooExecFolder) {
        this.oooServer = new OOoServer(oooExecFolder);
        this.oooConnectionString = null;
    }

    public BootstrapConnector(OOoServer oooServer) {
        this.oooServer = oooServer;
        this.oooConnectionString = null;
    }

    public XComponentContext connect(String oooAcceptOption, String oooConnectionString) throws BootstrapException {
        System.out.println("BootstrapConnector: connect(oooAcceptOption, oooConnectionString) begin");
        this.oooConnectionString = oooConnectionString;
        if (this.oooConnectionString == null) {
            System.out.println("BootstrapConnector: connect(1): this.oooConnectionString==null");
        } else {
            System.out.println("BootstrapConnector: connect(1): this.oooConnectionString=" + this.oooConnectionString.toString());
        }
        XComponentContext xContext = null;
        try {
            XComponentContext xLocalContext = this.getLocalContext();
            if (oooAcceptOption == null) {
                System.out.println("BootstrapConnector: connect(1): oooAcceptOption==null");
            } else {
                System.out.println("BootstrapConnector: connect(1): oooAcceptOption=" + oooAcceptOption.toString());
            }
            System.out.println("BootstrapConnector: connect(1): about to oooServer.start(oooAcceptOption)...");
            this.oooServer.start(oooAcceptOption);
            System.out.println("BootstrapConnector: connect(1): about to xLocalContext.getServiceManager()...");
            XMultiComponentFactory xLocalServiceManager = xLocalContext.getServiceManager();
            if (xLocalServiceManager == null) {
                throw new BootstrapException("no initial service manager!");
            }
            System.out.println("BootstrapConnector: connect(1): about to UnoUrlResolver.create(xLocalContext)...");
            XUnoUrlResolver xUrlResolver = UnoUrlResolver.create((XComponentContext)xLocalContext);
            if (xUrlResolver == null) {
                System.out.println("BootstrapConnector: connect(1): xUrlResolver==null");
            } else {
                System.out.println("BootstrapConnector: connect(1): xUrlResolver=" + xUrlResolver.toString());
            }
            Integer timeoutBootstrapConnect = LocalOfficeApplicationPreferencesPage.getTimeoutBootstrapConnect();
            if (timeoutBootstrapConnect < 30) {
                System.out.println("BootstrapConnector: WARNING: You're allowing " + timeoutBootstrapConnect / 2 + "+ seconds for Office to load and become available for a connection. Is this realistic?");
            }
            System.out.println("BootstrapConnector: connect(1): Loop: Try to getRemoteContext()...");
            int i = 0;
            while (true) {
                try {
                    System.out.println("BootstrapConnector: connect(1): about to getRemoteContext(xUrlResolver)...");
                    xContext = this.getRemoteContext(xUrlResolver);
                    System.out.println("BootstrapConnector: connect(1): getRemoteContext(xUrlResolver) has returned. break...");
                }
                catch (NoConnectException ex) {
                    System.out.println("BootstrapConnector: connect(1): WARNING: caught NoConnectException: " + i + "...");
                    if (i >= timeoutBootstrapConnect) {
                        System.out.println("BootstrapConnector: connect(1): WARNING: timeoutBootstrapConnect reached, so throwing new BootstrapException() to inform parent.");
                        throw new BootstrapException(ex.toString());
                    }
                    System.out.println("BootstrapConnector: connect(1): WARNING: calling Thread.sleep(500) before trying again...");
                    Thread.sleep(500L);
                    System.out.println("BootstrapConnector: connect(1): TODO: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    System.out.println("BootstrapConnector: connect(1): TODO: Maybe we should handle other types of exceptions by breaking the loop immediately.");
                    System.out.println("BootstrapConnector: connect(1): TODO: After all, e.g. invalid variables passed won't improve simply by retrying.     js ");
                    System.out.println("BootstrapConnector: connect(1): TODO: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    ++i;
                    continue;
                }
                break;
            }
            System.out.println("BootstrapConnector: connect(1): Loop trying to getRemoteContext() is over.");
        }
        catch (RuntimeException e) {
            System.out.println("BootstrapConnector: connect(1): WARNING: caught RuntimeException e; throwing e to inform parent.");
            throw e;
        }
        catch (Exception e) {
            System.out.println("BootstrapConnector: connect(1): WARNING: caught Exception; throwing new BootstrapException(e) to inform parent.");
            throw new BootstrapException(e);
        }
        System.out.println("BootstrapConnector: connect(1): About to return xContext:");
        if (xContext == null) {
            System.out.println("BootstrapConnector: connect(1): xContext==null");
        } else {
            System.out.println("BootstrapConnector: connect(1): xContext=" + xContext.toString());
        }
        return xContext;
    }

    public void disconnect() {
        System.out.println("BootstrapConnector: disconnect() begin");
        if (this.oooConnectionString == null) {
            System.out.println("BootstrapConnector: disconnect(): WARNING: oooConnectionString==null, so simply returning.");
            return;
        }
        try {
            System.out.println("BootstrapConnector: disconnect(): Trying to call office to terminate itself.");
            XComponentContext xLocalContext = this.getLocalContext();
            XUnoUrlResolver xUrlResolver = UnoUrlResolver.create((XComponentContext)xLocalContext);
            XComponentContext xRemoteContext = this.getRemoteContext(xUrlResolver);
            Object desktop = xRemoteContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", xRemoteContext);
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
            xDesktop.terminate();
        }
        catch (Exception e) {
            System.out.println("BootstrapConnector: disconnect(): Bad luck - unable to terminate office.");
        }
        System.out.println("BootstrapConnector: disconnect(): about to oooServer.kill(); oooConnectionString = null...");
        this.oooServer.kill();
        this.oooConnectionString = null;
    }

    private XComponentContext getLocalContext() throws BootstrapException, Exception {
        System.out.println("BootstrapConnector: getLocalContext() begin");
        XComponentContext xLocalContext = Bootstrap.createInitialComponentContext(null);
        if (xLocalContext == null) {
            throw new BootstrapException("no local component context!");
        }
        return xLocalContext;
    }

    private XComponentContext getRemoteContext(XUnoUrlResolver xUrlResolver) throws BootstrapException, ConnectionSetupException, IllegalArgumentException, NoConnectException {
        System.out.println("BootstrapConnector: getRemoteContext(xUrlResolver) begin");
        if (this.oooConnectionString == null) {
            System.out.println("BootstrapConnector: getRemoteContext(1): oooConnectionString==null");
        } else {
            System.out.println("BootstrapConnector: getRemoteContext(1): oooConnectionString=" + this.oooConnectionString);
        }
        System.out.println("BootstrapConnector: getRemoteContext(1): about to xUrlResolver.resolve(oooConnectionString)...");
        Object context = xUrlResolver.resolve(this.oooConnectionString);
        System.out.println("BootstrapConnector: getRemoteContext(1): xUrlResolver.resolve(oooConnectionString) returned");
        if (context == null) {
            System.out.println("BootstrapConnector: getRemoteContext(1): context==null");
        } else {
            System.out.println("BootstrapConnector: getRemoteContext(1): context=" + context.toString());
        }
        System.out.println("BootstrapConnector: getRemoteContext(1): about to UnoRuntime.queryInterface(XComponentContext.class, context)...");
        XComponentContext xContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)context);
        System.out.println("BootstrapConnector: getRemoteContext(1): UnoRuntime.queryInterface(XComponentContext.class, context) returned");
        if (xContext == null) {
            System.out.println("BootstrapConnector: getRemoteContext(1): xContext==null");
        } else {
            System.out.println("BootstrapConnector: getRemoteContext(1): xContext=" + context.toString());
        }
        if (xContext == null) {
            throw new BootstrapException("no component context!");
        }
        System.out.println("BootstrapConnector: getRemoteContext(1): about to return xContext");
        return xContext;
    }

    public static final XComponentContext bootstrap(String oooExecFolder, String oooAcceptOption, String oooConnectionString) throws BootstrapException {
        System.out.println("BootstrapConnector: bootstrap(oooExecFolder, oooAcceptOption, oooConnectionString) begin");
        if (oooExecFolder == null) {
            System.out.println("BootstrapConnector: bootstrap(3): oooExecFolder==null");
        } else {
            System.out.println("BootstrapConnector: bootstrap(3): oooExecFolder=" + oooExecFolder);
        }
        if (oooAcceptOption == null) {
            System.out.println("BootstrapConnector: bootstrap(3): oooAcceptOption==null");
        } else {
            System.out.println("BootstrapConnector: bootstrap(3): oooAcceptOption=" + oooAcceptOption);
        }
        if (oooConnectionString == null) {
            System.out.println("BootstrapConnector: bootstrap(3): oooConnectionString==null");
        } else {
            System.out.println("BootstrapConnector: bootstrap(3): oooConnectionString=" + oooConnectionString);
        }
        BootstrapConnector bootstrapConnector = new BootstrapConnector(oooExecFolder);
        return bootstrapConnector.connect(oooAcceptOption, oooConnectionString);
    }
}

