/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa4e.ui.operations;

import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.desktop.IFrame;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.document.IDocumentDescriptor;
import ag.ion.bion.officelayer.document.IDocumentService;
import ag.ion.noa.frame.ILayoutManager;
import ag.ion.noa4e.internal.ui.preferences.LocalOfficeApplicationPreferencesPage;
import ag.ion.noa4e.ui.operations.Messages;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XLayoutManager;
import com.sun.star.uno.UnoRuntime;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class LoadDocumentOperation
implements IRunnableWithProgress {
    private IOfficeApplication officeApplication = null;
    private IFrame frame = null;
    private IDocumentDescriptor documentDescriptor = null;
    private String documentType = null;
    private URL url = null;
    private InputStream inputStream = null;
    private boolean isSubTask = false;
    private boolean updateProgressMonitor = true;
    private boolean useStream = false;
    private InternalThread internalThread = null;

    public LoadDocumentOperation(IOfficeApplication officeApplication, IFrame frame, URL url, IDocumentDescriptor documentDescriptor) throws IllegalArgumentException {
        this(null, officeApplication, frame, url, documentDescriptor);
    }

    public LoadDocumentOperation(String documentType, IOfficeApplication officeApplication, IFrame frame, URL url, IDocumentDescriptor documentDescriptor) {
        assert (officeApplication != null);
        this.officeApplication = officeApplication;
        this.frame = frame;
        this.url = url;
        this.documentDescriptor = documentDescriptor;
        this.documentType = documentType;
    }

    public LoadDocumentOperation(String documentType, IOfficeApplication officeApplication, URL url, IDocumentDescriptor documentDescriptor) {
        assert (officeApplication != null);
        this.officeApplication = officeApplication;
        this.url = url;
        this.documentDescriptor = documentDescriptor;
        this.documentType = documentType;
    }

    public LoadDocumentOperation(String documentType, IOfficeApplication officeApplication, IFrame frame, InputStream inputStream, IDocumentDescriptor documentDescriptor) {
        assert (officeApplication != null);
        assert (inputStream != null);
        this.officeApplication = officeApplication;
        this.frame = frame;
        this.inputStream = inputStream;
        this.documentDescriptor = documentDescriptor;
        this.documentType = documentType;
    }

    public LoadDocumentOperation(IOfficeApplication officeApplication, InputStream inputStream, IDocumentDescriptor documentDescriptor) {
        this(null, officeApplication, null, inputStream, documentDescriptor);
    }

    public void setIsSubTask(boolean isSubTask) {
        this.isSubTask = isSubTask;
    }

    public void setUpdateProgressMonitor(boolean updateProgressMonitor) {
        this.updateProgressMonitor = updateProgressMonitor;
    }

    public void setUseStream(boolean useStream) {
        this.useStream = useStream;
    }

    public Exception getException() {
        return this.internalThread.getException();
    }

    public IDocument getDocument() {
        if (this.documentType == null) {
            return this.internalThread.getDocument();
        }
        IDocument document = this.internalThread.getDocument();
        if (document != null && document.getDocumentType().equals(this.documentType)) {
            return document;
        }
        return null;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        System.out.println("LoadDocumentOperation: run begins");
        System.out.println("LoadDocumentOperation: run 1");
        this.internalThread = new InternalThread();
        if (this.isSubTask) {
            if (this.updateProgressMonitor) {
                progressMonitor.subTask(Messages.LoadDocumentOperation_monitor_loading_document);
            }
        } else if (this.updateProgressMonitor) {
            progressMonitor.beginTask(Messages.LoadDocumentOperation_monitor_loading_document, 50);
        }
        System.out.println("LoadDocumentOperation: run 2 - about to start internalThread...");
        System.out.println("LoadDocumentOperation: Reading priority of internal thread:");
        System.out.println("LoadDocumentOperation: internalThread.getPriority()=" + this.internalThread.getPriority());
        System.out.println("LoadDocumentOperation: Changing priority of internal thread:");
        this.internalThread.setPriority(1);
        System.out.println("LoadDocumentOperation: internalThread.getPriority()=" + this.internalThread.getPriority());
        this.internalThread.start();
        System.out.println("LoadDocumentOperation: run 2.1 - internalThread has been started");
        int cyclesWaitedForInternalThreadToComplete = 0;
        while (!this.internalThread.done()) {
            System.out.println("LoadDocumentOperation: run 2.2 - sleep(500) begins");
            Thread.sleep(500L);
            System.out.println("LoadDocumentOperation: run 2.3 - sleep(500) ends");
            if (!this.isSubTask) {
                progressMonitor.worked(1);
            }
            System.out.println("LoadDocumentOperation: run 2.4");
            if (progressMonitor.isCanceled()) {
                try {
                    System.out.println("LoadDocumentOperation: run 2.5 - progressMonitor.isCanceled() has been found.");
                    this.internalThread.stop();
                }
                catch (Throwable throwable) {
                    System.out.println("LoadDocumentOperation: run 2.6 - internalThrread.stop() threw exception.");
                }
                System.out.println("LoadDocumentOperation: run 2.7 - progressMonitor.done() about to occur...");
                progressMonitor.done();
                System.out.println("LoadDocumentOperation: run 2.8 - about to throw InterruptException() with message...");
                throw new InterruptedException(Messages.LoadDocumentOperation_exception_message_operation_interrupted);
            }
            if (cyclesWaitedForInternalThreadToComplete >= 0) {
                ++cyclesWaitedForInternalThreadToComplete;
            }
            System.out.println("LoadDocumentOperation: cyclesWaitedForInternalThreadToComplete: " + cyclesWaitedForInternalThreadToComplete);
            int cyclesWatchdogMaximumAllowedHalfSecs = LocalOfficeApplicationPreferencesPage.getTimeoutThreadedWatchdog();
            System.out.println("LoadDocumentOperation: Threaded watchdog timeout from NOAText_jsl preferences: " + cyclesWatchdogMaximumAllowedHalfSecs);
            if (cyclesWatchdogMaximumAllowedHalfSecs == 0) {
                System.out.println("LoadDocumentOperation: Please note: Threaded watchdog = 0 means it has been disabled.");
                continue;
            }
            if (cyclesWaitedForInternalThreadToComplete <= cyclesWatchdogMaximumAllowedHalfSecs) continue;
            cyclesWaitedForInternalThreadToComplete = -1;
            System.out.println("LoadDocumentOperation: MessageDialog.openInformation: Loading the document has taken too long.");
            System.out.println("LoadDocumentOperation: MessageDialog.openInformation: Holding watchdog timer counter while dialog is displayed.");
            MessageDialog.openInformation(null, (String)"Hinweis", (String)("NOAText: LoadDocumentOperation:\n\nDas Laden des Dokuments dauert schon l\u00e4nger als " + cyclesWatchdogMaximumAllowedHalfSecs / 2 + " sec.\n" + "Dies kann folgende Ursachen haben:\n\n" + "(a) Das Starten des Office-Pakets und der Abruf des Dokuments aus der\n" + "      Datenbank dauern einfach so lang, ohne irgendeine Fehlfunktion.\n\n" + "      Auf Wunsch kann ich den Grenzwert des Watchdog Timers erh\u00f6hen.\n\n" + "(b) LibreOffice kann zum \u00d6ffnen von Dokumenten mit vielen Objekten\n" + "      mehrere Minuten ben\u00f6tigen - das ist keine Fehlfunktion in Elexis.\n\n" + "      Die Wartezeit tritt auch auf, wenn man solche Dokumente ausserhalb\n" + "      von Elexis \u00f6ffnet. Im Task-Manager sieht man, dass soffice.bin\n" + "      arbeitet, und der scheinbare Stillstand endet von selbst.\n\n" + "      Dies kann allerdings - je nach Dokument - mehrere Minuten dauern.\n\n" + "      Falls Sie dieses Problem beobachten, sollten Sie bevorzugt\n" + "      ApacheOpenOffice verwenden. Dieses \u00f6ffnet solche Dokumente\n" + "      offenbar ohne gr\u00f6ssere Verz\u00f6gerung.\n\n" + "(c) In OpenOffice/LibreOffice abgedockte Toolbars oder Dialoge\n" + "      k\u00f6nnen das \u00d6ffnen eines Dokuments aus Elexis heraus zum Stillstand\n" + "      bringen. Auch beliebig langes Warten w\u00fcrde hier *nicht* helfen.\n\n" + "      Mit der Anzeige dieses Dialogs wird der Stillstand jedoch behoben.\n" + "      Ausserdem werden in OpenOffice/LibreOffice abgedockte Toolbars\n" + "      m\u00f6glichst automatisch gedockt. Beim n\u00e4chsten Aufruf eines Dokuments\n" + "      k\u00f6nnte der Ausl\u00f6ser des Fehlers also schon verschwunden sein.\n\n" + "Falls Sie diese Fehlermeldung h\u00e4ufiger sehen, w\u00e4re ich Ihnen f\u00fcr\n" + "Informationen zu den n\u00e4heren Umst\u00e4nden dankbar: joerg.sigle@jsigle.com\n\n"));
            System.out.println("LoadDocumentOperation: MessageDialog.openInformation: Resetting watchdog timer counter.");
            cyclesWaitedForInternalThreadToComplete = 0;
        }
        System.out.println("LoadDocumentOperation: run 3 TO DO / WARNING: REMOVED Thread.sleep(3000) here - but comment in code says that this might cause OOo 3.x to crash");
        System.out.println("LoadDocumentOperation: run 4 sleep ends");
        if (!this.isSubTask) {
            progressMonitor.done();
        }
        System.out.println("LoadDocumentOperation: run 5 done");
    }

    private class InternalThread
    extends Thread {
        private Exception exception = null;
        private IDocument document = null;
        private boolean done = false;

        private InternalThread() {
        }

        @Override
        public void run() {
            System.out.println("LoadDocumentOperation: ***************************");
            System.out.println("LoadDocumentOperation: InternalThread: run: begins");
            System.out.println("LoadDocumentOperation: ***************************");
            try {
                System.out.println("LoadDocumentOperation: InternalThread: run: Trying to do work... Do we already know have a valid frame?");
                if (LoadDocumentOperation.this.frame == null) {
                    System.out.println("LoadDocumentOperation: InternalThread: run: frame==null");
                } else {
                    System.out.println("LoadDocumentOperation: InternalThread: run: frame==" + LoadDocumentOperation.this.frame.toString());
                }
                if (LoadDocumentOperation.this.useStream || LoadDocumentOperation.this.inputStream != null) {
                    System.out.println("LoadDocumentOperation: InternalThread: run: useStream || inputStream != null  --- opening a document from an inputStream");
                    InputStream inputStream = null;
                    inputStream = LoadDocumentOperation.this.inputStream != null ? LoadDocumentOperation.this.inputStream : LoadDocumentOperation.this.url.openStream();
                    if (LoadDocumentOperation.this.frame != null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: PRE1 - about to load a document from inputStream into the frame");
                        this.document = LoadDocumentOperation.this.officeApplication.getDocumentService().loadDocument(LoadDocumentOperation.this.frame, inputStream, LoadDocumentOperation.this.documentDescriptor);
                        System.out.println("LoadDocumentOperation: InternalThread: run: POST1 - loaded a document from inputStream into the frame");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: PRE1 FALLBACK - about to load a document from inputStream NOT into a frame, but into a new window");
                        this.document = LoadDocumentOperation.this.officeApplication.getDocumentService().loadDocument(inputStream, LoadDocumentOperation.this.documentDescriptor);
                        System.out.println("LoadDocumentOperation: InternalThread: run: POST1 FALLBACK - loaded a document from inputStream NOT into a frame, but into a new window");
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    System.out.println("LoadDocumentOperation: InternalThread: run: NOT (useStream || inputStream != null)  --- opening a document from a file (or a URL)");
                    System.out.println("LoadDocumentOperation: InternalThread: run: Status before loadDocument()...");
                    if (LoadDocumentOperation.this.officeApplication == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: officeApplication==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: officeApplication=" + LoadDocumentOperation.this.officeApplication.toString());
                    }
                    if (LoadDocumentOperation.this.url == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: url==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: url=" + LoadDocumentOperation.this.url.toString());
                    }
                    if (LoadDocumentOperation.this.frame == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: frame==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: frame=" + LoadDocumentOperation.this.frame.toString());
                    }
                    if (LoadDocumentOperation.this.documentDescriptor == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: documentDescriptor==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: documentDescriptor=" + LoadDocumentOperation.this.documentDescriptor.toString());
                    }
                    System.out.println("LoadDocumentOperation: InternalThread: run: officeApplication.getDesktopService()=" + LoadDocumentOperation.this.officeApplication.getDesktopService());
                    System.out.println("LoadDocumentOperation: InternalThread: run: officeApplication.getDesktopService().getFramesCount()=" + LoadDocumentOperation.this.officeApplication.getDesktopService().getFramesCount());
                    if (LoadDocumentOperation.this.officeApplication.getDesktopService().getFramesCount() > 1) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: getFramesCount()>1, so you probably have multiple (invisible) Office frames open!");
                        System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    }
                    if (LoadDocumentOperation.this.frame != null) {
                        System.out.println();
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: Please consider moving the disableDispatch and layoutManager stuff to a better place!");
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: (Or maybe not - LayoutManager stuff only effective after the docLoad?)");
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: (Maybe due to some \"Load settings with document...\" option, though.)");
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:NewDoc");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:CloseDoc");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:Quit");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:HyperlinkDialog");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:EditHyperlink");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:InsertDraw");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:Navigator");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:Gallery");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:ViewDataSourceBrowser");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:DesignerDialog");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:AutoPilotMenu");
                        LoadDocumentOperation.this.frame.updateDispatches();
                        ILayoutManager layoutManager = LoadDocumentOperation.this.frame.getLayoutManager();
                        layoutManager.hideAll();
                        XFrame xFrame = LoadDocumentOperation.this.frame.getXFrame();
                        XPropertySet xPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xFrame);
                        XLayoutManager xLayoutManager = (XLayoutManager)UnoRuntime.queryInterface(XLayoutManager.class, (Object)xPropSet.getPropertyValue("LayoutManager"));
                        xLayoutManager.dockAllWindows((short)5);
                        xLayoutManager.dockAllWindows((short)3);
                        xLayoutManager.dockAllWindows((short)1);
                        xLayoutManager.dockAllWindows((short)2);
                        xLayoutManager.dockAllWindows((short)4);
                        xLayoutManager.dockAllWindows((short)6);
                        xLayoutManager.dockAllWindows((short)0);
                        System.out.println("LoadDocumentOperation: InternalThread: run: *******************************************************");
                        System.out.println("LoadDocumentOperation: InternalThread: run: PRE2 - about to load a document from url into the frame");
                        System.out.println("LoadDocumentOperation: InternalThread: run: *******************************************************");
                        IDocumentService documentService = LoadDocumentOperation.this.officeApplication.getDocumentService();
                        if (documentService == null) {
                            System.out.println("LoadDocumentOperation: InternalThread: run: documentService()==null");
                            return;
                        }
                        System.out.println("LoadDocumentOperation: InternalThread: run: documentService()=" + documentService.toString());
                        System.out.println("LoadDocumentOperation: InternalThread: run: documentService.MAX_OPENED_DOCS:           " + 50);
                        System.out.println("LoadDocumentOperation: InternalThread: run: documentService.getCurrentDocumentCount(): " + documentService.getCurrentDocumentCount());
                        if (documentService.getCurrentDocumentCount() > 1) {
                            System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                            System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: getCurrentDocumentCount()>1, so you probably have multiple (invisible) Office documents open!");
                            System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        }
                        if (LoadDocumentOperation.this.frame == null) {
                            System.out.println("LoadDocumentOperation: InternalThread: run: frame==null");
                        } else {
                            System.out.println("LoadDocumentOperation: InternalThread: run: frame=" + LoadDocumentOperation.this.frame.toString());
                        }
                        if (LoadDocumentOperation.this.documentDescriptor == null) {
                            System.out.println("LoadDocumentOperation: InternalThread: run: documentDescriptor==null");
                        } else {
                            System.out.println("LoadDocumentOperation: InternalThread: run: documentDescriptor=" + LoadDocumentOperation.this.documentDescriptor.toString());
                        }
                        System.out.println("LoadDocumentOperation: InternalThread: run: ********************************************************************");
                        System.out.println("LoadDocumentOperation: InternalThread: run: CAVE: THIS documentService.loadDocument(frame...) MAY LEAD TO A METHOD THAT EXPECTS XFrame, not frame!!!");
                        System.out.println("LoadDocumentOperation: InternalThread: run: ********************************************************************");
                        this.document = documentService.loadDocument(LoadDocumentOperation.this.frame, LoadDocumentOperation.this.url.toString(), LoadDocumentOperation.this.documentDescriptor);
                        System.out.println("LoadDocumentOperation: InternalThread: run: *************************************************");
                        System.out.println("LoadDocumentOperation: InternalThread: run: POST2 - loaded a document from url into the frame");
                        System.out.println("LoadDocumentOperation: InternalThread: run: *************************************************");
                        System.out.println("LoadDocumentOperation: InternalThread: run: frame:                           " + LoadDocumentOperation.this.frame.toString());
                        System.out.println("LoadDocumentOperation: InternalThread: run: frame.getXFrame():               " + LoadDocumentOperation.this.frame.getXFrame().toString());
                        System.out.println("LoadDocumentOperation: InternalThread: run: document.getFrame():             " + this.document.getFrame().toString());
                        System.out.println("LoadDocumentOperation: InternalThread: run: document.getFrame().getXFrame(): " + this.document.getFrame().getXFrame().toString());
                        System.out.println("LoadDocumentOperation: InternalThread: run: document.getDocumentType():      " + this.document.getDocumentType());
                        System.out.println("LoadDocumentOperation: InternalThread: run: document.getLocationURL():       " + this.document.getLocationURL().toString());
                        System.out.println("LoadDocumentOperation: InternalThread: run: documentDescriptor.getURL():     " + LoadDocumentOperation.this.documentDescriptor.getURL());
                        System.out.println("LoadDocumentOperation: InternalThread: run: documentDescriptor.getTitle():   " + LoadDocumentOperation.this.documentDescriptor.getTitle());
                        layoutManager.hideAll();
                        layoutManager.showElement("private:resource/menubar/menubar");
                        layoutManager.showElement("private:resource/statusbar/statusbar");
                        layoutManager.showElement("private:resource/toolbar/standardbar");
                        layoutManager.showElement("private:resource/toolbar/textobjectbar");
                        xLayoutManager.dockAllWindows((short)5);
                        xLayoutManager.dockAllWindows((short)3);
                        xLayoutManager.dockAllWindows((short)1);
                        xLayoutManager.dockAllWindows((short)2);
                        xLayoutManager.dockAllWindows((short)4);
                        xLayoutManager.dockAllWindows((short)6);
                        xLayoutManager.dockAllWindows((short)0);
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: PRE2 FALLBACK - about to load a document from url NOT into a frame, but into a new window");
                        this.document = LoadDocumentOperation.this.officeApplication.getDocumentService().loadDocument(LoadDocumentOperation.this.url.toString(), LoadDocumentOperation.this.documentDescriptor);
                        System.out.println("LoadDocumentOperation: InternalThread: run: POST2 FALLBACK - loaded a document from url NOT into a frame, but into a new window");
                    }
                    System.out.println("LoadDocumentOperation: InternalThread: run: Status after loadDocument()...");
                    if (this.document == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: document==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: document=" + this.document.toString());
                    }
                }
                System.out.println("LoadDocumentOperation: InternalThread: run: ...work has been done.");
                this.done = true;
            }
            catch (Exception exception) {
                System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: Caught exception!");
                this.exception = exception;
            }
            catch (ThreadDeath threadDeath) {
                System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: Caught threadDeath!");
            }
            System.out.println("LoadDocumentOperation: InternalThread: run: ends");
        }

        public Exception getException() {
            return this.exception;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public boolean done() {
            if (this.exception != null) {
                return true;
            }
            return this.done;
        }
    }
}

