/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.test;

import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.application.OfficeApplicationRuntime;
import ag.ion.bion.officelayer.document.DocumentDescriptor;
import ag.ion.bion.officelayer.text.ITextDocument;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class RemoteWriteTest
extends TestCase {
    private static Logger LOGGER = Logger.getLogger("ag.ion");

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("NOA Remote Write Test");
            System.out.println("-------------------");
            System.out.println("Usage:");
            System.out.println("RemoteWriteTest <host> <port>");
        } else {
            LogManager.getLogManager().reset();
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.FINEST);
            LOGGER.addHandler(consoleHandler);
            LOGGER.setLevel(Level.FINEST);
            try {
                FileHandler fileHandler = new FileHandler("log.xml");
                fileHandler.setLevel(Level.FINEST);
                LOGGER.addHandler(fileHandler);
            }
            catch (Throwable fileHandler) {
                // empty catch block
            }
            RemoteWriteTest remoteWriteTest = new RemoteWriteTest();
            remoteWriteTest.test(args[0], args[1]);
        }
    }

    public void testOfficeBean() {
        RemoteWriteTest remoteWriteTest = new RemoteWriteTest();
        remoteWriteTest.test("localhost", "8101");
    }

    public void test(String host, String port) {
        System.out.println("NOA Remote Write Test");
        System.out.println("Host: " + host);
        System.out.println("Port: " + port);
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("type", "remote");
        hashMap.put("host", host);
        hashMap.put("port", port);
        try {
            IOfficeApplication officeApplication = OfficeApplicationRuntime.getApplication(hashMap);
            officeApplication.activate();
            System.out.println("Constructing a new writer document ...");
            ITextDocument textDocument = (ITextDocument)officeApplication.getDocumentService().constructNewDocument("Text Document", DocumentDescriptor.DEFAULT_HIDDEN);
            System.out.println("Inserting text into the new writer document ...");
            textDocument.getTextService().getText().setText("This is a NOA test.");
            System.out.println("Storing new writer document ...");
            textDocument.getPersistenceService().store(new FileOutputStream("noatest.odt"));
            textDocument.close();
            officeApplication.deactivate();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("NOA Remote Write Test successfully.");
    }
}

