/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.internal.text;

import ag.ion.bion.officelayer.util.Assert;
import ag.ion.noa.internal.text.DocumentIndex;
import ag.ion.noa.text.IDocumentIndex;
import ag.ion.noa.text.IDocumentIndexService;
import com.sun.star.container.XIndexAccess;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;

public class DocumentIndexService
implements IDocumentIndexService {
    private XTextDocument textDocument = null;

    public DocumentIndexService(XTextDocument textDocument) {
        Assert.isNotNull(textDocument, XTextDocument.class, this);
        this.textDocument = textDocument;
    }

    @Override
    public IDocumentIndex[] getDocumentIndexes() {
        XDocumentIndexesSupplier documentIndexesSupplier = (XDocumentIndexesSupplier)UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)this.textDocument);
        if (documentIndexesSupplier == null) {
            return new IDocumentIndex[0];
        }
        XIndexAccess indexAccess = documentIndexesSupplier.getDocumentIndexes();
        ArrayList<DocumentIndex> list = new ArrayList<DocumentIndex>();
        int i = 0;
        int n = indexAccess.getCount();
        while (i < n) {
            try {
                Object object = indexAccess.getByIndex(i);
                XDocumentIndex documentIndex = (XDocumentIndex)UnoRuntime.queryInterface(XDocumentIndex.class, (Object)object);
                if (documentIndex != null) {
                    list.add(new DocumentIndex(documentIndex));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return list.toArray(new IDocumentIndex[list.size()]);
    }
}

