/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.internal.document;

import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.util.Assert;
import ag.ion.noa.document.ISearchService;
import ag.ion.noa.internal.search.SearchResult;
import ag.ion.noa.search.ISearchDescriptor;
import ag.ion.noa.search.ISearchResult;
import com.sun.star.container.XIndexAccess;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.util.XSearchable;

public class SearchService
implements ISearchService {
    private IDocument document = null;
    private XSearchable xSearchable = null;
    private boolean supportFindAll = true;

    public SearchService(IDocument document, XSearchable xSearchable) {
        Assert.isNotNull(xSearchable, XSearchable.class, this);
        Assert.isNotNull(document, IDocument.class, this);
        this.xSearchable = xSearchable;
        this.document = document;
    }

    @Override
    public ISearchResult findFirst(ISearchDescriptor searchDescriptor) {
        if (searchDescriptor == null || searchDescriptor.getSearchContent() == null) {
            return new SearchResult(this.document);
        }
        Object object = this.xSearchable.findFirst(this.toXSearchDescriptor(searchDescriptor));
        if (object == null) {
            return new SearchResult(this.document);
        }
        return new SearchResult(this.document, (XInterface)object);
    }

    @Override
    public ISearchResult findAll(ISearchDescriptor searchDescriptor) {
        if (searchDescriptor == null || searchDescriptor.getSearchContent() == null) {
            return new SearchResult(this.document);
        }
        XIndexAccess xIndexAccess = this.xSearchable.findAll(this.toXSearchDescriptor(searchDescriptor));
        return new SearchResult(this.document, xIndexAccess);
    }

    @Override
    public boolean supportsFindAll() {
        return this.supportFindAll;
    }

    protected XSearchDescriptor toXSearchDescriptor(ISearchDescriptor searchDescriptor) {
        XSearchDescriptor xSearchDescriptor = this.xSearchable.createSearchDescriptor();
        xSearchDescriptor.setSearchString(searchDescriptor.getSearchContent());
        if (searchDescriptor.isCaseSensitive()) {
            try {
                xSearchDescriptor.setPropertyValue("SearchCaseSensitive", (Object)Boolean.TRUE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (searchDescriptor.useCompleteWords()) {
            try {
                xSearchDescriptor.setPropertyValue("SearchWords", (Object)Boolean.TRUE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (searchDescriptor.useRegularExpression()) {
            try {
                xSearchDescriptor.setPropertyValue("SearchRegularExpression", (Object)Boolean.TRUE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (searchDescriptor.useSimilaritySearch()) {
            try {
                xSearchDescriptor.setPropertyValue("SearchSimilarity", (Object)Boolean.TRUE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return xSearchDescriptor;
    }
}

