/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.internal.text.table.Argument;
import ag.ion.bion.officelayer.internal.text.table.Arguments;
import ag.ion.bion.officelayer.internal.text.table.BracketElement;
import ag.ion.bion.officelayer.internal.text.table.CalculateFormula;
import ag.ion.bion.officelayer.internal.text.table.ITextTableFormulaElement;
import ag.ion.bion.officelayer.internal.text.table.MaxMinElement;
import ag.ion.bion.officelayer.internal.text.table.MeanElement;
import ag.ion.bion.officelayer.internal.text.table.TextTableCellReferencesService;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaExpression;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.IArgument;
import ag.ion.bion.officelayer.text.table.IFormula;
import ag.ion.bion.officelayer.text.table.ITextTableCellReferencesService;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;
import java.util.ArrayList;

public class TextTableFormula
implements IFormula {
    public static final String PI = "PI";
    public static final String E = "E";
    public static final String PLUS = "+";
    public static final String MINUS = "-";
    public static final String DIVIDE = "/";
    public static final String MULTIPLY = "*";
    public static final String ROUND = "round";
    public static final String PERCENT = "phd";
    public static final String SQRT = "sqrt";
    public static final String POW = "pow";
    public static final String MEAN = "mean";
    public static final String[] operators = new String[]{"+", "-", "/", "*", "round", "phd", "sqrt", "pow", "mean"};
    private final String EQUAL = "eq";
    private final String NOTEQUAL = "neq";
    private final String LOWEREQUAL = "leq";
    private final String GREATEREQUAL = "geq";
    private final String LOWER = "l";
    private final String GREATER = "g";
    private final String OR = "or";
    private final String XOR = "xor";
    private final String AND = "and";
    private final String NOT = "not";
    private final String MIN = "min";
    private final String MAX = "max";
    private final String SIN = "sin";
    private final String COS = "cos";
    private final String TAN = "tan";
    private final String ASIN = "asin";
    private final String ACOS = "acos";
    private final String ATAN = "atan";
    private TextTableFormulaExpression textTableFormulaExpression = null;
    private Arguments arguments = null;
    private ITextTableCellReferencesService textTableCellReferencesService = null;
    private ArrayList elements = new ArrayList();

    public TextTableFormula(TextTableFormulaExpression textTableFormulaExpression) throws IllegalArgumentException {
        if (textTableFormulaExpression == null) {
            throw new IllegalArgumentException("Submitted formula is not valid");
        }
        this.textTableFormulaExpression = textTableFormulaExpression;
    }

    @Override
    public IArgument[] getArguments() {
        if (this.arguments == null) {
            this.arguments = new Arguments();
            this.parse();
        }
        return this.arguments.getArguments();
    }

    @Override
    public double calcFormula() throws TextException {
        try {
            if (this.arguments == null) {
                this.arguments = new Arguments();
                this.parse();
            }
            ITextTableFormulaElement[] formulaElements = new ITextTableFormulaElement[this.elements.size()];
            formulaElements = this.elements.toArray(formulaElements);
            return CalculateFormula.calculate(formulaElements, this.arguments, this.textTableFormulaExpression.getExpression());
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public ITextTableCellReferencesService getCellReferencesService() {
        if (this.textTableCellReferencesService == null) {
            this.textTableCellReferencesService = new TextTableCellReferencesService(this.textTableFormulaExpression);
        }
        return this.textTableCellReferencesService;
    }

    @Override
    public String getExpression() {
        return this.textTableFormulaExpression.getExpression();
    }

    private void parse() {
        this.getMaxMin(true, this.textTableFormulaExpression.getExpression(), 0);
        this.getMaxMin(false, this.textTableFormulaExpression.getExpression(), 0);
        this.findArguments(this.textTableFormulaExpression.getExpression());
        this.replacePipes();
        this.replaceMean();
        this.analyseBrackets(this.textTableFormulaExpression.getExpression(), this.elements);
    }

    private void findArguments(String formulaArgument) {
        int posStart = formulaArgument.indexOf("<");
        int posEnd = formulaArgument.indexOf(">");
        if (posStart != -1 && posEnd != -1) {
            String argumentBez = formulaArgument.substring(posStart, posEnd + 1);
            if (argumentBez.indexOf(":") != -1) {
                String[] help = argumentBez.substring(1, argumentBez.length() - 1).split(":");
                String helpString = this.getRangeArguments(help[0], help[1], this.arguments);
                this.textTableFormulaExpression.setExpression(this.textTableFormulaExpression.getExpression().replaceFirst(argumentBez, helpString));
            } else if (argumentBez.indexOf("|") != -1) {
                String pipe = this.replacePipe(argumentBez);
                int index = this.textTableFormulaExpression.getExpression().indexOf(argumentBez);
                this.textTableFormulaExpression.setExpression(String.valueOf(this.textTableFormulaExpression.getExpression().substring(0, index)) + "(" + pipe + ")" + this.textTableFormulaExpression.getExpression().substring(index + argumentBez.length()));
            } else {
                Argument argument = new Argument(argumentBez);
                argument.setCellReference(true);
                if (this.arguments.getArgument(argument.getName()) == null) {
                    this.arguments.addArgument(argument);
                }
            }
            String helpFormula = formulaArgument.substring(posEnd + 1);
            this.findArguments(helpFormula);
        }
    }

    private String getRangeArguments(String firstArguments, String secondArgument, Arguments arguments) {
        StringBuffer argumentStringBuffer = new StringBuffer();
        String startString = this.getArgumentCellName(firstArguments);
        String endString = this.getArgumentCellName(secondArgument);
        String helpString = startString;
        int rowStartNumber = this.getRowNumber(firstArguments);
        int rowEndNumber = this.getRowNumber(secondArgument);
        int rowHelpNumber = rowStartNumber;
        Argument argument = new Argument("<" + startString + rowStartNumber + ">");
        argument.setCellReference(true);
        arguments.addArgument(argument);
        argumentStringBuffer.append("(" + argument.getName());
        boolean first = true;
        boolean finish = false;
        do {
            if (rowHelpNumber != rowStartNumber || !startString.equals(endString) && !first) {
                argument = new Argument("<" + helpString + rowHelpNumber + ">");
                argument.setCellReference(true);
                if (arguments.getArgument(argument.getName()) == null) {
                    arguments.addArgument(argument);
                }
                argumentStringBuffer.append(" + " + argument.getName());
            }
            first = false;
            if (helpString.equals(endString)) {
                helpString = startString;
                if (rowHelpNumber < rowEndNumber) {
                    ++rowHelpNumber;
                    continue;
                }
                finish = true;
                continue;
            }
            if (startString.equals(endString)) continue;
            helpString = TextTableCellNameHelper.getNextColumnName(helpString);
        } while (!finish);
        argumentStringBuffer.append(")");
        return argumentStringBuffer.toString();
    }

    private String getArgumentCellName(String argument) {
        int pos = -1;
        int i = 0;
        while (i < argument.length()) {
            if (Character.isDigit(argument.charAt(i))) break;
            pos = i++;
        }
        return argument.substring(0, pos + 1);
    }

    private int getRowNumber(String argument) {
        int pos = -1;
        int i = 0;
        while (i < argument.length()) {
            if (Character.isDigit(argument.charAt(i))) {
                pos = i;
            }
            ++i;
        }
        return new Integer(argument.substring(pos));
    }

    private void analyseBrackets(String formulaBracket, ArrayList bracketElements) {
        int startPos = formulaBracket.indexOf(40);
        int endPos = -1;
        if (startPos == -1) {
            return;
        }
        int countBrackets = 1;
        int i = startPos + 1;
        while (i < formulaBracket.length()) {
            if ((countBrackets = this.getEndPos(formulaBracket, countBrackets, i, '(', ')')) == 0) {
                endPos = i;
                break;
            }
            ++i;
        }
        if (endPos != -1) {
            BracketElement bracketElement = new BracketElement(formulaBracket.substring(startPos, endPos + 1));
            this.appendArguments(bracketElement.getFormula(), bracketElement);
            ArrayList internalBracketElements = new ArrayList();
            this.analyseBrackets(formulaBracket.substring(startPos + 1, endPos), internalBracketElements);
            BracketElement[] elements = new BracketElement[internalBracketElements.size()];
            bracketElement.setBracketElements(internalBracketElements.toArray(elements));
            bracketElements.add(bracketElement);
            this.analyseBrackets(formulaBracket.substring(endPos), bracketElements);
        }
    }

    private void appendArguments(String formula, ITextTableFormulaElement formulaElement) {
        int startPos = formula.indexOf("<");
        int endPos = formula.indexOf(">");
        if (startPos != -1 && endPos != -1) {
            formulaElement.addArgument(this.arguments.getArgument(formula.substring(startPos, endPos + 1)));
            this.appendArguments(formula.substring(endPos + 1), formulaElement);
        }
    }

    private String replacePipe(String argumentBez) {
        String help1 = String.valueOf(argumentBez.substring(0, argumentBez.indexOf("|"))) + ">";
        String help2 = "<" + argumentBez.substring(argumentBez.indexOf("|") + 1);
        String returnString = "";
        Argument argument = new Argument(help1);
        argument.setCellReference(true);
        if (this.arguments.getArgument(argument.getName()) == null) {
            this.arguments.addArgument(argument);
        }
        returnString = help1;
        if (help2.indexOf("|") != -1) {
            returnString = String.valueOf(returnString) + PLUS + this.replacePipe(help2);
        } else {
            argument = new Argument(help2);
            argument.setCellReference(true);
            if (this.arguments.getArgument(argument.getName()) == null) {
                this.arguments.addArgument(argument);
            }
            returnString = String.valueOf(returnString) + PLUS + help2;
        }
        return returnString;
    }

    private void replacePipes() {
        String formula = this.textTableFormulaExpression.getExpression();
        int index = formula.indexOf(124);
        boolean found = false;
        if (index != -1) {
            do {
                if ((index = (formula = String.valueOf(formula.substring(0, index)) + PLUS + formula.substring(index + 1)).indexOf(124)) != -1) continue;
                found = true;
            } while (!found);
            this.textTableFormulaExpression.setExpression(formula);
        }
    }

    private int getEndPos(String formulaBracket, int countBrackets, int i, char firstBracket, char lastBracket) {
        if (formulaBracket.charAt(i) == firstBracket) {
            ++countBrackets;
        } else if (formulaBracket.charAt(i) == lastBracket) {
            --countBrackets;
        }
        return countBrackets;
    }

    private void replaceMean() {
        String formula = this.textTableFormulaExpression.getExpression();
        int index = formula.indexOf(MEAN);
        String help = formula.substring(index + MEAN.length());
        int endPos = formula.length();
        if (index != -1) {
            if (index > 0 && formula.charAt(index - 1) == '(') {
                int countBrackets = 1;
                int i = index;
                while (i < formula.length()) {
                    if ((countBrackets = this.getEndPos(formula, countBrackets, i, '(', ')')) == 0) {
                        endPos = i;
                        break;
                    }
                    ++i;
                }
                help = formula.substring(index + MEAN.length(), endPos);
            }
            MeanElement meanElement = new MeanElement(help);
            formula = String.valueOf(formula.substring(0, index)) + meanElement.replace() + formula.substring(endPos);
        }
        this.textTableFormulaExpression.setExpression(formula);
    }

    private void getMaxMin(boolean maximum, String formula, int formulaIndex) {
        int index;
        String maxMin = "max";
        boolean found = false;
        int helpIndex = 0;
        Arguments maxArguments = new Arguments();
        if (!maximum) {
            maxMin = "min";
        }
        if ((index = formula.indexOf(maxMin)) != -1) {
            Argument argument;
            Argument argument2;
            int m;
            int j;
            Argument[] argumentsArray;
            String[] helpArray;
            MaxMinElement maxMinElement = new MaxMinElement(String.valueOf(maxMin) + (index + formulaIndex), maximum);
            String help = formula.substring(index + maxMin.length());
            int oldIndex = 0;
            int i = 0;
            while (i < help.length()) {
                if (help.charAt(i) == '|') {
                    helpIndex = maxMin.length() + (help.lastIndexOf("|") + help.substring(help.lastIndexOf("|")).indexOf(">")) + 1;
                    found = true;
                    String helpString = help.substring(oldIndex, i).trim();
                    if (helpString.indexOf("<") != -1) {
                        if ((helpString = helpString.substring(helpString.indexOf("<"), helpString.indexOf(">") + 1).trim()).indexOf(":") != -1) {
                            helpArray = helpString.substring(1, helpString.length() - 1).split(":");
                            this.getRangeArguments(helpArray[0], helpArray[1], maxArguments);
                            argumentsArray = (Argument[])maxArguments.getArguments();
                            j = 0;
                            m = argumentsArray.length;
                            while (j < m) {
                                if (this.arguments.getArgument(argumentsArray[j].getName()) == null) {
                                    this.arguments.addArgument(argumentsArray[j]);
                                } else {
                                    maxArguments.addArgument(this.arguments.getArgument(argumentsArray[j].getName()));
                                }
                                ++j;
                            }
                        } else {
                            argument2 = new Argument(helpString);
                            argument2.setCellReference(true);
                            maxArguments.addArgument(argument2);
                            if (this.arguments.getArgument(argument2.getName()) == null) {
                                this.arguments.addArgument(argument2);
                            } else {
                                maxArguments.addArgument(this.arguments.getArgument(argument2.getName()));
                            }
                        }
                    } else {
                        argument2 = this.getDigitArgument(helpString, i);
                        maxArguments.addArgument(argument2);
                        helpIndex = helpIndex + help.indexOf(new Double(argument2.getValue()).toString()) + new Double(argument2.getValue()).toString().length();
                    }
                    oldIndex = i;
                }
                ++i;
            }
            String helpString = help.substring(oldIndex).trim();
            if (helpString.indexOf("|") != -1) {
                found = true;
                if (helpString.indexOf("<") != -1) {
                    if ((helpString = helpString.substring(helpString.indexOf("|") + 1, helpString.indexOf(">") + 1)).indexOf(":") != -1) {
                        String[] helpArray2 = helpString.substring(1, helpString.length() - 1).split(":");
                        this.getRangeArguments(helpArray2[0], helpArray2[1], maxArguments);
                        Argument[] argumentsArray2 = (Argument[])maxArguments.getArguments();
                        int j2 = 0;
                        int m2 = argumentsArray2.length;
                        while (j2 < m2) {
                            if (this.arguments.getArgument(argumentsArray2[j2].getName()) == null) {
                                this.arguments.addArgument(argumentsArray2[j2]);
                            } else {
                                maxArguments.addArgument(this.arguments.getArgument(argumentsArray2[j2].getName()));
                            }
                            ++j2;
                        }
                    } else {
                        argument = new Argument(helpString);
                        argument.setCellReference(true);
                        maxArguments.addArgument(argument);
                        if (this.arguments.getArgument(argument.getName()) == null) {
                            this.arguments.addArgument(argument);
                        } else {
                            maxArguments.addArgument(this.arguments.getArgument(argument.getName()));
                        }
                    }
                } else {
                    helpString = helpString.substring(helpString.indexOf("|") + 1);
                    argument = this.getDigitArgument(helpString, index);
                    helpIndex = helpIndex + help.indexOf(new Double(argument.getValue()).toString()) + new Double(argument.getValue()).toString().length();
                    maxArguments.addArgument(argument);
                }
            }
            if (!found) {
                if (help.trim().startsWith("<")) {
                    String argumentBez = help.substring(help.indexOf("<"), help.indexOf(">") + 1);
                    helpIndex = maxMin.length() + argumentBez.length();
                    if (argumentBez.indexOf(":") != -1) {
                        helpArray = argumentBez.substring(1, argumentBez.length() - 1).split(":");
                        this.getRangeArguments(helpArray[0], helpArray[1], maxArguments);
                        argumentsArray = (Argument[])maxArguments.getArguments();
                        j = 0;
                        m = argumentsArray.length;
                        while (j < m) {
                            if (this.arguments.getArgument(argumentsArray[j].getName()) == null) {
                                this.arguments.addArgument(argumentsArray[j]);
                            } else {
                                maxArguments.addArgument(this.arguments.getArgument(argumentsArray[j].getName()));
                            }
                            ++j;
                        }
                    } else {
                        argument2 = new Argument(helpString);
                        argument2.setCellReference(true);
                        maxArguments.addArgument(argument2);
                        if (this.arguments.getArgument(argument2.getName()) == null) {
                            this.arguments.addArgument(argument2);
                        } else {
                            maxArguments.addArgument(this.arguments.getArgument(argument2.getName()));
                        }
                    }
                } else {
                    argument = this.getDigitArgument(help, index);
                    if (argument == null) {
                        return;
                    }
                    maxArguments.addArgument(argument);
                    helpIndex = helpIndex + help.indexOf(new Double(argument.getValue()).toString()) + new Double(argument.getValue()).toString().length();
                }
            }
            maxMinElement.setArguments(maxArguments);
            this.elements.add(maxMinElement);
            this.textTableFormulaExpression.setExpression(String.valueOf(this.textTableFormulaExpression.getExpression().substring(0, formulaIndex + index)) + maxMin + (index + formulaIndex) + this.textTableFormulaExpression.getExpression().substring(formulaIndex + index + helpIndex));
            this.getMaxMin(maximum, help, formulaIndex + helpIndex);
        }
    }

    private Argument getDigitArgument(String helpString, int index) {
        Argument argument = null;
        if (!Character.isDigit(helpString.trim().charAt(0))) {
            return null;
        }
        int i = 0;
        while (i < helpString.length()) {
            if (Character.isDigit(helpString.charAt(i))) {
                String help = new Character(helpString.charAt(i)).toString();
                int j = i + 1;
                while (j < helpString.length()) {
                    if (Character.isDigit(helpString.charAt(j))) {
                        help = String.valueOf(help) + new Character(helpString.charAt(j)).toString();
                    } else if (helpString.charAt(j) == ',') {
                        help = String.valueOf(help) + ".";
                    } else if (helpString.charAt(j) == '.') {
                        help = String.valueOf(help) + ".";
                    } else if (helpString.charAt(j) != '.') break;
                    ++j;
                }
                argument = new Argument("MAXMINDIGIT" + index);
                argument.setValue(helpString);
                i = i + helpString.length() - 1;
                break;
            }
            ++i;
        }
        return argument;
    }
}

