/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.text.AbstractTextComponent;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextDocumentImage;
import ag.ion.noa.graphic.GraphicInfo;
import com.sun.star.container.XNamed;
import com.sun.star.text.XTextContent;
import com.sun.star.uno.UnoRuntime;

public class TextDocumentImage
extends AbstractTextComponent
implements ITextDocumentImage {
    private GraphicInfo graphicInfo = null;
    private XTextContent xTextContent = null;

    public TextDocumentImage(ITextDocument textDocument, XTextContent xTextContent, GraphicInfo graphicInfo) throws IllegalArgumentException {
        super(textDocument);
        if (xTextContent == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XTextContent interface is not valid.");
        }
        if (graphicInfo == null) {
            throw new IllegalArgumentException("Submitted graphic information is not valid.");
        }
        this.xTextContent = xTextContent;
        this.graphicInfo = graphicInfo;
    }

    @Override
    public XTextContent getXTextContent() {
        return this.xTextContent;
    }

    @Override
    public GraphicInfo getGraphicInfo() {
        return this.graphicInfo;
    }

    @Override
    public String getName() {
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)this.getXTextContent());
        return xNamed.getName();
    }

    @Override
    public void setName(String name) {
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)this.getXTextContent());
        xNamed.setName(name);
    }
}

