/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.beans.IProperties;
import ag.ion.bion.officelayer.internal.beans.AbstractPropertyStore;
import ag.ion.bion.officelayer.text.ICharacterProperties;
import ag.ion.bion.officelayer.text.ICharacterPropertyStore;
import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.ITextCursor;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.awt.FontSlant;

public class CharacterPropertyStore
extends AbstractPropertyStore
implements ICharacterPropertyStore {
    private float fontSize = -1.0f;
    private boolean fontBold = false;
    private FontSlant fontItalic = null;
    private boolean fontUnderlined = false;
    private int fontColor = 0;
    private String fontName = null;
    private IProperties properties = null;

    public CharacterPropertyStore(IParagraph origin) throws TextException {
        ICharacterProperties characterProperties = origin.getCharacterProperties();
        this.properties = characterProperties;
        this.fillStorage(characterProperties);
    }

    public CharacterPropertyStore(ITextCursor origin) throws TextException {
        ICharacterProperties characterProperties = origin.getCharacterProperties();
        this.properties = characterProperties;
        this.fillStorage(characterProperties);
    }

    @Override
    public IProperties getProperties() {
        return this.properties;
    }

    @Override
    public float getFontSize() throws TextException {
        return this.fontSize;
    }

    @Override
    public void setFontSize(float fontSize) throws TextException {
        this.fontSize = fontSize;
    }

    @Override
    public boolean isFontBold() throws TextException {
        return this.fontBold;
    }

    @Override
    public void setFontBold(boolean param) throws TextException {
        this.fontBold = param;
    }

    @Override
    public boolean isFontItalic() throws TextException {
        if (this.fontItalic != null) {
            return this.fontItalic == FontSlant.ITALIC;
        }
        throw new TextException("Problems getting font italic");
    }

    @Override
    public void setFontItalic(boolean param) throws TextException {
        this.fontItalic = param ? FontSlant.ITALIC : FontSlant.NONE;
    }

    @Override
    public boolean isFontUnderlined() throws TextException {
        return this.fontUnderlined;
    }

    @Override
    public void setFontUnderline(boolean param) throws TextException {
        this.fontUnderlined = param;
    }

    @Override
    public int getFontColor() throws TextException {
        return this.fontColor;
    }

    @Override
    public void setFontColor(int color) throws TextException {
        this.fontColor = color;
    }

    @Override
    public String getFontName() throws TextException {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) throws TextException {
        this.fontName = fontName;
    }

    private void fillStorage(ICharacterProperties properties) throws TextException {
        this.fontColor = properties.getFontColor();
        this.fontBold = properties.isFontBold();
        boolean isItalic = properties.isFontItalic();
        this.fontItalic = isItalic ? FontSlant.ITALIC : FontSlant.NONE;
        this.fontUnderlined = properties.isFontUnderlined();
        this.fontSize = properties.getFontSize();
        this.fontName = properties.getFontName();
    }
}

