/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.Bookmark;
import ag.ion.bion.officelayer.text.IBookmark;
import ag.ion.bion.officelayer.text.IBookmarkService;
import ag.ion.bion.officelayer.text.ITextDocument;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;

public class BookmarkService
implements IBookmarkService {
    private ITextDocument textDocument = null;

    public BookmarkService(ITextDocument textDocument) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        this.textDocument = textDocument;
    }

    @Override
    public IBookmark[] getBookmarks() {
        try {
            XBookmarksSupplier xBookmarksSupplier = (XBookmarksSupplier)UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.textDocument.getXTextDocument());
            if (xBookmarksSupplier == null) {
                return new IBookmark[0];
            }
            XNameAccess nameAccess = xBookmarksSupplier.getBookmarks();
            String[] names = nameAccess.getElementNames();
            if (names.length < 1) {
                return new IBookmark[0];
            }
            ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
            int i = 0;
            while (i < names.length) {
                XTextRange xBookmarkRange;
                Object bookmark = nameAccess.getByName(names[i]);
                XTextContent xBookmarkContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)bookmark);
                XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)bookmark);
                if (xBookmarkContent != null && (xBookmarkRange = xBookmarkContent.getAnchor()) != null) {
                    bookmarks.add(new Bookmark(this.textDocument, xBookmarkRange, xNamed));
                }
                ++i;
            }
            return bookmarks.toArray(new IBookmark[bookmarks.size()]);
        }
        catch (Exception exception) {
            return new IBookmark[0];
        }
    }

    @Override
    public IBookmark getBookmark(String name) {
        XTextRange xBookmarkRange;
        XNamed xNamed;
        block9: {
            XTextContent xBookmarkContent;
            block8: {
                XBookmarksSupplier xBookmarksSupplier;
                block7: {
                    block6: {
                        try {
                            if (name != null) break block6;
                            return null;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    xBookmarksSupplier = (XBookmarksSupplier)UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.textDocument.getXTextDocument());
                    if (xBookmarksSupplier != null) break block7;
                    return null;
                }
                Object bookmark = xBookmarksSupplier.getBookmarks().getByName(name);
                xBookmarkContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)bookmark);
                xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)bookmark);
                if (xBookmarkContent != null) break block8;
                return null;
            }
            xBookmarkRange = xBookmarkContent.getAnchor();
            if (xBookmarkRange != null) break block9;
            return null;
        }
        return new Bookmark(this.textDocument, xBookmarkRange, xNamed);
    }
}

