/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.document;

import ag.ion.bion.officelayer.desktop.IFrame;
import ag.ion.bion.officelayer.document.DocumentException;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.document.IPersistenceService;
import ag.ion.bion.officelayer.event.ICloseListener;
import ag.ion.bion.officelayer.event.IDocumentEvent;
import ag.ion.bion.officelayer.event.IDocumentListener;
import ag.ion.bion.officelayer.event.IDocumentModifyListener;
import ag.ion.bion.officelayer.event.IEvent;
import ag.ion.bion.officelayer.form.IFormService;
import ag.ion.bion.officelayer.internal.desktop.Frame;
import ag.ion.bion.officelayer.internal.document.PersistenceService;
import ag.ion.bion.officelayer.internal.event.CloseListenerWrapper;
import ag.ion.bion.officelayer.internal.event.DocumentEvent;
import ag.ion.bion.officelayer.internal.event.DocumentListenerWrapper;
import ag.ion.bion.officelayer.internal.event.DocumentModifyListenerWrapper;
import ag.ion.bion.officelayer.internal.form.FormService;
import ag.ion.noa.NOAException;
import ag.ion.noa.document.IFilterProvider;
import ag.ion.noa.internal.document.DefaultFilterProvider;
import ag.ion.noa.internal.printing.PrintService;
import ag.ion.noa.internal.script.ScriptingService;
import ag.ion.noa.printing.IPrintService;
import ag.ion.noa.script.IScriptingService;
import ag.ion.noa.service.IServiceProvider;
import ag.ion.noa.text.IXInterfaceObjectSelection;
import ag.ion.noa.view.ISelection;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.document.EventObject;
import com.sun.star.document.XEventBroadcaster;
import com.sun.star.document.XEventListener;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCloseListener;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XModifiable;
import com.sun.star.util.XModifyBroadcaster;
import com.sun.star.util.XModifyListener;
import com.sun.star.view.XSelectionSupplier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractDocument
implements IDocument {
    protected XComponent xComponent = null;
    private PropertyValue[] initialProperties = null;
    private IServiceProvider serviceProvider = null;
    private IPersistenceService persistenceService = null;
    private DocumentListenerWrapper documentListenerWrapper = null;
    private IScriptingService scriptingService = null;
    private IFilterProvider filterProvider = null;
    private IPrintService printService = null;
    private List documentListenerList = null;
    private Hashtable modifyListenerTable = null;
    private Hashtable closeListeners = null;
    private boolean isModified = false;

    public AbstractDocument(XComponent xComponent, PropertyValue[] initialProperties) throws IllegalArgumentException {
        if (xComponent == null) {
            throw new IllegalArgumentException("The submitted OpenOffice.org XComponent interface is not valid.");
        }
        this.xComponent = xComponent;
        this.initialProperties = initialProperties;
        this.documentListenerWrapper = new DocumentListenerWrapper(new DocumentListener(), this.getServiceProvider());
        this.addEventListener(this.documentListenerWrapper);
    }

    @Override
    public XComponent getXComponent() {
        return this.xComponent;
    }

    public XFrame getXFrame() {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.getXComponent());
        XController xController = xModel.getCurrentController();
        return xController.getFrame();
    }

    @Override
    public IFrame getFrame() {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.getXComponent());
        XController xController = xModel.getCurrentController();
        XFrame xFrame = xController.getFrame();
        return new Frame(xFrame, this.getServiceProvider());
    }

    @Override
    public IPersistenceService getPersistenceService() {
        if (this.persistenceService == null) {
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xComponent);
            this.persistenceService = new PersistenceService(this, xStorable);
        }
        return this.persistenceService;
    }

    @Override
    public IScriptingService getScriptingService() {
        if (this.scriptingService == null) {
            this.scriptingService = new ScriptingService(this);
        }
        return this.scriptingService;
    }

    @Override
    public IFilterProvider getFilterProvider() {
        if (this.filterProvider == null) {
            this.filterProvider = new DefaultFilterProvider(this);
        }
        return this.filterProvider;
    }

    @Override
    public IFormService getFormService() {
        XDrawPage drawPage;
        XDrawPageSupplier drawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this.xComponent);
        if (drawPageSupplier != null && (drawPage = drawPageSupplier.getDrawPage()) != null) {
            return new FormService(this, drawPage);
        }
        return null;
    }

    @Override
    public void addDocumentModifyListener(IDocumentModifyListener documentModifyListener) {
        DocumentModifyListenerWrapper documentListenerWrapper = new DocumentModifyListenerWrapper(documentModifyListener, this.getServiceProvider());
        this.addModifyListener(documentListenerWrapper);
        if (this.modifyListenerTable == null) {
            this.modifyListenerTable = new Hashtable();
        }
        this.modifyListenerTable.put(documentModifyListener, documentListenerWrapper);
    }

    @Override
    public void addDocumentListener(IDocumentListener documentListener) {
        if (documentListener == null) {
            return;
        }
        if (this.documentListenerList == null) {
            this.documentListenerList = new ArrayList();
        }
        if (!this.documentListenerList.contains(documentListener)) {
            this.documentListenerList.add(documentListener);
        }
    }

    @Override
    public void removeDocumentModifyListener(IDocumentModifyListener documentModifyListener) {
        DocumentModifyListenerWrapper documentModifyListenerWrapper;
        if (this.modifyListenerTable != null && this.modifyListenerTable.containsKey(documentModifyListener) && (documentModifyListenerWrapper = (DocumentModifyListenerWrapper)this.modifyListenerTable.get(documentModifyListener)) != null) {
            this.removeModifyListener(documentModifyListenerWrapper);
        }
    }

    @Override
    public void removeDocumentListener(IDocumentListener documentListener) {
        if (documentListener == null) {
            return;
        }
        if (this.documentListenerList == null) {
            return;
        }
        if (this.documentListenerList.contains(documentListener)) {
            this.documentListenerList.remove(documentListener);
        }
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void setModified(boolean modified) throws DocumentException {
        try {
            XModifiable xModifiable = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)this.xComponent);
            xModifiable.setModified(modified);
        }
        catch (Throwable throwable) {
            throw new DocumentException(throwable);
        }
    }

    @Override
    public URL getLocationURL() throws DocumentException {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xComponent);
        String documentURL = xModel.getURL();
        if (documentURL == null) {
            return null;
        }
        try {
            URL url = new URL(documentURL);
            return url;
        }
        catch (Throwable throwable) {
            throw new DocumentException(throwable);
        }
    }

    @Override
    public void addCloseListener(ICloseListener closeListener2) {
        XCloseable xCloseable;
        if (closeListener2 == null) {
            return;
        }
        if (this.closeListeners == null) {
            this.closeListeners = new Hashtable();
        }
        if ((xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.xComponent)) != null) {
            CloseListenerWrapper closeListenerWrapper = new CloseListenerWrapper(closeListener2, this.getServiceProvider());
            xCloseable.addCloseListener((XCloseListener)closeListenerWrapper);
            this.closeListeners.put(closeListener2, closeListenerWrapper);
        }
    }

    @Override
    public void removeCloseListener(ICloseListener closeListener2) {
        XCloseable xCloseable;
        CloseListenerWrapper closeListenerWrapper;
        if (closeListener2 == null) {
            return;
        }
        if (this.closeListeners == null) {
            return;
        }
        if (this.closeListeners.containsKey(closeListener2) && (closeListenerWrapper = (CloseListenerWrapper)this.closeListeners.get(closeListener2)) != null && (xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.xComponent)) != null) {
            xCloseable.removeCloseListener((XCloseListener)closeListenerWrapper);
        }
    }

    @Override
    public boolean isOpen() {
        if (this.xComponent != null) {
            try {
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xComponent);
                if (xModel != null) {
                    xModel.getURL();
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        long millis = 50L;
        this.removeDocumentListeners();
        this.removeModifyListeners();
        if (this.xComponent != null) {
            try {
                Thread.sleep(millis);
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xComponent);
                if (xModel != null) {
                    Thread.sleep(millis);
                    XModifiable xModify = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)xModel);
                    Thread.sleep(millis);
                    if (xModify.isModified()) {
                        xModify.setModified(false);
                    }
                    this.xComponent.dispose();
                    Thread.sleep(millis);
                } else {
                    XController xController = (XController)UnoRuntime.queryInterface(XController.class, (Object)this.xComponent);
                    Thread.sleep(millis);
                    if (xController != null && xController.suspend(true)) {
                        XFrame xFrame = xController.getFrame();
                        Thread.sleep(millis);
                        xFrame.dispose();
                    }
                }
            }
            catch (PropertyVetoException xModel) {
            }
            catch (DisposedException xModel) {
            }
            catch (RuntimeException xModel) {
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            this.removeCloseListeners();
        }
        catch (Exception ex) {
            System.out.println("Exception in 'removeCloseListener()' geworfen");
        }
    }

    private void addModifyListener(XModifyListener xModifyListener) {
        XModifyBroadcaster xModifyBroadcaster = (XModifyBroadcaster)UnoRuntime.queryInterface(XModifyBroadcaster.class, (Object)this.xComponent);
        if (xModifyBroadcaster != null) {
            xModifyBroadcaster.addModifyListener(xModifyListener);
        }
    }

    private void removeModifyListener(XModifyListener modifyListener) {
        XModifyBroadcaster xModifyBroadcaster = (XModifyBroadcaster)UnoRuntime.queryInterface(XModifyBroadcaster.class, (Object)this.xComponent);
        if (xModifyBroadcaster != null && modifyListener != null) {
            xModifyBroadcaster.removeModifyListener(modifyListener);
        }
    }

    private void addEventListener(XEventListener xEventListener) {
        XEventBroadcaster xEventBroadcaster = (XEventBroadcaster)UnoRuntime.queryInterface(XEventBroadcaster.class, (Object)this.xComponent);
        if (xEventBroadcaster != null) {
            xEventBroadcaster.addEventListener(xEventListener);
        }
    }

    private void removeEventListener(XEventListener xEventListener) {
        XEventBroadcaster xEventBroadcaster = (XEventBroadcaster)UnoRuntime.queryInterface(XEventBroadcaster.class, (Object)this.xComponent);
        if (xEventBroadcaster != null) {
            xEventBroadcaster.removeEventListener(xEventListener);
        }
    }

    @Override
    public void print() throws DocumentException {
        this.getPrintService().print();
    }

    @Override
    public IPrintService getPrintService() {
        if (this.printService == null) {
            this.printService = new PrintService(this);
        }
        return this.printService;
    }

    @Override
    public boolean equalsTo(IDocument compareDocument) {
        if (compareDocument == null) {
            return false;
        }
        return UnoRuntime.areSame((Object)this.xComponent, (Object)compareDocument.getXComponent());
    }

    @Override
    public void reformat() {
    }

    @Override
    public void update() {
    }

    @Override
    public void setSelection(ISelection selection) throws NOAException {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof IXInterfaceObjectSelection) {
            this.setXInterfaceObjectSelection((IXInterfaceObjectSelection)selection);
        }
    }

    @Override
    public void fireDocumentEvent(String documentEventName) {
        if (this.documentListenerList == null) {
            return;
        }
        DocumentEvent documentEvent = new DocumentEvent(new EventObject((Object)this.getXComponent(), documentEventName), this.getServiceProvider());
        int i = 0;
        int n = this.documentListenerList.size();
        while (i < n) {
            Object object = this.documentListenerList.get(i);
            if (object instanceof IDocumentListener) {
                IDocumentListener documentListener = (IDocumentListener)object;
                if (documentEventName.equalsIgnoreCase("OnNew")) {
                    documentListener.onNew(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnLoad")) {
                    documentListener.onLoad(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnLoadDone")) {
                    documentListener.onLoadDone(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnLoadFinished")) {
                    documentListener.onLoadFinished(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnSaveDone")) {
                    documentListener.onSaveDone(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnSaveFinished")) {
                    documentListener.onSaveFinished(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnSave")) {
                    documentListener.onSave(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnSaveAs")) {
                    documentListener.onSaveAs(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnSaveAsDone")) {
                    documentListener.onSaveAsDone(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnModifyChanged")) {
                    documentListener.onModifyChanged(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnMouseOver")) {
                    documentListener.onMouseOver(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnMouseOut")) {
                    documentListener.onMouseOut(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnFocus")) {
                    documentListener.onFocus(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnAlphaCharInput")) {
                    documentListener.onAlphaCharInput(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnNonAlphaCharInput")) {
                    documentListener.onNonAlphaCharInput(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnInsertDone")) {
                    documentListener.onInsertDone(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnInsertStart")) {
                    documentListener.onInsertStart(documentEvent);
                } else if (documentEventName.equalsIgnoreCase("OnUnload")) {
                    documentListener.onUnload(documentEvent);
                }
            }
            ++i;
        }
    }

    @Override
    public IServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(IServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
        this.documentListenerWrapper.setServiceProvider(serviceProvider);
    }

    @Override
    public PropertyValue[] getInitialProperties() {
        if (this.initialProperties == null) {
            return new PropertyValue[0];
        }
        return this.initialProperties;
    }

    protected void setXInterfaceObjectSelection(IXInterfaceObjectSelection interfaceObject) throws NOAException {
        XController xController;
        XSelectionSupplier selectionSupplier;
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xComponent);
        if (xModel != null && (selectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)(xController = xModel.getCurrentController()))) != null) {
            try {
                selectionSupplier.select((Object)interfaceObject.getXInterfaceObject());
            }
            catch (Throwable throwable) {
                throw new NOAException(throwable);
            }
        }
    }

    protected void removeCloseListeners() {
        if (this.closeListeners != null) {
            Object[] closeListenersArr = this.closeListeners.keySet().toArray();
            int i = 0;
            while (i < closeListenersArr.length) {
                this.removeCloseListener((ICloseListener)closeListenersArr[i]);
                ++i;
            }
            this.closeListeners = null;
        }
    }

    protected void removeModifyListeners() {
        if (this.modifyListenerTable != null) {
            Object[] modifyListeners = this.modifyListenerTable.keySet().toArray();
            int i = 0;
            while (i < modifyListeners.length) {
                this.removeDocumentModifyListener((IDocumentModifyListener)modifyListeners[i]);
                ++i;
            }
            this.modifyListenerTable = null;
        }
    }

    protected void removeDocumentListeners() {
        if (this.documentListenerList != null) {
            Object[] documentListeners = this.documentListenerList.toArray();
            int i = 0;
            while (i < documentListeners.length) {
                this.removeDocumentListener((IDocumentListener)documentListeners[i]);
                ++i;
            }
            this.documentListenerList = null;
        }
        if (this.documentListenerWrapper != null) {
            this.removeEventListener(this.documentListenerWrapper);
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        @Override
        public void onNew(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onNew(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onLoad(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onLoad(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onLoadDone(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onLoadDone(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onLoadFinished(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onLoadFinished(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onSave(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onSave(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onSaveDone(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onSaveDone(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onSaveFinished(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onSaveFinished(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onSaveAs(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onSaveAs(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onSaveAsDone(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onSaveAsDone(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onModifyChanged(IDocumentEvent documentEvent) {
            boolean bl = AbstractDocument.this.isModified = !AbstractDocument.this.isModified;
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onModifyChanged(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onMouseOver(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onMouseOver(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onMouseOut(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onMouseOut(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onFocus(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onFocus(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onAlphaCharInput(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onAlphaCharInput(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onNonAlphaCharInput(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onNonAlphaCharInput(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onInsertStart(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onInsertStart(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onInsertDone(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onInsertDone(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void onUnload(IDocumentEvent documentEvent) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).onUnload(documentEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }

        @Override
        public void disposing(IEvent event) {
            if (AbstractDocument.this.documentListenerList != null) {
                int i = 0;
                int n = AbstractDocument.this.documentListenerList.size();
                while (i < n) {
                    try {
                        ((IDocumentListener)AbstractDocument.this.documentListenerList.get(i)).disposing(event);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                AbstractDocument.this.documentListenerList = null;
            }
        }
    }
}

