/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;

public class DLD
extends AbstractComposite {
    private Type[] data;

    public DLD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new CWE(this.getMessage());
        this.data[1] = new DTM(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CWE getDischargeToLocation() {
        return this.getTyped(0, CWE.class);
    }

    public CWE getDld1_DischargeToLocation() {
        return this.getTyped(0, CWE.class);
    }

    public DTM getEffectiveDate() {
        return this.getTyped(1, DTM.class);
    }

    public DTM getDld2_EffectiveDate() {
        return this.getTyped(1, DTM.class);
    }
}

