/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.RPL_I02_PRDCTD;
import ca.uhn.hl7v2.model.v231.segment.DSC;
import ca.uhn.hl7v2.model.v231.segment.DSP;
import ca.uhn.hl7v2.model.v231.segment.MSA;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RPL_I02
extends AbstractMessage {
    public RPL_I02() {
        this(new DefaultModelClassFactory());
    }

    public RPL_I02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(RPL_I02_PRDCTD.class, true, true);
            this.add(NTE.class, false, true);
            this.add(DSP.class, false, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPL_I02 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public RPL_I02_PRDCTD getPRDCTD() {
        return this.getTyped("PRDCTD", RPL_I02_PRDCTD.class);
    }

    public RPL_I02_PRDCTD getPRDCTD(int rep) {
        return this.getTyped("PRDCTD", rep, RPL_I02_PRDCTD.class);
    }

    public int getPRDCTDReps() {
        return this.getReps("PRDCTD");
    }

    public List<RPL_I02_PRDCTD> getPRDCTDAll() throws HL7Exception {
        return this.getAllAsList("PRDCTD", RPL_I02_PRDCTD.class);
    }

    public void insertPRDCTD(RPL_I02_PRDCTD structure, int rep) throws HL7Exception {
        super.insertRepetition("PRDCTD", structure, rep);
    }

    public RPL_I02_PRDCTD insertPRDCTD(int rep) throws HL7Exception {
        return (RPL_I02_PRDCTD)super.insertRepetition("PRDCTD", rep);
    }

    public RPL_I02_PRDCTD removePRDCTD(int rep) throws HL7Exception {
        return (RPL_I02_PRDCTD)super.removeRepetition("PRDCTD", rep);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public DSP getDSP() {
        return this.getTyped("DSP", DSP.class);
    }

    public DSP getDSP(int rep) {
        return this.getTyped("DSP", rep, DSP.class);
    }

    public int getDSPReps() {
        return this.getReps("DSP");
    }

    public List<DSP> getDSPAll() throws HL7Exception {
        return this.getAllAsList("DSP", DSP.class);
    }

    public void insertDSP(DSP structure, int rep) throws HL7Exception {
        super.insertRepetition("DSP", structure, rep);
    }

    public DSP insertDSP(int rep) throws HL7Exception {
        return (DSP)super.insertRepetition("DSP", rep);
    }

    public DSP removeDSP(int rep) throws HL7Exception {
        return (DSP)super.removeRepetition("DSP", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

