/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.MFN_M04_MF_CDM;
import ca.uhn.hl7v2.model.v23.segment.MFI;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M04
extends AbstractMessage {
    public MFN_M04() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M04_MF_CDM.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFN_M04_MF_CDM getMF_CDM() {
        return this.getTyped("MF_CDM", MFN_M04_MF_CDM.class);
    }

    public MFN_M04_MF_CDM getMF_CDM(int rep) {
        return this.getTyped("MF_CDM", rep, MFN_M04_MF_CDM.class);
    }

    public int getMF_CDMReps() {
        return this.getReps("MF_CDM");
    }

    public List<MFN_M04_MF_CDM> getMF_CDMAll() throws HL7Exception {
        return this.getAllAsList("MF_CDM", MFN_M04_MF_CDM.class);
    }

    public void insertMF_CDM(MFN_M04_MF_CDM structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_CDM", structure, rep);
    }

    public MFN_M04_MF_CDM insertMF_CDM(int rep) throws HL7Exception {
        return (MFN_M04_MF_CDM)super.insertRepetition("MF_CDM", rep);
    }

    public MFN_M04_MF_CDM removeMF_CDM(int rep) throws HL7Exception {
        return (MFN_M04_MF_CDM)super.removeRepetition("MF_CDM", rep);
    }
}

