/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ui.dialogs.ConditionEditDialog;
import ch.elexis.core.findings.ui.services.CodingServiceComponent;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.NatTableFactory;
import ch.elexis.core.ui.util.NatTableWrapper;
import ch.elexis.data.Patient;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsDataProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class DiagnoseListComposite
extends Composite {
    private NatTableWrapper natTableWrapper;
    private ToolBarManager toolbarManager;
    private EventList<ICondition> dataList = new BasicEventList();

    public DiagnoseListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.natTableWrapper = NatTableFactory.createSingleColumnTable((Composite)this, (IRowDataProvider)new GlazedListsDataProvider(this.dataList, (IColumnAccessor)new IColumnAccessor<ICondition>(){

            public int getColumnCount() {
                return 1;
            }

            public Object getDataValue(ICondition condition, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.getFormattedDescriptionText(condition);
                    }
                }
                return "";
            }

            private Object getFormattedDescriptionText(ICondition condition) {
                StringBuilder text = new StringBuilder();
                StringBuilder contentText = new StringBuilder();
                Optional conditionText = condition.getText();
                conditionText.ifPresent(t -> {
                    if (contentText.length() > 0) {
                        contentText.append("\n");
                    }
                    contentText.append((String)t);
                });
                List codings = condition.getCoding();
                if (codings != null && !codings.isEmpty()) {
                    for (ICoding iCoding : codings) {
                        if (contentText.length() > 0) {
                            contentText.append(", ");
                        }
                        contentText.append("[").append(CodingServiceComponent.getService().getShortLabel(iCoding)).append("] ");
                    }
                }
                text.append("<strong>");
                ICondition.ConditionStatus status = condition.getStatus();
                text.append(status.getLocalized());
                Optional start = condition.getStart();
                start.ifPresent(string -> {
                    StringBuilder stringBuilder2 = text.append(" (").append((String)string).append(" - ");
                });
                Optional end = condition.getEnd();
                end.ifPresent(string -> {
                    StringBuilder stringBuilder2 = text.append((String)string);
                });
                start.ifPresent(string -> {
                    StringBuilder stringBuilder2 = text.append(")");
                });
                List notes = condition.getNotes();
                if (!notes.isEmpty()) {
                    text.append(" (" + notes.size() + ")");
                }
                if (contentText.toString().contains("\n")) {
                    text.append("</strong>\n").append(contentText.toString());
                } else {
                    text.append("</strong> ").append(contentText.toString());
                }
                return text.toString();
            }

            public void setDataValue(ICondition condition, int arg1, Object arg2) {
            }
        }), null);
        this.natTableWrapper.getNatTable().setLayoutData((Object)new GridData(1808));
        this.natTableWrapper.addDoubleClickListener(new NatTableWrapper.IDoubleClickListener(){

            public void doubleClick(final NatTableWrapper source, ISelection selection) {
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    final ICondition condition = (ICondition)((StructuredSelection)selection).getFirstElement();
                    AcquireLockBlockingUi.aquireAndRun((Identifiable)condition, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            ConditionEditDialog dialog = new ConditionEditDialog(condition, Display.getDefault().getActiveShell());
                            if (dialog.open() == 0) {
                                dialog.getCondition().ifPresent(c -> source.getNatTable().refresh());
                            }
                        }
                    });
                }
            }
        });
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener((IMenuListener)new ConditionsMenuListener());
        this.natTableWrapper.getNatTable().setMenu(mgr.createContextMenu((Control)this.natTableWrapper.getNatTable()));
        this.toolbarManager = new ToolBarManager();
        this.toolbarManager.add((IAction)new AddConditionAction());
        this.toolbarManager.add((IAction)new RemoveConditionAction());
        ToolBar toolbar = this.toolbarManager.createControl((Composite)this);
        toolbar.setLayoutData((Object)new GridData(131072, 128, false, false));
        toolbar.setBackground(parent.getBackground());
    }

    public void setInput(List<ICondition> conditions) {
        this.dataList.clear();
        conditions.sort(new Comparator<ICondition>(){

            @Override
            public int compare(ICondition left, ICondition right) {
                Optional lrecorded = left.getDateRecorded();
                Optional rrecorded = right.getDateRecorded();
                if (lrecorded.isPresent() && rrecorded.isPresent()) {
                    return ((LocalDate)rrecorded.get()).compareTo((ChronoLocalDate)lrecorded.get());
                }
                Optional lstart = left.getStart();
                Optional rstart = right.getStart();
                if (lstart.isPresent() && rstart.isPresent()) {
                    return ((String)rstart.get()).compareTo((String)lstart.get());
                }
                return 0;
            }
        });
        this.dataList.addAll(conditions);
        this.natTableWrapper.getNatTable().refresh();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point ret = this.toolbarManager.getControl().computeSize(wHint, hHint);
        Point natRet = this.natTableWrapper.computeSize(wHint, hHint);
        ret.y += natRet.y;
        ret.x = natRet.x;
        return ret;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.natTableWrapper != null && !this.natTableWrapper.isDisposed()) {
            this.natTableWrapper.getNatTable().setBackground(color);
        }
    }

    private class AddConditionAction
    extends Action {
        private AddConditionAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_NEW.getImageDescriptor();
        }

        public String getText() {
            return "erstellen";
        }

        public void run() {
            ConditionEditDialog dialog;
            Patient selectedPatient = ElexisEventDispatcher.getSelectedPatient();
            if (selectedPatient != null && (dialog = new ConditionEditDialog(ICondition.ConditionCategory.PROBLEMLISTITEM, DiagnoseListComposite.this.getShell())).open() == 0) {
                dialog.getCondition().ifPresent(c -> {
                    c.setPatientId(selectedPatient.getId());
                    FindingsServiceComponent.getService().saveFinding((IFinding)c);
                    LocalLockServiceHolder.get().acquireLock(c);
                    DiagnoseListComposite.this.dataList.add(c);
                    DiagnoseListComposite.this.natTableWrapper.getNatTable().refresh();
                });
            }
        }
    }

    private class ConditionsMenuListener
    implements IMenuListener {
        private ConditionsMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            ISelection currentSelection = DiagnoseListComposite.this.natTableWrapper.getSelection();
            if (currentSelection instanceof StructuredSelection) {
                StructuredSelection sSelection = (StructuredSelection)currentSelection;
                if (sSelection.size() == 1) {
                    ICondition selectedCondition = (ICondition)sSelection.getFirstElement();
                    ICondition.ConditionStatus selectionStatus = selectedCondition.getStatus();
                    if (selectionStatus != ICondition.ConditionStatus.ACTIVE) {
                        manager.add((IAction)new ToggleStatusAction(selectedCondition, ICondition.ConditionStatus.ACTIVE));
                    }
                    if (selectionStatus != ICondition.ConditionStatus.RESOLVED) {
                        manager.add((IAction)new ToggleStatusAction(selectedCondition, ICondition.ConditionStatus.RESOLVED));
                    }
                    if (selectionStatus != ICondition.ConditionStatus.RELAPSE) {
                        manager.add((IAction)new ToggleStatusAction(selectedCondition, ICondition.ConditionStatus.RELAPSE));
                    }
                    if (selectionStatus != ICondition.ConditionStatus.REMISSION) {
                        manager.add((IAction)new ToggleStatusAction(selectedCondition, ICondition.ConditionStatus.REMISSION));
                    }
                }
                if (!sSelection.isEmpty()) {
                    manager.add((IAction)new RemoveConditionAction());
                }
            }
        }
    }

    private class RemoveConditionAction
    extends Action {
        private RemoveConditionAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public String getText() {
            return "entfernen";
        }

        public void run() {
            ISelection selection = DiagnoseListComposite.this.natTableWrapper.getSelection();
            if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                List list = ((StructuredSelection)selection).toList();
                list.stream().forEach(c -> AcquireLockUi.aquireAndRun((Identifiable)c, (ILockHandler)new ILockHandler((ICondition)c){
                    private final /* synthetic */ ICondition val$c;
                    {
                        this.val$c = iCondition;
                    }

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        FindingsServiceComponent.getService().deleteFinding((IFinding)this.val$c);
                        DiagnoseListComposite.this.dataList.remove((Object)this.val$c);
                        DiagnoseListComposite.this.natTableWrapper.getNatTable().refresh();
                    }
                }));
            }
        }
    }

    private class ToggleStatusAction
    extends Action {
        private ICondition.ConditionStatus status;
        private ICondition condition;

        public ToggleStatusAction(ICondition condition, ICondition.ConditionStatus status) {
            this.status = status;
            this.condition = condition;
        }

        public String getText() {
            return "Status " + this.status.getLocalized();
        }

        public void run() {
            AcquireLockUi.aquireAndRun((Identifiable)this.condition, (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    ToggleStatusAction.this.condition.setStatus(ToggleStatusAction.this.status);
                    FindingsServiceComponent.getService().saveFinding((IFinding)ToggleStatusAction.this.condition);
                }
            });
            DiagnoseListComposite.this.natTableWrapper.getNatTable().refresh();
        }
    }
}

