/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.wizards;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.wizards.DBConnectSecondPage;
import ch.elexis.core.ui.wizards.Messages;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DBConnectFirstPage
extends WizardPage {
    Combo dbTypes;
    Text server;
    Text dbName;
    String defaultUser;
    String defaultPassword;
    JdbcLink j = null;
    static final String[] supportedDB = new String[]{"mySQl", "PostgreSQL", "H2"};

    public DBConnectFirstPage(String pageName) {
        super(Messages.DBConnectFirstPage_Connection, Messages.DBConnectFirstPage_typeOfDB, Images.IMG_LOGO.getImageDescriptor(ImageSize._75x66_TitleDialogIconSize));
        this.setMessage(Messages.DBConnectFirstPage_selectType);
        this.setDescription(Messages.DBConnectFirstPage_theDescripotion);
    }

    public DBConnectFirstPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        FormToolkit tk = UiDesk.getToolkit();
        Form form = tk.createForm(parent);
        form.setText(Messages.DBConnectFirstPage_connectioNDetails);
        Composite body = form.getBody();
        body.setLayout((Layout)new TableWrapLayout());
        FormText alt = tk.createFormText(body, false);
        StringBuilder old = new StringBuilder();
        old.append("<form>");
        String driver = "";
        String user = "";
        String typ = "";
        String connectString = "";
        Hashtable hConn = null;
        String cnt = CoreHub.localCfg.get("verbindung/folded_string", null);
        if (cnt != null && (hConn = PersistentObject.fold((byte[])StringTool.dePrintable((String)cnt))) != null) {
            driver = PersistentObject.checkNull(hConn.get("driver"));
            connectString = PersistentObject.checkNull(hConn.get("connectionstring"));
            user = PersistentObject.checkNull(hConn.get("user"));
            typ = PersistentObject.checkNull(hConn.get("typ"));
        }
        String dbUser = System.getProperty("ch.elexis.dbUser");
        String dbPw = System.getProperty("ch.elexis.dbPw");
        String dbFlavor = System.getProperty("ch.elexis.dbFlavor");
        String dbSpec = System.getProperty("ch.elexis.dbSpec");
        if (dbUser != null && dbPw != null && dbFlavor != null && dbSpec != null) {
            old.append("<br/><li><b>Aktuelle Verbindung wurde via \u00dcbergabeparameter ans Programm gesetzt!</b></li><br/>");
        }
        if (StringTool.isNothing((Object)connectString)) {
            old.append("<br/>");
            old.append("Keine konfigurierte Verbindung.");
        } else {
            old.append("Konfigurierte Verbindung ist:<br/>");
            old.append("<li><b>Typ:</b>       ").append(typ).append("</li>");
            old.append("<li><b>Treiber</b>    ").append(driver).append("</li>");
            old.append("<li><b>Verbinde</b>   ").append(connectString).append("</li>");
            old.append("<li><b>Username</b>   ").append(user).append("</li>");
        }
        if (PersistentObject.getConnection() != null && PersistentObject.getConnection().getConnectString() != null) {
            old.append("<li><b>Effektiv</b> verwendet wird:").append(PersistentObject.getConnection().getConnectString()).append("</li>");
        }
        old.append("</form>");
        alt.setText(old.toString(), true, false);
        Label sep = tk.createSeparator(body, 0);
        TableWrapData twd = new TableWrapData();
        twd.heightHint = 5;
        sep.setLayoutData((Object)twd);
        tk.createLabel(body, Messages.DBConnectFirstPage_enterType);
        this.dbTypes = new Combo(body, 2112);
        this.dbTypes.setItems(supportedDB);
        this.dbTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int it = DBConnectFirstPage.this.dbTypes.getSelectionIndex();
                switch (it) {
                    case 0: 
                    case 1: {
                        DBConnectFirstPage.this.server.setEnabled(true);
                        DBConnectFirstPage.this.dbName.setEnabled(true);
                        DBConnectFirstPage.this.defaultUser = "elexis";
                        DBConnectFirstPage.this.defaultPassword = "elexisTest";
                        break;
                    }
                    case 2: {
                        DBConnectFirstPage.this.server.setEnabled(false);
                        DBConnectFirstPage.this.dbName.setEnabled(true);
                        DBConnectFirstPage.this.defaultUser = "sa";
                        DBConnectFirstPage.this.defaultPassword = "";
                        break;
                    }
                }
                DBConnectSecondPage sec = (DBConnectSecondPage)DBConnectFirstPage.this.getNextPage();
                sec.name.setText(DBConnectFirstPage.this.defaultUser);
                sec.pwd.setText(DBConnectFirstPage.this.defaultPassword);
            }
        });
        tk.adapt((Control)this.dbTypes, true, true);
        tk.createLabel(body, Messages.DBConnectFirstPage_serevrAddress);
        this.server = tk.createText(body, "", 2048);
        TableWrapData twr = new TableWrapData(256);
        this.server.setLayoutData((Object)twr);
        tk.createLabel(body, Messages.DBConnectFirstPage_databaseName);
        this.dbName = tk.createText(body, "", 2048);
        TableWrapData twr2 = new TableWrapData(256);
        this.dbName.setLayoutData((Object)twr2);
        this.setControl((Control)form);
    }
}

