/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.dialogs.EditAUFDialog;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.views.BriefAuswahl;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.LoggerFactory;

public class AUF2
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.auf";
    TableViewer tv;
    private Action newAUF;
    private Action delAUF;
    private Action modAUF;
    private Action printAUF;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);

    @Inject
    void activeCertificate(@org.eclipse.e4.core.di.annotations.Optional ISickCertificate certificate) {
        Display.getDefault().asyncExec(() -> {
            boolean bSelect = certificate != null;
            this.modAUF.setEnabled(bSelect);
            this.delAUF.setEnabled(bSelect);
            if (bSelect && this.tv != null && !Objects.equals(this.tv.getStructuredSelection(), new StructuredSelection((Object)certificate))) {
                this.tv.refresh(false);
                this.tv.setSelection((ISelection)new StructuredSelection((Object)certificate));
            }
        });
    }

    @Inject
    void activePatient(@org.eclipse.e4.core.di.annotations.Optional IPatient patient) {
        Display.getDefault().asyncExec(() -> {
            if (patient != null) {
                this.tv.refresh();
                ContextServiceHolder.get().getRootContext().removeTyped(ISickCertificate.class);
                this.newAUF.setEnabled(true);
            } else {
                this.newAUF.setEnabled(false);
                this.modAUF.setEnabled(false);
                this.delAUF.setEnabled(false);
            }
        });
    }

    public AUF2() {
        this.setTitleImage(Images.IMG_VIEW_WORK_INCAPABLE.getImage());
    }

    public void createPartControl(Composite parent) {
        this.setPartName(Messages.AUF2_certificate);
        this.tv = new TableViewer(parent, 770);
        this.tv.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        this.tv.setContentProvider((IContentProvider)new AUFContentProvider());
        this.makeActions();
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createMenu(new IAction[]{this.newAUF, this.delAUF, this.modAUF, this.printAUF});
        menus.createToolbar(new IAction[]{this.newAUF, this.delAUF, this.printAUF});
        this.tv.setUseHashlookup(true);
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection().getFirstElement() instanceof ISickCertificate) {
                    ContextServiceHolder.get().getRootContext().setTyped(event.getStructuredSelection().getFirstElement());
                }
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AUF2.this.modAUF.run();
            }
        });
        this.tv.setInput((Object)this.getViewSite());
        Transfer[] dragTransferTypes = new Transfer[]{TextTransfer.getInstance()};
        this.tv.addDragSupport(1, dragTransferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AUF2.this.tv.getSelection();
                StringBuilder sb = new StringBuilder();
                if (selection != null && !selection.isEmpty()) {
                    ISickCertificate auf = (ISickCertificate)selection.getFirstElement();
                    sb.append(StoreToStringServiceHolder.getStoreToString((Object)auf)).append(",");
                }
                event.data = sb.toString().replace(",$", "");
            }
        });
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.newAUF = new Action(Messages.AUF2_new){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_createNewCert);
            }

            public void run() {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    Object createdAuf = handlerService.executeCommand("ch.elexis.core.ui.commands.AufNew", null);
                    if (createdAuf instanceof ISickCertificate) {
                        ContextServiceHolder.get().getRootContext().setTyped(createdAuf);
                    }
                    AUF2.this.refresh();
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(BriefAuswahl.class).error("cannot execute cmd", (Throwable)e);
                }
            }
        };
        this.delAUF = new Action(Messages.AUF2_delete){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_deleteCertificate);
            }

            public void run() {
                ISickCertificate sel = AUF2.this.getSelectedCertificate();
                if (sel != null && MessageDialog.openConfirm((Shell)AUF2.this.getViewSite().getShell(), (String)Messages.AUF2_deleteReally, (String)Messages.AUF2_doyoywantdeletereally)) {
                    CoreModelServiceHolder.get().delete((Deleteable)sel);
                    AUF2.this.tv.refresh(false);
                }
            }
        };
        this.modAUF = new Action(Messages.AUF2_edit){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_editCertificate);
            }

            public void run() {
                ISickCertificate sel = AUF2.this.getSelectedCertificate();
                if (sel != null) {
                    new EditAUFDialog(AUF2.this.getViewSite().getShell(), sel, sel.getCoverage()).open();
                    AUF2.this.tv.refresh(true);
                }
            }
        };
        this.printAUF = new Action(Messages.AUF2_print){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_createPrint);
            }

            public void run() {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("ch.elexis.core.ui.commands.AufPrint", null);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(BriefAuswahl.class).error("cannot execute cmd", (Throwable)e);
                }
            }
        };
    }

    private ISickCertificate getSelectedCertificate() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (sel == null || sel.isEmpty()) {
            return null;
        }
        return (ISickCertificate)sel.getFirstElement();
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    @Override
    public void refresh() {
        if (CoreUiUtil.isActiveControl(this.tv.getControl())) {
            this.tv.refresh();
        }
    }

    class AUFContentProvider
    implements IStructuredContentProvider {
        AUFContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Optional patient = ContextServiceHolder.get().getActivePatient();
            if (patient.isPresent()) {
                INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(ISickCertificate.class, new String[]{"patient"});
                List list = query.executeWithParameters(query.getParameterMap(new Object[]{"patient", patient.get()}));
                return list.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

