/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.data.interfaces.text.ReplaceCallback;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.text.ExternalLink;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.rgw.compress.CompEx;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;

public class ETFTextPlugin
implements ITextPlugin {
    private static final String CHARSET = "UTF-8";
    EnhancedTextField etf;
    ITextPlugin.ICallback handler;
    boolean bSaveOnFocusLost = false;
    IKonsExtension ike;

    @Override
    public boolean clear() {
        this.etf.setText("");
        return true;
    }

    @Override
    public void setSaveOnFocusLost(boolean mode) {
        this.bSaveOnFocusLost = mode;
    }

    @Override
    public Composite createContainer(Composite parent, ITextPlugin.ICallback h) {
        this.handler = h;
        this.etf = new EnhancedTextField(parent);
        this.etf.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ETFTextPlugin.this.bSaveOnFocusLost && ETFTextPlugin.this.handler != null) {
                    ETFTextPlugin.this.handler.save();
                }
            }
        });
        this.ike = new ExternalLink();
        this.ike.connect(this.etf);
        this.etf.setText("");
        return this.etf;
    }

    @Override
    public boolean createEmptyDocument() {
        this.etf.setText("");
        return true;
    }

    @Override
    public void dispose() {
        this.etf.dispose();
    }

    @Override
    public boolean findOrReplace(String pattern, ReplaceCallback cb) {
        return false;
    }

    @Override
    public ITextPlugin.PageFormat getFormat() {
        return ITextPlugin.PageFormat.USER;
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public boolean insertTable(String place, int properties, String[][] contents, int[] columnSizes) {
        return false;
    }

    @Override
    public Object insertText(String marke, String text, int adjust) {
        int pos = 0;
        if (StringTool.isNothing((Object)marke)) {
            this.etf.text.setSelection(0);
        } else {
            String tx = this.etf.text.getText();
            pos = tx.indexOf(marke);
            this.etf.text.setSelection(pos, pos + marke.length());
        }
        this.etf.text.insert(text);
        return new Integer(pos + text.length());
    }

    @Override
    public Object insertText(Object pos, String text, int adjust) {
        if (!(pos instanceof Integer)) {
            return null;
        }
        Integer px = (Integer)pos;
        this.etf.text.setSelection(px.intValue());
        this.etf.text.insert(text);
        return new Integer(px + text.length());
    }

    @Override
    public Object insertTextAt(int x, int y, int w, int h, String text, int adjust) {
        return null;
    }

    @Override
    public boolean loadFromByteArray(byte[] bs, boolean asTemplate) {
        try {
            byte[] exp = CompEx.expand((byte[])bs);
            String cnt = "";
            if (exp != null) {
                cnt = new String(exp, CHARSET);
            }
            this.etf.setText(cnt);
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
    }

    @Override
    public byte[] storeToByteArray() {
        try {
            String cnt = this.etf.getContentsAsXML();
            byte[] exp = cnt.getBytes(CHARSET);
            return CompEx.Compress((byte[])exp, (int)-1610612736);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean loadFromStream(InputStream is, boolean asTemplate) {
        return false;
    }

    @Override
    public boolean print(String toPrinter, String toTray, boolean waitUntilFinished) {
        return false;
    }

    @Override
    public void setFocus() {
        this.etf.setFocus();
    }

    @Override
    public boolean setFont(String name, int style, float size) {
        return true;
    }

    @Override
    public boolean setStyle(int style) {
        return false;
    }

    @Override
    public void setFormat(ITextPlugin.PageFormat f) {
    }

    @Override
    public void showMenu(boolean b) {
    }

    @Override
    public void showToolbar(boolean b) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    @Override
    public boolean isDirectOutput() {
        return false;
    }

    @Override
    public void setParameter(ITextPlugin.Parameter parameter) {
    }

    @Override
    public void initTemplatePrintSettings(String template) {
    }
}

