/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.ContactElement;
import ch.elexis.core.ui.exchange.elements.EpisodeElement;
import ch.elexis.core.ui.exchange.elements.MarkupElement;
import ch.elexis.core.ui.exchange.elements.Messages;
import ch.elexis.core.ui.exchange.elements.MetaElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import ch.rgw.tools.XMLTool;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class RecordElement
extends XChangeElement {
    static final String ELEMENT_TEXT = "text";
    static final String ELEMENT_EPISODE = "episode";
    static final String ATTR_AUTHOR = "author";
    static final String ATTR_RESPONSIBLE = "responsible";
    static final String ATTR_DATE = "date";
    public static final String XMLNAME = "record";

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public RecordElement asExporter(XChangeExporter c, Konsultation k) {
        this.asExporter(c);
        this.setAttribute(ATTR_DATE, new TimeTool(k.getDatum()).toString(6));
        Mandant kMandant = k.getMandant();
        if (kMandant == null) {
            this.setAttribute(ATTR_RESPONSIBLE, "unknown");
        } else {
            ContactElement cMandant = c.addContact((Kontakt)kMandant);
            this.setAttribute(ATTR_RESPONSIBLE, cMandant.getID());
        }
        this.setAttribute("id", XMLTool.idToXMLID((String)k.getId()));
        c.getContainer().addChoice(this, k.getLabel(), (Object)k);
        VersionedResource vr = k.getEintrag();
        VersionedResource.ResourceItem entry = vr.getVersion(vr.getHeadVersion());
        if (entry != null) {
            String st;
            this.setAttribute(ATTR_AUTHOR, entry.remark);
            Samdas samdas = new Samdas(k.getEintrag().getHead());
            Samdas.Record record = samdas.getRecord();
            if (record != null && (st = record.getText()) != null) {
                Element eText = new Element(ELEMENT_TEXT, this.getContainer().getNamespace());
                eText.addContent(XMLTool.getValidXMLString((String)st));
                this.getElement().addContent((Content)eText);
                List xrefs = record.getXrefs();
                for (Samdas.XRef xref : xrefs) {
                    if (!this.shouldAddXRef(xref)) continue;
                    MarkupElement me = new MarkupElement().asExporter(c, xref);
                    this.add(me);
                }
            }
        }
        c.getContainer().addMapping(this, (PersistentObject)k);
        return this;
    }

    private boolean shouldAddXRef(Samdas.XRef xref) {
        return !xref.getProvider().toLowerCase().contains("privatnotizen");
    }

    public void addEpisodeRef(EpisodeElement episode) {
        Element eEpisode = new Element(ELEMENT_EPISODE, this.getContainer().getNamespace());
        eEpisode.setAttribute("ref", episode.getID());
        this.getElement().addContent((Content)eEpisode);
    }

    public void addMeta(String name, String value) {
        MetaElement meta = new MetaElement().asExporter(this.sender, name, value);
        this.add(meta);
    }

    public MetaElement getMeta(String name) {
        List<? extends XChangeElement> meta = this.getChildren("meta", MetaElement.class);
        if (meta != null && !meta.isEmpty()) {
            for (MetaElement metaElement : meta) {
                if (!name.equals(metaElement.getAttr("name"))) continue;
                return metaElement;
            }
        }
        return null;
    }

    public String toString() {
        Element eText;
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.RecordElement_EntryDate).append(this.getAttr(ATTR_DATE)).append(Messages.RecordElement_CreatedBy).append(this.getAttr(ATTR_AUTHOR)).append("\n");
        List children = this.getElement().getChildren();
        if (children != null) {
            for (Element child : children) {
                if (child.getName().equals(ELEMENT_TEXT)) continue;
                sb.append(child.getName()).append(":\n");
                sb.append(child.getText()).append("\n");
            }
        }
        if ((eText = this.getElement().getChild(ELEMENT_TEXT)) != null) {
            String text = eText.getText();
            sb.append(text).append("\n------------------------------\n");
        }
        return sb.toString();
    }
}

