/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.chromium.Browser;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DisplayTextDialog
extends TitleAreaDialog {
    String t;
    String m;
    String cnt;
    Boolean hS = true;
    Font f = null;

    public DisplayTextDialog(Shell parentShell, String title, String message, String content) {
        super(parentShell);
        this.t = title;
        this.m = message;
        this.cnt = content;
    }

    public void setWhitespaceNormalized(Boolean hideSpaces) {
        this.hS = hideSpaces;
    }

    public void setFont(Font font) {
        this.f = font;
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledForm form = UiDesk.getToolkit().createScrolledForm(parent);
        form.getBody().setLayout((Layout)new ColumnLayout());
        form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        Browser ret = null;
        if (this.cnt.startsWith("<html>")) {
            ret = new Browser(form.getBody(), 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            ret.setText(this.cnt);
            if (this.cnt.length() > 300) {
                this.getShell().setSize(800, 600);
            }
        } else {
            this.cnt = this.cnt.replaceAll("<", "&lt;");
            this.cnt = this.cnt.replaceAll(">", "&gt;");
            this.cnt = this.cnt.replaceAll("\n", "<br />");
            this.cnt = this.cnt.replaceAll("\\*\\.(.{1,30})\\.\\*", "<b>$1</b>");
            this.cnt = this.cnt.replaceAll("\\\\\\.br\\\\", "<br/>");
            this.cnt = this.cnt.replaceAll("\\\\\\.BR\\\\", "<br/>");
            this.cnt = this.cnt.replaceAll("\\n\\n", "\\n");
            ret = UiDesk.getToolkit().createFormText(form.getBody(), false);
            ((FormText)ret).setWhitespaceNormalized(this.hS.booleanValue());
            if (this.f != null) {
                try {
                    ((FormText)ret).setFont(this.f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((FormText)ret).setText("<form><p>" + this.cnt + "</p></form>", true, true);
        }
        SWTHelper.center(UiDesk.getTopShell(), this.getShell());
        return ret;
    }

    public void create() {
        super.create();
        this.getShell().setText(this.t);
        Patient sp = ElexisEventDispatcher.getSelectedPatient();
        this.setTitle(sp != null ? sp.getLabel() : "missing patient name");
        this.setMessage(this.m);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
        Rectangle screen = UiDesk.getDisplay().getBounds();
        int w = screen.width - screen.width / 4;
        int h = screen.width - screen.width / 4;
        this.getShell().setBounds(0, 0, w, h);
        SWTHelper.center(this.getShell());
    }
}

