/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IArticleDefaultSignature;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.MediDetailDialog;
import ch.elexis.core.ui.dialogs.PrescriptionSignatureTitleAreaDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.medication.handlers.PrintRecipeHandler;
import ch.elexis.core.ui.medication.handlers.PrintTakingsListHandler;
import ch.elexis.core.ui.medication.views.MedicationViewHelper;
import ch.elexis.core.ui.medication.views.Messages;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.CreatePrescriptionHelper;
import ch.elexis.core.ui.util.GenericObjectDragSource;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.controls.InteractionLink;
import ch.rgw.tools.ExHandler;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.services.IEvaluationService;

public class FixMediDisplay
extends ListDisplay<IPrescription> {
    public static final String ID = "ch.elexis.FixMediDisplay";
    private final ListDisplay.LDListener dlisten;
    private IAction stopMedicationAction;
    private IAction changeMedicationAction;
    private IAction removeMedicationAction;
    private IAction addDefaultSignatureAction;
    FixMediDisplay self;
    Label lCost;
    InteractionLink interactionLink;
    GenericObjectDropTarget target;
    private MenuManager menuManager;
    private IViewSite viewSite;
    static final String REZEPT = Messages.FixMediDisplay_Prescription;
    static final String LISTE = Messages.FixMediDisplay_UsageList;
    static final String HINZU = Messages.FixMediDisplay_AddItem;
    static final String KOPIEREN = Messages.FixMediDisplay_Copy;

    @Inject
    void activePatient(@org.eclipse.e4.core.di.annotations.Optional IPatient patient) {
        Display.getDefault().asyncExec(() -> {
            if (CoreUiUtil.isActiveControl((Control)this.list)) {
                this.reload();
            }
        });
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void updatePrescription(@UIEventTopic(value="info/elexis/model/update") IPrescription prescription) {
        if (CoreUiUtil.isActiveControl((Control)this.list) && prescription != null) {
            this.reload();
        }
    }

    @Inject
    void createPrescription(@org.eclipse.e4.core.di.annotations.Optional @UIEventTopic(value="info/elexis/model/create") IPrescription prescription) {
        this.updatePrescription(prescription);
    }

    @Inject
    void reloadPrescription(@org.eclipse.e4.core.di.annotations.Optional @UIEventTopic(value="info/elexis/model/create") Class<?> clazz) {
        if (clazz == IPrescription.class && CoreUiUtil.isActiveControl((Control)this.list)) {
            this.reload();
        }
    }

    public FixMediDisplay(Composite parent, IViewSite viewSite) {
        super(parent, 0, null);
        this.viewSite = viewSite;
        this.lCost = new Label((Composite)this, 0);
        this.lCost.setText(Messages.FixMediDisplay_DailyCost);
        this.lCost.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.interactionLink = new InteractionLink((Composite)this, 0);
        this.interactionLink.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.dlisten = new DauerMediListener(viewSite);
        this.self = this;
        this.addHyperlinks(new String[]{HINZU, LISTE, REZEPT});
        this.makeActions();
        ViewMenus menu = new ViewMenus(viewSite);
        menu.createControlContextMenu((Control)this.list, new IAction[]{this.stopMedicationAction, this.changeMedicationAction, this.addDefaultSignatureAction, null, this.removeMedicationAction});
        this.menuManager = menu.getContextMenu();
        this.setDLDListener(this.dlisten);
        this.target = new GenericObjectDropTarget(Messages.FixMediDisplay_FixMedikation, (Control)this, new GenericObjectDropTarget.IReceiver(){

            public void dropped(List<Object> list, DropTargetEvent e) {
                for (Object object : list) {
                    if (object instanceof IArticle) {
                        CreatePrescriptionHelper prescriptionHelper = new CreatePrescriptionHelper((IArticle)object, FixMediDisplay.this.getShell());
                        prescriptionHelper.setMedicationTypeFix(true);
                        prescriptionHelper.createPrescription();
                        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IPrescription.class);
                        continue;
                    }
                    if (!(object instanceof IPrescription)) continue;
                    List existing = Collections.emptyList();
                    Optional activePatient = ContextServiceHolder.get().getActivePatient();
                    if (!activePatient.isPresent()) continue;
                    existing = ((IPatient)activePatient.get()).getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION));
                    IPrescription pre = (IPrescription)object;
                    for (IPrescription pe : existing) {
                        if (!pe.equals(pre)) continue;
                        return;
                    }
                    IPrescription prescription = (IPrescription)new IPrescriptionBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), pre.getArticle(), (IPatient)activePatient.get(), pre.getDosageInstruction()).build();
                    prescription.setRemark(pre.getRemark());
                    CoreModelServiceHolder.get().save((Identifiable)prescription);
                    ContextServiceHolder.get().postEvent("info/elexis/model/reload", IPrescription.class);
                }
            }

            public boolean accept(List<Object> list) {
                for (Object object : list) {
                    if (object instanceof IPrescription || object instanceof IArticle) continue;
                    return false;
                }
                return true;
            }
        });
        new GenericObjectDragSource((Control)this.list, new GenericObjectDragSource.ISelectionRenderer(){

            public List<Object> getSelection() {
                IPrescription pr = (IPrescription)FixMediDisplay.this.getSelection();
                if (pr != null) {
                    return Collections.singletonList(pr);
                }
                return Collections.emptyList();
            }
        });
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextServiceHolder.get().getRootContext().setTyped(FixMediDisplay.this.getSelection());
            }
        });
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public void sortList() {
        Object[] items = this.list.getItems();
        Arrays.sort(items);
        this.list.removeAll();
        this.list.setItems((String[])items);
        this.update();
        this.redraw();
    }

    public void reload() {
        if (!this.isDisposed()) {
            this.clear();
            Optional patient = ContextServiceHolder.get().getActivePatient();
            if (patient.isPresent()) {
                List fix = ((IPatient)patient.get()).getMedication(Arrays.asList(EntryType.FIXED_MEDICATION));
                fix.stream().forEach(p -> this.add(p));
                this.lCost.setText(MedicationViewHelper.calculateDailyCostAsString(fix));
                this.interactionLink.updateAtcs(MedicationViewHelper.getAllGtins(fix));
            }
            this.sortList();
        }
    }

    private void makeActions() {
        this.changeMedicationAction = new RestrictedAction(AccessControlDefaults.MEDICATION_MODIFY, Messages.FixMediDisplay_Change){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_Modify);
            }

            public void doRun() {
                IPrescription pr = (IPrescription)FixMediDisplay.this.getSelection();
                if (pr != null) {
                    MediDetailDialog md = new MediDetailDialog(FixMediDisplay.this.getShell(), pr, true);
                    md.setExecutedFrom(FixMediDisplay.class.getSimpleName());
                    md.open();
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)pr);
                }
            }
        };
        this.stopMedicationAction = new RestrictedAction(AccessControlDefaults.MEDICATION_MODIFY, Messages.FixMediDisplay_Stop){
            {
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_StopThisMedicament);
            }

            public void doRun() {
                final IPrescription pr = (IPrescription)FixMediDisplay.this.getSelection();
                if (pr != null) {
                    FixMediDisplay.this.remove(pr);
                    AcquireLockUi.aquireAndRun((Identifiable)pr, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            pr.setStopReason("Ge\u00e4ndert durch " + CoreHub.getLoggedInContact().getLabel());
                            CoreModelServiceHolder.get().delete((Deleteable)pr);
                        }
                    });
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)pr);
                }
            }
        };
        this.addDefaultSignatureAction = new Action(Messages.FixMediDisplay_AddDefaultSignature){
            {
                this.setImageDescriptor(Images.IMG_BOOKMARK_PENCIL.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_AddDefaultSignature_Tooltip);
            }

            public void run() {
                IPrescription pr = (IPrescription)FixMediDisplay.this.getSelection();
                if (pr != null) {
                    IArticleDefaultSignature signature;
                    PrescriptionSignatureTitleAreaDialog adtad = new PrescriptionSignatureTitleAreaDialog(UiDesk.getTopShell(), pr.getArticle());
                    adtad.setMedicationTypeFix(true);
                    adtad.lookup();
                    if (adtad.open() == 0 && (signature = adtad.getSignature()) != null) {
                        this.applySignature(signature, pr);
                    }
                }
            }

            private void applySignature(final IArticleDefaultSignature signature, final IPrescription prescription) {
                AcquireLockBlockingUi.aquireAndRun((Identifiable)prescription, (ILockHandler)new ILockHandler(){

                    public void lockAcquired() {
                        IPrescription oldPrescription = prescription;
                        IPrescription newPrescription = MedicationServiceHolder.get().createPrescriptionCopy(oldPrescription);
                        if (LocalLockServiceHolder.get().acquireLock((Object)newPrescription).isOk()) {
                            newPrescription.setDosageInstruction(signature.getSignatureAsDosisString());
                            newPrescription.setRemark(signature.getComment());
                            newPrescription.setEntryType(signature.getMedicationType());
                            CoreModelServiceHolder.get().save((Identifiable)newPrescription);
                            MedicationServiceHolder.get().stopPrescription(oldPrescription, LocalDateTime.now(), "Ge\u00e4ndert durch " + CoreHub.getLoggedInContact().getLabel());
                            CoreModelServiceHolder.get().save((Identifiable)oldPrescription);
                            LocalLockServiceHolder.get().releaseLock((Object)newPrescription);
                            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)oldPrescription);
                            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)newPrescription);
                        }
                    }

                    public void lockFailed() {
                    }
                });
            }
        };
        this.removeMedicationAction = new RestrictedAction(AccessControlDefaults.DELETE_MEDICATION, Messages.FixMediDisplay_Delete){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_DeleteUnrecoverable);
            }

            public void doRun() {
                final IPrescription pr = (IPrescription)FixMediDisplay.this.getSelection();
                if (pr != null && MessageDialog.openQuestion((Shell)FixMediDisplay.this.getShell(), (String)Messages.FixMediDisplay_DeleteUnrecoverable, (String)Messages.FixMediDisplay_DeleteUnrecoverable)) {
                    FixMediDisplay.this.remove(pr);
                    AcquireLockUi.aquireAndRun((Identifiable)pr, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            CoreModelServiceHolder.get().remove((Identifiable)pr);
                        }
                    });
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)pr);
                }
            }
        };
    }

    class DauerMediListener
    implements ListDisplay.LDListener {
        IViewSite site;

        DauerMediListener(IViewSite s) {
            this.site = s;
        }

        public void hyperlinkActivated(String l) {
            try {
                if (l.equals(HINZU)) {
                    this.site.getPage().showView("ch.elexis.LeistungenView");
                    CodeSelectorHandler.getInstance().setCodeSelectorTarget((ICodeSelectorTarget)FixMediDisplay.this.target);
                } else if (l.equals(LISTE)) {
                    HashMap<String, String> parameterMap = new HashMap<String, String>();
                    parameterMap.put("ch.elexis.core.ui.medication.commandParameter.medication", "fix");
                    IEvaluationService evaluationService = (IEvaluationService)FixMediDisplay.this.viewSite.getService(IEvaluationService.class);
                    new PrintTakingsListHandler().execute(new ExecutionEvent(null, parameterMap, null, (Object)evaluationService.getCurrentState()));
                } else if (l.equals(REZEPT)) {
                    HashMap<String, String> parameterMap = new HashMap<String, String>();
                    parameterMap.put("ch.elexis.core.ui.medication.commandParameter.medication", "fix");
                    IEvaluationService evaluationService = (IEvaluationService)FixMediDisplay.this.viewSite.getService(IEvaluationService.class);
                    new PrintRecipeHandler().execute(new ExecutionEvent(null, parameterMap, null, (Object)evaluationService.getCurrentState()));
                } else if (l.equals(KOPIEREN)) {
                    FixMediDisplay.this.toClipBoard(true);
                }
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }

        public String getLabel(Object o) {
            if (o instanceof IPrescription) {
                IPrescription presc = (IPrescription)o;
                return presc.getEntryType() == EntryType.RESERVE_MEDICATION ? String.valueOf(presc.getLabel()) + " Res." : presc.getLabel();
            }
            return o.toString();
        }
    }
}

