/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.matchers.ThresholdMatcherEditor;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.FilterRowUtils;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.ParseResult;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;

public class DefaultGlazedListsFilterStrategy<T>
implements IFilterStrategy<T> {
    private static final Log LOG = LogFactory.getLog(DefaultGlazedListsFilterStrategy.class);
    protected final IColumnAccessor<T> columnAccessor;
    protected final IConfigRegistry configRegistry;
    private final CompositeMatcherEditor<T> matcherEditor;
    protected FilterList<T> filterList;
    protected ReadWriteLock filterLock;

    public DefaultGlazedListsFilterStrategy(FilterList<T> filterList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        this(filterList, new CompositeMatcherEditor(), columnAccessor, configRegistry);
        this.matcherEditor.setMode(42);
    }

    public DefaultGlazedListsFilterStrategy(FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        this.columnAccessor = columnAccessor;
        this.configRegistry = configRegistry;
        this.matcherEditor = matcherEditor;
        this.filterList = filterList;
        this.filterList.setMatcherEditor(this.matcherEditor);
        this.filterLock = filterList.getReadWriteLock();
    }

    public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
        if (filterIndexToObjectMap.isEmpty()) {
            try {
                this.filterLock.writeLock().lock();
                this.matcherEditor.getMatcherEditors().clear();
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
            return;
        }
        try {
            BasicEventList matcherEditors = new BasicEventList();
            for (Map.Entry<Integer, Object> mapEntry : filterIndexToObjectMap.entrySet()) {
                Integer columnIndex = mapEntry.getKey();
                String filterText = this.getStringFromColumnObject(columnIndex, mapEntry.getValue());
                String textDelimiter = (String)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_DELIMITER, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
                TextMatchingMode textMatchingMode = (TextMatchingMode)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
                IDisplayConverter displayConverter = (IDisplayConverter)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
                Comparator comparator = (Comparator)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
                FunctionList.Function<T, Object> columnValueProvider = this.getColumnValueProvider(columnIndex);
                List<ParseResult> parseResults = FilterRowUtils.parse(filterText, textDelimiter, textMatchingMode);
                BasicEventList stringMatcherEditors = new BasicEventList();
                for (ParseResult parseResult : parseResults) {
                    try {
                        ParseResult.MatchType matchOperation = parseResult.getMatchOperation();
                        if (matchOperation == ParseResult.MatchType.NONE) {
                            stringMatcherEditors.add(this.getTextMatcherEditor(columnIndex, textMatchingMode, displayConverter, parseResult.getValueToMatch()));
                            continue;
                        }
                        Object threshold = displayConverter.displayToCanonicalValue((Object)parseResult.getValueToMatch());
                        matcherEditors.add(this.getThresholdMatcherEditor(columnIndex, threshold, comparator, columnValueProvider, matchOperation));
                    }
                    catch (PatternSyntaxException e) {
                        LOG.warn((Object)("Error on applying a filter: " + e.getLocalizedMessage()));
                    }
                }
                if (stringMatcherEditors.size() <= 0) continue;
                CompositeMatcherEditor stringCompositeMatcherEditor = new CompositeMatcherEditor((EventList)stringMatcherEditors);
                stringCompositeMatcherEditor.setMode(24);
                matcherEditors.add((Object)stringCompositeMatcherEditor);
            }
            try {
                this.filterLock.writeLock().lock();
                Iterator existingMatcherEditors = this.matcherEditor.getMatcherEditors().iterator();
                while (existingMatcherEditors.hasNext()) {
                    MatcherEditor existingMatcherEditor = (MatcherEditor)existingMatcherEditors.next();
                    if (this.containsMatcherEditor((List<MatcherEditor<T>>)matcherEditors, (MatcherEditor<T>)existingMatcherEditor)) continue;
                    existingMatcherEditors.remove();
                }
                for (MatcherEditor matcherEditor : matcherEditors) {
                    if (this.containsMatcherEditor((List<MatcherEditor<T>>)this.matcherEditor.getMatcherEditors(), (MatcherEditor<T>)matcherEditor)) continue;
                    this.matcherEditor.getMatcherEditors().add((Object)matcherEditor);
                }
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error on applying a filter", (Throwable)e);
        }
    }

    protected String getStringFromColumnObject(int columnIndex, Object object) {
        IDisplayConverter displayConverter = (IDisplayConverter)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
        return displayConverter.canonicalToDisplayValue(object).toString();
    }

    protected ThresholdMatcherEditor<T, Object> getThresholdMatcherEditor(Integer columnIndex, Object threshold, Comparator<Object> comparator, FunctionList.Function<T, Object> columnValueProvider, ParseResult.MatchType matchOperation) {
        ThresholdMatcherEditor thresholdMatcherEditor = new ThresholdMatcherEditor(threshold, null, comparator, columnValueProvider);
        FilterRowUtils.setMatchOperation(thresholdMatcherEditor, matchOperation);
        return thresholdMatcherEditor;
    }

    protected FunctionList.Function<T, Object> getColumnValueProvider(final int columnIndex) {
        return new FunctionList.Function<T, Object>(){

            public Object evaluate(T rowObject) {
                return DefaultGlazedListsFilterStrategy.this.columnAccessor.getDataValue(rowObject, columnIndex);
            }
        };
    }

    protected TextMatcherEditor<T> getTextMatcherEditor(Integer columnIndex, TextMatchingMode textMatchingMode, IDisplayConverter converter, String filterText) {
        TextMatcherEditor textMatcherEditor = new TextMatcherEditor(this.getTextFilterator(columnIndex, converter));
        textMatcherEditor.setFilterText(new String[]{filterText});
        textMatcherEditor.setMode(this.getGlazedListsTextMatcherEditorMode(textMatchingMode));
        return textMatcherEditor;
    }

    protected TextFilterator<T> getTextFilterator(final Integer columnIndex, final IDisplayConverter converter) {
        return new TextFilterator<T>(){

            public void getFilterStrings(List<String> objectAsListOfStrings, T rowObject) {
                Object cellData = DefaultGlazedListsFilterStrategy.this.columnAccessor.getDataValue(rowObject, columnIndex.intValue());
                Object displayValue = converter.canonicalToDisplayValue(cellData);
                displayValue = displayValue != null ? displayValue : "";
                objectAsListOfStrings.add(displayValue.toString());
            }
        };
    }

    public int getGlazedListsTextMatcherEditorMode(TextMatchingMode textMatchingMode) {
        switch (textMatchingMode) {
            case EXACT: {
                return 3;
            }
            case STARTS_WITH: {
                return 1;
            }
            case REGULAR_EXPRESSION: {
                return 2;
            }
        }
        return 0;
    }

    protected boolean containsMatcherEditor(List<MatcherEditor<T>> existingMatcherEditors, MatcherEditor<T> matcherEditor) {
        boolean result = false;
        Iterator<MatcherEditor<T>> existingMatcherEditorsIterator = existingMatcherEditors.iterator();
        while (existingMatcherEditorsIterator.hasNext() && !result) {
            result = this.matcherEditorEqual(existingMatcherEditorsIterator.next(), matcherEditor);
        }
        return result;
    }

    protected boolean matcherEditorEqual(MatcherEditor<T> first, MatcherEditor<T> second) {
        boolean result = false;
        if (first.getClass().equals(second.getClass())) {
            if (first instanceof CompositeMatcherEditor) {
                CompositeMatcherEditor firstComp = (CompositeMatcherEditor)first;
                CompositeMatcherEditor secondComp = (CompositeMatcherEditor)second;
                result = firstComp.getMatcherEditors().size() == secondComp.getMatcherEditors().size();
                Iterator matcherEditors = firstComp.getMatcherEditors().iterator();
                while (matcherEditors.hasNext() && result) {
                    Iterator iterator = secondComp.getMatcherEditors().iterator();
                    boolean found = false;
                    while (iterator.hasNext() && !found) {
                        found = this.matcherEditorEqual((MatcherEditor)iterator.next(), (MatcherEditor)matcherEditors.next());
                    }
                    result = found;
                }
            } else if (first instanceof TextMatcherEditor) {
                TextMatcherEditor firstText = (TextMatcherEditor)first;
                TextMatcherEditor secondText = (TextMatcherEditor)second;
                result = first.getMatcher().equals(second.getMatcher()) && firstText.getMode() == secondText.getMode() && firstText.getStrategy().equals(secondText.getStrategy());
            } else if (first instanceof ThresholdMatcherEditor) {
                ThresholdMatcherEditor firstThreshold = (ThresholdMatcherEditor)first;
                ThresholdMatcherEditor secondThreshold = (ThresholdMatcherEditor)second;
                result = firstThreshold.getThreshold().equals(secondThreshold.getThreshold()) && firstThreshold.getComparator().equals(secondThreshold.getComparator()) && firstThreshold.getMatchOperation() == secondThreshold.getMatchOperation();
            }
        }
        return result;
    }

    public CompositeMatcherEditor<T> getMatcherEditor() {
        return this.matcherEditor;
    }
}

