/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import ch.rgw.io.CfgSettings;
import ch.rgw.io.Messages;
import ch.rgw.io.Settings;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Log;
import ch.rgw.tools.StringTool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.h2.util.IOUtils;

public class FileTool {
    private static final Log log = Log.get("FileTool");
    public static String DIRECTORY_SEPARATOR = File.separator;
    public static final String ZIP_EXTENSION = ".gz";
    public static final int REPLACE_IF_EXISTS = 0;
    public static final int BACKUP_IF_EXISTS = 1;
    public static final int FAIL_IF_EXISTS = 2;

    public static String Version() {
        return "1.4.0";
    }

    private static String getCorrectSeparators(String pathOrFilename) {
        return pathOrFilename.replace("\\", DIRECTORY_SEPARATOR).replace("//", DIRECTORY_SEPARATOR).replace("/", DIRECTORY_SEPARATOR);
    }

    private static String removeMultipleSeparators(String pathOrFilename) {
        String doubleSeparator = String.valueOf(DIRECTORY_SEPARATOR) + DIRECTORY_SEPARATOR;
        while (pathOrFilename.indexOf(doubleSeparator) >= 0) {
            pathOrFilename = pathOrFilename.replaceAll(doubleSeparator, DIRECTORY_SEPARATOR);
        }
        return pathOrFilename;
    }

    public static String getFilepath(String filenamePath) {
        String correctFilenamePath = FileTool.getCorrectSeparators(filenamePath);
        if (correctFilenamePath.indexOf(DIRECTORY_SEPARATOR) < 0) {
            return "";
        }
        return correctFilenamePath.substring(0, correctFilenamePath.lastIndexOf(DIRECTORY_SEPARATOR));
    }

    public static String getFilename(String filenamePath) {
        String correctFilenamePath = FileTool.getCorrectSeparators(filenamePath);
        if (correctFilenamePath.indexOf(DIRECTORY_SEPARATOR) < 0) {
            return filenamePath;
        }
        return correctFilenamePath.substring(correctFilenamePath.lastIndexOf(DIRECTORY_SEPARATOR) + 1, correctFilenamePath.length());
    }

    public static String getNakedFilename(String filenamePath) {
        String filename = FileTool.getFilename(filenamePath);
        if (filename.lastIndexOf(".") > 0) {
            return filename.substring(0, filename.lastIndexOf("."));
        }
        return filename;
    }

    public static String getExtension(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    public static void checkCreatePath(String path) throws IllegalArgumentException {
        File dir = new File(path);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Eingabe ist kein gueltiges Verzeichnis", null);
            }
        } else if (!dir.mkdirs()) {
            throw new IllegalArgumentException("Verzeichnis <" + path + "> kann nicht erstellt werden!", null);
        }
    }

    public static String getCorrectPath(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Bitte geben Sie ein Verzeichnis ein!", null);
        }
        path = FileTool.getCorrectSeparators(path);
        if (!(path = FileTool.removeMultipleSeparators(path)).endsWith(DIRECTORY_SEPARATOR)) {
            path = String.valueOf(path) + DIRECTORY_SEPARATOR;
        }
        return path;
    }

    public static boolean doesFileExist(String filePathName) {
        if (filePathName == null) {
            return false;
        }
        File file = new File(filePathName);
        return file.isFile() && file.exists();
    }

    public static boolean isRootDir(String dir) {
        return dir.startsWith(DIRECTORY_SEPARATOR) || dir.indexOf(":") > 0;
    }

    public static boolean deleteFile(String filePathName) throws IllegalArgumentException {
        if (FileTool.doesFileExist(filePathName)) {
            File file = new File(filePathName);
            return file.delete();
        }
        return true;
    }

    public static byte[] readZippedFile(String filenamePath) throws IOException {
        byte[] daten = new byte[1024];
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Throwable throwable = null;
            Object var4_5 = null;
            try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(filenamePath));){
                int read = 0;
                while ((read = in.read(daten, 0, 1024)) != -1) {
                    out.write(daten, 0, read);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return out.toByteArray();
    }

    public static String getBasePath(Class clazz) {
        String raw = FileTool.getClassPath(clazz);
        if (raw == null) {
            return ".";
        }
        String found = null;
        Pattern p = Pattern.compile(".*?file:(\\/{1,2})(.+?)[^\\\\\\/]+\\.(jar|class).*");
        Matcher m = p.matcher(raw);
        if (m.matches()) {
            found = m.group(2);
            if (found.matches("[a-zA-Z]:.+")) {
                return found;
            }
            return String.valueOf(m.group(1)) + found;
        }
        return found;
    }

    public static String getClassPath(Class clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            return null;
        }
        URL url = loader.getResource(String.valueOf(clazz.getName().replace('.', '/')) + ".class");
        return url != null ? url.toString() : null;
    }

    public static boolean copyFile(File src, File dest, int if_exists) {
        if (!src.canRead()) {
            log.log(MessageFormat.format(Messages.FileTool_cantReadSource, src.getAbsolutePath()), 2);
            return false;
        }
        if (dest.exists()) {
            String pname = dest.getAbsolutePath();
            if (pname.equalsIgnoreCase(src.getAbsolutePath())) {
                return true;
            }
            switch (if_exists) {
                case 0: {
                    if (dest.delete()) break;
                    log.log(MessageFormat.format(Messages.FileTool_cantDeleteTarget, dest.getAbsolutePath()), 2);
                    return false;
                }
                case 1: {
                    File bak = new File(String.valueOf(pname) + ".bak");
                    if (bak.exists() && !bak.delete()) {
                        log.log(MessageFormat.format(Messages.FileTool_backupExists, bak.getAbsolutePath()), 2);
                        return false;
                    }
                    if (!dest.renameTo(bak)) {
                        log.log(MessageFormat.format(Messages.FileTool_cantRenameTarget, bak.getAbsolutePath()), 2);
                        return false;
                    }
                    dest = new File(pname);
                    break;
                }
                case 2: {
                    log.log(MessageFormat.format(Messages.FileTool_targetExists, dest.getAbsolutePath()), 2);
                    return false;
                }
                default: {
                    log.log(MessageFormat.format(Messages.FileTool_badCopyMode, src.getAbsolutePath(), if_exists), 2);
                    return false;
                }
            }
        }
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            if (!dest.createNewFile()) {
                log.log(MessageFormat.format(Messages.FileTool_couldnotcreate, dest.getAbsolutePath()), 2);
                return false;
            }
            if (!dest.canWrite()) {
                log.log(MessageFormat.format(Messages.FileTool_cantWriteTarget, dest.getAbsolutePath()), 2);
                return false;
            }
            try {
                int r;
                bos = new BufferedOutputStream(new FileOutputStream(dest));
                bis = new BufferedInputStream(new FileInputStream(src));
                byte[] buffer = new byte[131072];
                while ((r = bis.read(buffer)) != -1) {
                    ((BufferedOutputStream)bos).write(buffer, 0, r);
                }
            }
            catch (IOException ex) {
                ExHandler.handle(ex);
                log.log(MessageFormat.format(Messages.FileTool_cantCopy, dest.getAbsolutePath(), ex.getMessage()), 2);
                return false;
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                log.log(e.getMessage(), 3);
            }
        }
        return true;
    }

    public static void copyStreams(InputStream is, OutputStream os) throws IOException {
        FileTool.copyStreamsWithChecksum(is, os, null);
    }

    public static byte[] copyStreamsWithChecksum(InputStream is, OutputStream os, String algo) throws IOException {
        int r;
        MessageDigest md = null;
        if (algo != null) {
            try {
                md = MessageDigest.getInstance(algo);
            }
            catch (NoSuchAlgorithmException e) {
                log.log(e.getMessage(), 3);
            }
        }
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        bos = new BufferedOutputStream(os);
        bis = new BufferedInputStream(is);
        byte[] buffer = new byte[65535];
        while ((r = bis.read(buffer)) != -1) {
            if (md != null) {
                md.update(buffer, 0, r);
            }
            bos.write(buffer, 0, r);
        }
        bos.flush();
        if (md == null) {
            return null;
        }
        return md.digest();
    }

    public static byte[] readFile(File file) throws IOException {
        byte[] daten = null;
        try (FileInputStream input = null;){
            input = new FileInputStream(file);
            daten = new byte[input.available()];
            input.read(daten);
        }
        return daten;
    }

    public static String readTextFile(File file) throws IOException {
        return FileTool.readTextFile(file, Charset.defaultCharset().name());
    }

    public static String readTextFile(File file, String charsetName) throws IOException {
        byte[] text = FileTool.readFile(file);
        return new String(text, charsetName);
    }

    public static void writeFile(File file, byte[] daten) throws IOException {
        try (FileOutputStream output = null;){
            output = new FileOutputStream(file);
            output.write(daten);
        }
    }

    public static void writeTextFile(File file, String text) throws IOException {
        if (text != null) {
            try (BufferedWriter bw = null;){
                bw = new BufferedWriter(new FileWriter(file));
                bw.write(text);
            }
        }
    }

    public static boolean deltree(String d) {
        File f = new File(d);
        boolean res = true;
        if (f.exists()) {
            if (f.isDirectory()) {
                String[] subs;
                String[] stringArray = subs = f.list();
                int n = subs.length;
                int n2 = 0;
                while (n2 < n) {
                    String sub = stringArray[n2];
                    if (!FileTool.deltree(String.valueOf(f.getAbsolutePath()) + File.separator + sub)) {
                        res = false;
                    }
                    ++n2;
                }
            }
            if (!f.delete()) {
                res = false;
            }
        }
        return res;
    }

    public static File resolveFile(String filepath) {
        Pattern p = Pattern.compile("%(.+?)%");
        Matcher m = p.matcher(filepath);
        Settings env = CfgSettings.open(".environment", "System Environment f\u00fcr java");
        while (m.find()) {
            String f = m.group(1);
            String rep = env.get(f, "");
            if (StringTool.isNothing(rep)) {
                rep = System.getenv(f);
            }
            filepath = m.replaceFirst(rep);
        }
        log.log("Abgeleiteter Pfadname: " + filepath, 5);
        return new File(filepath);
    }

    public static byte[] checksum(File file) {
        try {
            int num;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            FileInputStream in = new FileInputStream(file);
            byte[] arr = new byte[65535];
            while ((num = in.read(arr)) != -1) {
                md5.update(arr, 0, num);
                if (num == arr.length) continue;
            }
            in.close();
            byte[] ret = new byte[16];
            md5.digest(ret, 0, 16);
            return ret;
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public static final void unzip(String filenamePath) throws IOException {
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        if (filenamePath == null || filenamePath.length() == 0) {
            throw new IllegalArgumentException("No file to unzip!");
        }
        String baseZipDirName = FileTool.getFilepath(filenamePath);
        String unzippedDirName = FileTool.getNakedFilename(filenamePath);
        String baseUnzippedDirName = String.valueOf(FileTool.getFilepath(filenamePath)) + DIRECTORY_SEPARATOR + unzippedDirName;
        File baseUnzippedDir = new File(baseUnzippedDirName);
        if (!baseUnzippedDir.exists()) {
            baseUnzippedDir.mkdirs();
        }
        FileInputStream fileInputstream = null;
        ZipInputStream zipIn = null;
        try {
            ZipEntry entry;
            fileInputstream = new FileInputStream(filenamePath);
            zipIn = new ZipInputStream(new BufferedInputStream(fileInputstream));
            while ((entry = zipIn.getNextEntry()) != null) {
                String entryFilename;
                File entryPath;
                String entryPathname;
                String entryFilenamePath = entry.getName();
                if (!entryFilenamePath.startsWith(unzippedDirName)) {
                    entryFilenamePath = String.valueOf(unzippedDirName) + DIRECTORY_SEPARATOR + entryFilenamePath;
                }
                if ((entryPathname = FileTool.getFilepath(entryFilenamePath)) != null && entryPathname.length() > 0 && !(entryPath = new File(String.valueOf(baseZipDirName) + DIRECTORY_SEPARATOR + entryPathname)).exists()) {
                    entryPath.mkdirs();
                }
                if ((entryFilename = FileTool.getFilename(entryFilenamePath)) == null || entryFilename.length() <= 0) continue;
                File outputFile = new File(String.valueOf(baseZipDirName) + DIRECTORY_SEPARATOR + entryFilenamePath);
                if (!outputFile.exists()) {
                    outputFile.createNewFile();
                }
                FilterOutputStream dest = null;
                FileOutputStream fileOutputstream = null;
                try {
                    int count;
                    fileOutputstream = new FileOutputStream(outputFile);
                    dest = new BufferedOutputStream(fileOutputstream, 2048);
                    while ((count = zipIn.read(data, 0, 2048)) != -1) {
                        ((BufferedOutputStream)dest).write(data, 0, count);
                    }
                    ((BufferedOutputStream)dest).flush();
                }
                finally {
                    if (fileOutputstream != null) {
                        fileOutputstream.close();
                    }
                    if (dest != null) {
                        dest.close();
                    }
                }
            }
        }
        finally {
            if (fileInputstream != null) {
                fileInputstream.close();
            }
            if (zipIn != null) {
                zipIn.close();
            }
        }
    }

    public static final void unjar(String filenamePath) throws IOException {
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        if (filenamePath == null || filenamePath.length() == 0) {
            throw new IllegalArgumentException("No file to unjar!");
        }
        String baseJarDirName = FileTool.getFilepath(filenamePath);
        String unjaredDirName = FileTool.getNakedFilename(filenamePath);
        String baseUnjaredDirName = String.valueOf(FileTool.getFilepath(filenamePath)) + DIRECTORY_SEPARATOR + unjaredDirName;
        File baseUnjaredDir = new File(baseUnjaredDirName);
        if (!baseUnjaredDir.exists()) {
            baseUnjaredDir.mkdirs();
        }
        FileInputStream fileInputstream = null;
        ZipInputStream jarIn = null;
        try {
            JarEntry entry;
            fileInputstream = new FileInputStream(filenamePath);
            jarIn = new JarInputStream(new BufferedInputStream(fileInputstream));
            while ((entry = ((JarInputStream)jarIn).getNextJarEntry()) != null) {
                String entryFilename;
                File entryPath;
                String entryPathname;
                String entryFilenamePath = entry.getName();
                if (!entryFilenamePath.startsWith(unjaredDirName)) {
                    entryFilenamePath = String.valueOf(unjaredDirName) + DIRECTORY_SEPARATOR + entryFilenamePath;
                }
                if ((entryPathname = FileTool.getFilepath(entryFilenamePath)) != null && entryPathname.length() > 0 && !(entryPath = new File(String.valueOf(baseJarDirName) + DIRECTORY_SEPARATOR + entryPathname)).exists()) {
                    entryPath.mkdirs();
                }
                if ((entryFilename = FileTool.getFilename(entryFilenamePath)) == null || entryFilename.length() <= 0) continue;
                File outputFile = new File(String.valueOf(baseJarDirName) + DIRECTORY_SEPARATOR + entryFilenamePath);
                if (!outputFile.exists()) {
                    outputFile.createNewFile();
                }
                FilterOutputStream dest = null;
                FileOutputStream fileOutputstream = null;
                try {
                    int count;
                    fileOutputstream = new FileOutputStream(outputFile);
                    dest = new BufferedOutputStream(fileOutputstream, 2048);
                    while ((count = ((JarInputStream)jarIn).read(data, 0, 2048)) != -1) {
                        ((BufferedOutputStream)dest).write(data, 0, count);
                    }
                    ((BufferedOutputStream)dest).flush();
                }
                finally {
                    if (fileOutputstream != null) {
                        fileOutputstream.close();
                    }
                    if (dest != null) {
                        dest.close();
                    }
                }
            }
        }
        finally {
            if (fileInputstream != null) {
                fileInputstream.close();
            }
            if (jarIn != null) {
                jarIn.close();
            }
        }
    }

    private static void addFileToJar(String path, File source, JarOutputStream target) throws IOException {
        if (source.isDirectory()) {
            String directory = FileTool.getFilename(source.getPath());
            if (directory.length() > 0) {
                directory = String.valueOf(directory) + "/";
                JarEntry entry = new JarEntry(String.valueOf(path) + directory);
                entry.setTime(source.lastModified());
                target.putNextEntry(entry);
                target.closeEntry();
            }
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File nestedFile = fileArray[n2];
                FileTool.addFileToJar(String.valueOf(path) + directory, nestedFile, target);
                ++n2;
            }
        } else {
            String filename = FileTool.getFilename(source.getPath());
            JarEntry entry = new JarEntry(String.valueOf(path) + filename);
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            new BufferedInputStream(new FileInputStream(source));
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
                int count;
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    target.write(buffer, 0, count);
                }
                target.closeEntry();
            }
        }
    }

    private static void addFileToJar(File source, JarOutputStream target) throws IOException {
        FileTool.addFileToJar("", source, target);
    }

    public static byte[] asJar(String directoryPath) throws IOException {
        String jarFilenamePath = String.valueOf(directoryPath) + ".jar";
        try (ZipOutputStream jos = null;){
            jos = new JarOutputStream(new FileOutputStream(jarFilenamePath));
            File directory = new File(directoryPath);
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileTool.addFileToJar(file, (JarOutputStream)jos);
                ++n2;
            }
        }
        byte[] jarContent = FileTool.readFile(new File(jarFilenamePath));
        FileTool.deleteFile(jarFilenamePath);
        return jarContent;
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            int i = 0;
            while (i < children.length) {
                FileTool.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
                ++i;
            }
        } else {
            log.log("Copy file: " + srcDir.getPath() + " to " + dstDir.getPath(), 5);
            FileTool.copyFile(new File(srcDir.getPath()), new File(dstDir.getPath()), 0);
        }
    }

    public static void unzip(File zipFile, File unzipDir) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile file = new ZipFile(zipFile);){
            FileSystem fileSystem = FileSystems.getDefault();
            Enumeration<? extends ZipEntry> entries = file.entries();
            String uncompressedDirectory = unzipDir.getAbsolutePath();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    Files.createDirectories(fileSystem.getPath(String.valueOf(uncompressedDirectory) + entry.getName(), new String[0]), new FileAttribute[0]);
                    continue;
                }
                Throwable throwable2 = null;
                Object var10_13 = null;
                try {
                    InputStream is = file.getInputStream(entry);
                    try {
                        try (BufferedInputStream bis = new BufferedInputStream(is);){
                            String uncompressedFileName = String.valueOf(uncompressedDirectory) + File.separator + entry.getName();
                            Path uncompressedFilePath = fileSystem.getPath(uncompressedFileName, new String[0]);
                            Files.createDirectories(uncompressedFilePath.getParent(), new FileAttribute[0]);
                            Files.createFile(uncompressedFilePath, new FileAttribute[0]);
                            Throwable throwable3 = null;
                            Object var16_22 = null;
                            try (FileOutputStream fileOutput = new FileOutputStream(uncompressedFileName);){
                                IOUtils.copy((InputStream)bis, (OutputStream)fileOutput);
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        if (is == null) continue;
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        if (is != null) {
                            is.close();
                        }
                        throw throwable2;
                    }
                    is.close();
                }
                catch (Throwable throwable6) {
                    if (throwable2 == null) {
                        throwable2 = throwable6;
                    } else if (throwable2 != throwable6) {
                        throwable2.addSuppressed(throwable6);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
    }
}

