/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.utils;

import ch.elexis.core.common.DBConnection;
import ch.elexis.core.jdt.NonNull;
import ch.rgw.io.Settings;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.io.ObjectStreamClass;
import java.util.Hashtable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreUtil {
    private static Logger logger = LoggerFactory.getLogger(CoreUtil.class);
    private static final OS osType;
    public static final String TEST_MODE = "elexis.test.mode";

    static {
        String osName = System.getProperty("os.name");
        osType = osName.startsWith("Linux") ? OS.LINUX : (osName.startsWith("Mac") || osName.startsWith("Darwin") ? OS.MAC : (osName.startsWith("Windows") ? OS.WINDOWS : OS.UNSPECIFIED));
    }

    public static boolean isTestMode() {
        String testMode = System.getProperty(TEST_MODE);
        return testMode != null && !testMode.isEmpty() && testMode.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public static Optional<DBConnection> getDBConnection(Settings settings) {
        if ("RunFromScratch".equals(System.getProperty("elexis-run-mode"))) {
            DBConnection ret = new DBConnection();
            ret.connectionString = "jdbc:h2:mem:elexisFromScratch;DB_CLOSE_DELAY=-1";
            String trace = System.getProperty("elexis.test.dbtrace");
            if (trace != null && "true".equalsIgnoreCase(trace)) {
                ret.connectionString = String.valueOf(ret.connectionString) + ";TRACE_LEVEL_SYSTEM_OUT=2";
            }
            ret.rdbmsType = DBConnection.DBType.H2;
            ret.username = "sa";
            ret.password = "";
            return Optional.of(ret);
        }
        if (System.getProperty("ch.elexis.dbSpec") != null) {
            DBConnection dbConnection = new DBConnection();
            dbConnection.username = System.getProperty("ch.elexis.dbUser") != null ? System.getProperty("ch.elexis.dbUser") : "";
            String string = dbConnection.password = System.getProperty("ch.elexis.dbPw") != null ? System.getProperty("ch.elexis.dbPw") : "";
            if (System.getProperty("ch.elexis.dbFlavor") != null) {
                String flavorString = System.getProperty("ch.elexis.dbFlavor");
                dbConnection.rdbmsType = DBConnection.DBType.valueOfIgnoreCase(flavorString).orElseThrow(() -> new IllegalStateException("Unknown ch.elexis.dbFlavor [" + flavorString + "]"));
            }
            dbConnection.connectionString = System.getProperty("ch.elexis.dbSpec") != null ? System.getProperty("ch.elexis.dbSpec") : "";
            return Optional.of(dbConnection);
        }
        Hashtable<Object, Object> hConn = CoreUtil.getConnectionHashtable(settings);
        if (hConn != null) {
            DBConnection ret = new DBConnection();
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("connectionstring")))) {
                String url = (String)hConn.get("connectionstring");
                ret.connectionString = url = CoreUtil.applyMySqlTimeZoneWorkaround(url);
                DBConnection.getHostName(url).ifPresent(h -> {
                    String string = dBConnection.hostName = h;
                });
                DBConnection.getDatabaseName(url).ifPresent(db -> {
                    String string = dBConnection.databaseName = db;
                });
            }
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("user")))) {
                ret.username = (String)hConn.get("user");
            }
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("pwd")))) {
                ret.password = (String)hConn.get("pwd");
            }
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("driver")))) {
                Optional<DBConnection.DBType> type = DBConnection.DBType.valueOfDriver((String)hConn.get("driver"));
                type.ifPresent(t -> {
                    DBConnection.DBType dBType = dBConnection.rdbmsType = t;
                });
            }
            if (ret.allValuesSet()) {
                return Optional.of(ret);
            }
            StringBuilder sb = new StringBuilder();
            for (Object object : hConn.keySet()) {
                if (!(object instanceof String)) continue;
                sb.append("\n").append(object).append("->").append(hConn.get(object));
            }
            logger.error("Could not get a valid DBConnection from connection setting:" + sb.toString());
        }
        return Optional.empty();
    }

    private static String applyMySqlTimeZoneWorkaround(String dbConnectString) {
        if (dbConnectString.startsWith("jdbc:mysql:") && !dbConnectString.contains("serverTimezone")) {
            dbConnectString = dbConnectString.contains("?") ? String.valueOf(dbConnectString) + "&serverTimezone=Europe/Zurich" : String.valueOf(dbConnectString) + "?serverTimezone=Europe/Zurich";
            logger.info("MySQL dbConnection string correction [{}]", (Object)dbConnectString);
        }
        return dbConnectString;
    }

    @NonNull
    public static Hashtable<Object, Object> getConnectionHashtable(Settings settings) {
        Hashtable<Object, Object> ret = new Hashtable<Object, Object>();
        String cnt = settings.get("verbindung/folded_string", null);
        if (cnt != null) {
            ret = CoreUtil.fold(StringTool.dePrintable((String)cnt));
        }
        return ret;
    }

    private static Hashtable<Object, Object> fold(byte[] flat) {
        return (Hashtable)CoreUtil.foldObject(flat);
    }

    private static Object foldObject(byte[] flat) {
        return CoreUtil.foldObject(flat, null);
    }

    /*
     * Exception decompiling
     */
    private static Object foldObject(byte[] flat, IClassResolver resolver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File getWritableUserDir() {
        File userDir;
        String userhome = null;
        if (userhome == null) {
            userhome = System.getProperty("user.home");
        }
        if (StringTool.isNothing(userhome)) {
            userhome = System.getProperty("java.io.tempdir");
        }
        if (!(userDir = new File(userhome, "elexis")).exists() && !userDir.mkdirs()) {
            logger.error("Panic exit, could not create userdir " + userDir.getAbsolutePath());
            System.exit(-5);
        }
        return userDir;
    }

    public static File getTempDir() {
        File ret = null;
        String temp = System.getProperty("java.io.tmpdir");
        if (!StringTool.isNothing((Object)temp)) {
            ret = new File(temp);
            if (ret.exists() && ret.isDirectory()) {
                return ret;
            }
            if (ret.mkdirs()) {
                return ret;
            }
        }
        return CoreUtil.getWritableUserDir();
    }

    public static final OS getOperatingSystemType() {
        return osType;
    }

    public static final boolean isWindows() {
        return osType == OS.WINDOWS;
    }

    public static final boolean isMac() {
        return osType == OS.MAC;
    }

    public static final boolean isLinux() {
        return osType == OS.LINUX;
    }

    private static interface IClassResolver {
        public Class<?> resolveClass(ObjectStreamClass var1) throws ClassNotFoundException;
    }

    public static enum OS {
        UNSPECIFIED,
        MAC,
        LINUX,
        WINDOWS;

    }
}

