/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.utils.CoreUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public interface IVirtualFilesystemService {
    public IVirtualFilesystemHandle of(String var1) throws IOException;

    public IVirtualFilesystemHandle of(File var1) throws IOException;

    public static String hidePasswordInUrlString(String urlString) {
        URI url;
        if (urlString.startsWith("\\\\") || urlString.startsWith("/")) {
            return urlString;
        }
        try {
            url = new URI(urlString);
        }
        catch (URISyntaxException e) {
            return e.getMessage();
        }
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            return url.toString();
        }
        String replacement = String.valueOf(userInfo.substring(0, userInfo.indexOf(58))) + ":***";
        return urlString.replace(userInfo, replacement);
    }

    public static URI stringToURI(String value) throws URISyntaxException, MalformedURLException {
        String replaced;
        if ((value = value.replaceAll("%20", " ")).length() > 2 && value.charAt(1) == ':') {
            replaced = value.replace("\\", "/");
            value = "file://" + replaced;
        }
        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"\\\\")) {
            replaced = value.replace("\\", "/");
            value = CoreUtil.isWindows() ? "file://" + replaced : "smb:" + replaced;
        }
        if (value.startsWith("/")) {
            value = "file:" + value;
        }
        URL url = new URL(value);
        String path = url.getPath();
        if (url.getRef() != null) {
            path = String.valueOf(path) + "#" + url.getRef();
        }
        if (url.getAuthority() != null && url.getAuthority().length() > 0 && url.getAuthority().charAt(1) == ':') {
            URI uri = new URI("file", url.getAuthority(), url.getPath(), url.getQuery(), null);
            return uri;
        }
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), path, url.getQuery(), null);
        return uri;
    }

    public static interface IVirtualFilesystemHandle {
        public InputStream openInputStream() throws IOException;

        public OutputStream openOutputStream() throws IOException;

        public byte[] readAllBytes() throws IOException;

        public long getContentLenght() throws IOException;

        public IVirtualFilesystemHandle copyTo(IVirtualFilesystemHandle var1) throws IOException;

        public IVirtualFilesystemHandle getParent() throws IOException;

        public IVirtualFilesystemHandle[] listHandles(IVirtualFilesystemhandleFilter var1) throws IOException;

        public IVirtualFilesystemHandle[] listHandles() throws IOException;

        public void delete() throws IOException;

        public boolean isDirectory() throws IOException;

        public URL toURL();

        public URI getURI();

        public Optional<File> toFile();

        public String getExtension();

        public boolean exists() throws IOException;

        public String getName();

        public boolean canRead();

        public boolean canWrite();

        public String getAbsolutePath();

        public IVirtualFilesystemHandle moveTo(IVirtualFilesystemHandle var1) throws IOException;

        public IVirtualFilesystemHandle subDir(String var1) throws IOException;

        public IVirtualFilesystemHandle subFile(String var1) throws IOException;

        public IVirtualFilesystemHandle mkdir() throws IOException;
    }

    @FunctionalInterface
    public static interface IVirtualFilesystemhandleFilter {
        public boolean accept(IVirtualFilesystemHandle var1);
    }
}

