/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions.dialogs;

import ch.elexis.data.BillingSystem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameAccountingSysFieldDialog
extends TitleAreaDialog {
    private Text txtNewName;
    private ComboViewer cViewerAccSys;
    private ComboViewer cViewerField;
    private String[] accSystems = BillingSystem.getAbrechnungsSysteme();
    private String accountingSystem;
    private String presentFieldName;
    private String newFieldName;

    public RenameAccountingSysFieldDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Abrechnungssystem - Feld umbenennen");
        this.setMessage("Bitte Feld w\u00e4hlen und neuen Namen definieren");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite area = new Composite(container, 0);
        area.setLayoutData((Object)new GridData(1808));
        area.setLayout((Layout)new GridLayout(2, false));
        Label lblAccountingsys = new Label(area, 0);
        lblAccountingsys.setText("Abrechnungssystem");
        this.cViewerAccSys = new ComboViewer(area, 8);
        Combo cmbAccSys = this.cViewerAccSys.getCombo();
        cmbAccSys.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cViewerAccSys.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cViewerAccSys.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cViewerAccSys.setInput((Object)this.accSystems);
        this.cViewerAccSys.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    String selSystem = (String)selection.getFirstElement();
                    ArrayList availableFields = new ArrayList();
                    availableFields.addAll(RenameAccountingSysFieldDialog.this.parseNamelist(BillingSystem.getOptionals((String)selSystem)));
                    availableFields.addAll(RenameAccountingSysFieldDialog.this.parseNamelist(BillingSystem.getRequirements((String)selSystem)));
                    RenameAccountingSysFieldDialog.this.cViewerField.setInput(availableFields);
                }
            }
        });
        Label lblField = new Label(area, 0);
        lblField.setText("Feld");
        this.cViewerField = new ComboViewer(area, 8);
        Combo cmbField = this.cViewerField.getCombo();
        cmbField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cViewerField.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cViewerField.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cViewerField.setInput((Object)"");
        Label lblNewName = new Label(area, 0);
        lblNewName.setText("Umbenennen zu");
        this.txtNewName = new Text(area, 2048);
        this.txtNewName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.accSystems.length > 0) {
            this.cViewerAccSys.setSelection((ISelection)new StructuredSelection((Object)this.accSystems[0]));
        }
        return area;
    }

    private List<String> parseNamelist(String fields) {
        String[] fieldArray;
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (fields == null || fields.isEmpty()) {
            return fieldNames;
        }
        String[] stringArray = fieldArray = fields.split(";");
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            String[] split = field.split(":");
            fieldNames.add(split[0]);
            System.out.println("added field name: " + split[0]);
            ++n2;
        }
        return fieldNames;
    }

    protected void okPressed() {
        IStructuredSelection selField;
        IStructuredSelection selAccSys = (IStructuredSelection)this.cViewerAccSys.getSelection();
        if (!selAccSys.isEmpty()) {
            this.accountingSystem = (String)selAccSys.getFirstElement();
        }
        if (!(selField = (IStructuredSelection)this.cViewerField.getSelection()).isEmpty()) {
            this.presentFieldName = (String)selField.getFirstElement();
        }
        this.newFieldName = this.txtNewName.getText();
        String[] fields = new String[]{this.accountingSystem, this.presentFieldName, this.newFieldName};
        if (this.validFields(fields)) {
            super.okPressed();
        } else {
            MessageDialog.openWarning((Shell)this.getParentShell(), (String)"Unvollst\u00e4ndig", (String)"Bitte alle Felder ausw\u00e4hlen bzw. ausf\u00fcllen");
        }
    }

    private boolean validFields(String[] fields) {
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (field == null || field.isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getAccountingSystem() {
        return this.accountingSystem;
    }

    public String getPresentFieldName() {
        return this.presentFieldName;
    }

    public String getNewFieldName() {
        return this.newFieldName;
    }
}

