/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.VerrechnetCopy;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class RemoveVatFromVerrechnet
extends ExternalMaintenance {
    private String tarifTyp;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder sb = new StringBuilder();
        this.tarifTyp = null;
        Display.getDefault().syncExec(() -> {
            MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "MWST 0 setzen", null, "F\u00fcr welchen verrechneten Leistungs-Typ soll die MWST 0 gesetzt werden?", 3, 0, new String[]{"Pandemie", "Tarmed"});
            int selection = dialog.open();
            this.tarifTyp = this.getTarifTyp(selection);
        });
        if (StringUtils.isNotBlank((String)this.tarifTyp)) {
            sb.append("Ausgew\u00e4hlter Leistungs-Typ [" + this.tarifTyp + "]\n\n");
            int updateCnt = 0;
            Query query = new Query(Verrechnet.class);
            query.add("Klasse", "=", this.tarifTyp);
            List existing = query.execute();
            pm.beginTask("MWST 0 bei Leistungen", existing.size());
            for (Verrechnet verrechnet : existing) {
                String value = verrechnet.getDetail("vat_scale");
                if (value != null && !value.isEmpty() && !"0.0".equals(value)) {
                    verrechnet.setDetail("vat_scale", Double.toString(0.0));
                    ++updateCnt;
                }
                pm.worked(1);
            }
            sb.append("Es wurden " + updateCnt + " verrechnete Leistungen von " + existing.size() + " MWST 0 gesetzt");
            updateCnt = 0;
            Query queryCopy = new Query(VerrechnetCopy.class);
            queryCopy.add("Klasse", "=", this.tarifTyp);
            List existingCopy = queryCopy.execute();
            pm.beginTask("MWST 0 bei Kopien der Leistungen", existing.size());
            for (VerrechnetCopy verrechnetCopy : existingCopy) {
                String value = verrechnetCopy.getDetail("vat_scale");
                if (value != null && !value.isEmpty() && !"0.0".equals(value)) {
                    verrechnetCopy.setDetail("vat_scale", Double.toString(0.0));
                    ++updateCnt;
                }
                pm.worked(1);
            }
            sb.append("\nEs wurden " + updateCnt + " Kopien der Leistungen von " + existingCopy.size() + " MWST 0 gesetzt");
        } else {
            sb.append("Unbekannter Tarif Typ");
        }
        return sb.toString();
    }

    private String getTarifTyp(int selection) {
        if (selection == 0) {
            return "ch.elexis.data.PandemieLeistung";
        }
        if (selection == 1) {
            return "ch.elexis.data.TarmedLeistung";
        }
        return null;
    }

    @Override
    public String getMaintenanceDescription() {
        return "MWST aller verrechneten Leistungen eines Typs 0 setzen";
    }
}

