/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.svrl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.error.ResourceLocation;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.svrl.SVRLLocationBeautifierRegistry;
import com.phloc.schematron.svrl.SVRLResourceError;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.oclc.purl.dsdl.svrl.DiagnosticReference;

@Immutable
public abstract class AbstractSVRLMessage {
    protected List<DiagnosticReference> m_aDiagnosticReferences;
    protected String m_sText;
    protected String m_sLocation;
    protected String m_sTest;
    protected String m_sRole;
    protected EErrorLevel m_eFlag;

    @Nonnull
    protected static String getBeautifiedLocation(@Nonnull String string) {
        String string2 = string;
        Matcher matcher = RegExHelper.getMatcher((String)"\\Q*:\\E([a-zA-Z0-9_]+)\\Q[namespace-uri()='\\E([^']+)\\Q']\\E", (String)string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            String string5 = SVRLLocationBeautifierRegistry.getBeautifiedLocation(string4, string3);
            if (string5 == null) continue;
            string2 = string2.replace(matcher.group(), string5);
        }
        return string2;
    }

    public AbstractSVRLMessage() {
    }

    public AbstractSVRLMessage(@Nullable List<DiagnosticReference> list, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable EErrorLevel eErrorLevel) {
        this.m_aDiagnosticReferences = ContainerHelper.newList(list);
        this.m_sText = string;
        this.m_sLocation = string2;
        this.m_sTest = string3;
        this.m_sRole = string4;
        this.m_eFlag = eErrorLevel;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<DiagnosticReference> getDiagnisticReferences() {
        return ContainerHelper.newList(this.m_aDiagnosticReferences);
    }

    @Nullable
    public String getText() {
        return this.m_sText;
    }

    @Nullable
    public String getLocation() {
        return this.m_sLocation;
    }

    @Nullable
    public String getTest() {
        return this.m_sTest;
    }

    @Nullable
    public String getRole() {
        return this.m_sRole;
    }

    @Nonnull
    public EErrorLevel getFlag() {
        return this.m_eFlag;
    }

    @Nonnull
    public SVRLResourceError getAsResourceError(@Nullable String string) {
        return new SVRLResourceError((IResourceLocation)new ResourceLocation(string, this.m_sLocation), this.m_eFlag, this.m_sText, this.m_sTest);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("diagnosticRefs", this.m_aDiagnosticReferences).append("text", (Object)this.m_sText).append("location", (Object)this.m_sLocation).append("test", (Object)this.m_sTest).appendIfNotNull("role", (Object)this.m_sRole).append("flag", (Enum)this.m_eFlag).toString();
    }
}

