/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.bound.xpath;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.phloc.schematron.pure.model.PSRule;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathExpression;

@Immutable
public class PSXPathBoundRule {
    private final PSRule m_aRule;
    private final String m_sRuleExpression;
    private final XPathExpression m_aBoundRuleExpression;
    private final List<PSXPathBoundAssertReport> m_aBoundAssertReports;

    public PSXPathBoundRule(@Nonnull PSRule pSRule, @Nonnull String string, @Nonnull XPathExpression xPathExpression, @Nonnull List<PSXPathBoundAssertReport> list) {
        ValueEnforcer.notNull((Object)pSRule, (String)"Rule");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RuleExpression");
        ValueEnforcer.notNull((Object)xPathExpression, (String)"BoundRuleExpression");
        ValueEnforcer.notNull(list, (String)"BoundAssertReports");
        this.m_aRule = pSRule;
        this.m_sRuleExpression = string;
        this.m_aBoundRuleExpression = xPathExpression;
        this.m_aBoundAssertReports = list;
    }

    @Nonnull
    public PSRule getRule() {
        return this.m_aRule;
    }

    @Nonnull
    public String getRuleExpression() {
        return this.m_sRuleExpression;
    }

    @Nonnull
    public XPathExpression getBoundRuleExpression() {
        return this.m_aBoundRuleExpression;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSXPathBoundAssertReport> getAllBoundAssertReports() {
        return ContainerHelper.newList(this.m_aBoundAssertReports);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("rule", (Object)this.m_aRule).append("ruleExpression", (Object)this.m_sRuleExpression).append("boundRuleExpression", (Object)this.m_aBoundRuleExpression).append("boundAssertReports", this.m_aBoundAssertReports).toString();
    }
}

